/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.trigger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neodatis.odb.core.trigger.DeleteTrigger;
import org.neodatis.odb.core.trigger.InsertTrigger;
import org.neodatis.odb.core.trigger.OIDTrigger;
import org.neodatis.odb.core.trigger.SelectTrigger;
import org.neodatis.odb.core.trigger.Trigger;
import org.neodatis.odb.core.trigger.Triggers;
import org.neodatis.odb.core.trigger.UpdateTrigger;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggersImpl
implements Triggers {
    static final String ALL_CLASS_TRIGGER = "__all_class_";
    protected Map<String, IOdbList<Trigger>> listOfUpdateTriggers;
    protected Map<String, IOdbList<Trigger>> listOfInsertTriggers;
    protected Map<String, IOdbList<Trigger>> listOfDeleteTriggers;
    protected Map<String, IOdbList<Trigger>> listOfSelectTriggers;
    protected Map<String, IOdbList<Trigger>> listOfOIdTriggers;
    protected Map<String, Class> classesNotToCallTriggersOn;

    public TriggersImpl() {
        this.init();
    }

    private void init() {
        this.listOfUpdateTriggers = new OdbHashMap<String, IOdbList<Trigger>>();
        this.listOfDeleteTriggers = new OdbHashMap<String, IOdbList<Trigger>>();
        this.listOfSelectTriggers = new OdbHashMap<String, IOdbList<Trigger>>();
        this.listOfInsertTriggers = new OdbHashMap<String, IOdbList<Trigger>>();
        this.listOfOIdTriggers = new OdbHashMap<String, IOdbList<Trigger>>();
        this.classesNotToCallTriggersOn = new HashMap<String, Class>();
    }

    @Override
    public void addUpdateTriggerFor(String className, UpdateTrigger trigger) {
        IOdbList<Trigger> c;
        if (className == null) {
            className = ALL_CLASS_TRIGGER;
        }
        if ((c = this.listOfUpdateTriggers.get(className)) == null) {
            c = new OdbArrayList<Trigger>();
            this.listOfUpdateTriggers.put(className, c);
        }
        c.add(trigger);
    }

    @Override
    public void addInsertTriggerFor(String className, InsertTrigger trigger) {
        IOdbList<Trigger> c;
        if (className == null) {
            className = ALL_CLASS_TRIGGER;
        }
        if ((c = this.listOfInsertTriggers.get(className)) == null) {
            c = new OdbArrayList<Trigger>();
            this.listOfInsertTriggers.put(className, c);
        }
        c.add(trigger);
    }

    @Override
    public void addDeleteTriggerFor(String className, DeleteTrigger trigger) {
        IOdbList<Trigger> c;
        if (className == null) {
            className = ALL_CLASS_TRIGGER;
        }
        if ((c = this.listOfDeleteTriggers.get(className)) == null) {
            c = new OdbArrayList<Trigger>();
            this.listOfDeleteTriggers.put(className, c);
        }
        c.add(trigger);
    }

    @Override
    public void addSelectTriggerFor(String className, SelectTrigger trigger) {
        IOdbList<Trigger> c;
        if (className == null) {
            className = ALL_CLASS_TRIGGER;
        }
        if ((c = this.listOfSelectTriggers.get(className)) == null) {
            c = new OdbArrayList<Trigger>();
            this.listOfSelectTriggers.put(className, c);
        }
        c.add(trigger);
    }

    @Override
    public boolean hasOidTriggersFor(String classsName) {
        return this.listOfOIdTriggers.containsKey(classsName) || this.listOfOIdTriggers.containsKey(ALL_CLASS_TRIGGER);
    }

    @Override
    public boolean hasDeleteTriggersFor(String classsName) {
        return this.listOfDeleteTriggers.containsKey(classsName) || this.listOfDeleteTriggers.containsKey(ALL_CLASS_TRIGGER);
    }

    @Override
    public boolean hasInsertTriggersFor(String className) {
        return this.listOfInsertTriggers.containsKey(className) || this.listOfInsertTriggers.containsKey(ALL_CLASS_TRIGGER);
    }

    @Override
    public boolean hasSelectTriggersFor(String className) {
        return this.listOfSelectTriggers.containsKey(className) || this.listOfSelectTriggers.containsKey(ALL_CLASS_TRIGGER);
    }

    @Override
    public boolean hasUpdateTriggersFor(String className) {
        return this.listOfUpdateTriggers.containsKey(className) || this.listOfUpdateTriggers.containsKey(ALL_CLASS_TRIGGER);
    }

    @Override
    public IOdbList<Trigger> getListOfOidTriggersFor(String className) {
        IOdbList<Trigger> l1 = this.listOfOIdTriggers.get(className);
        IOdbList<Trigger> l2 = this.listOfOIdTriggers.get(ALL_CLASS_TRIGGER);
        if (l2 != null) {
            int size = l2.size();
            if (l1 != null) {
                size += l1.size();
            }
            OdbArrayList<Trigger> r = new OdbArrayList<Trigger>(size);
            if (l1 != null) {
                r.addAll(l1);
            }
            r.addAll(l2);
            return r;
        }
        return l1;
    }

    @Override
    public IOdbList<Trigger> getListOfDeleteTriggersFor(String className) {
        IOdbList<Trigger> l1 = this.listOfDeleteTriggers.get(className);
        IOdbList<Trigger> l2 = this.listOfDeleteTriggers.get(ALL_CLASS_TRIGGER);
        if (l2 != null) {
            int size = l2.size();
            if (l1 != null) {
                size += l1.size();
            }
            OdbArrayList<Trigger> r = new OdbArrayList<Trigger>(size);
            if (l1 != null) {
                r.addAll(l1);
            }
            r.addAll(l2);
            return r;
        }
        return l1;
    }

    @Override
    public IOdbList<Trigger> getListOfInsertTriggersFor(String className) {
        IOdbList<Trigger> l1 = this.listOfInsertTriggers.get(className);
        IOdbList<Trigger> l2 = this.listOfInsertTriggers.get(ALL_CLASS_TRIGGER);
        if (l2 != null) {
            int size = l2.size();
            if (l1 != null) {
                size += l1.size();
            }
            OdbArrayList<Trigger> r = new OdbArrayList<Trigger>(size);
            if (l1 != null) {
                r.addAll(l1);
            }
            r.addAll(l2);
            return r;
        }
        return l1;
    }

    @Override
    public IOdbList<Trigger> getListOfSelectTriggersFor(String className) {
        IOdbList<Trigger> l1 = this.listOfSelectTriggers.get(className);
        IOdbList<Trigger> l2 = this.listOfSelectTriggers.get(ALL_CLASS_TRIGGER);
        if (l2 != null) {
            int size = l2.size();
            if (l1 != null) {
                size += l1.size();
            }
            OdbArrayList<Trigger> r = new OdbArrayList<Trigger>(size);
            if (l1 != null) {
                r.addAll(l1);
            }
            r.addAll(l2);
            return r;
        }
        return l1;
    }

    @Override
    public IOdbList<Trigger> getListOfUpdateTriggersFor(String className) {
        IOdbList<Trigger> l1 = this.listOfUpdateTriggers.get(className);
        IOdbList<Trigger> l2 = this.listOfUpdateTriggers.get(ALL_CLASS_TRIGGER);
        if (l2 != null) {
            int size = l2.size();
            if (l1 != null) {
                size += l1.size();
            }
            OdbArrayList<Trigger> r = new OdbArrayList<Trigger>(size);
            if (l1 != null) {
                r.addAll(l1);
            }
            r.addAll(l2);
            return r;
        }
        return l1;
    }

    @Override
    public void addOidTriggerFor(String className, OIDTrigger trigger) {
        IOdbList<Trigger> c;
        if (className == null) {
            className = ALL_CLASS_TRIGGER;
        }
        if ((c = this.listOfOIdTriggers.get(className)) == null) {
            c = new OdbArrayList<Trigger>();
            this.listOfOIdTriggers.put(className, c);
        }
        c.add(trigger);
    }

    @Override
    public boolean callTriggerOnClass(String className) {
        return !this.classesNotToCallTriggersOn.containsKey(className);
    }

    @Override
    public void resetClassesNotToCallTriggersOn() {
        this.classesNotToCallTriggersOn.clear();
    }

    @Override
    public void addClassesNotToCallTriggersOn(List<Class> classes) {
        for (Class c : classes) {
            this.classesNotToCallTriggersOn.put(c.getName(), c);
        }
    }
}

