/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.trigger;

import java.util.List;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.IError;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ObjectRepresentationImpl;
import org.neodatis.odb.core.session.ExecutionType;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.trigger.DeleteTrigger;
import org.neodatis.odb.core.trigger.InsertTrigger;
import org.neodatis.odb.core.trigger.OIDTrigger;
import org.neodatis.odb.core.trigger.SelectTrigger;
import org.neodatis.odb.core.trigger.Trigger;
import org.neodatis.odb.core.trigger.TriggerManager;
import org.neodatis.odb.core.trigger.Triggers;
import org.neodatis.odb.core.trigger.TriggersImpl;
import org.neodatis.odb.core.trigger.UpdateTrigger;
import org.neodatis.odb.main.ODBForTrigger;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.list.IOdbList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerManagerImpl
implements TriggerManager {
    Session session;
    protected Triggers triggers;
    protected boolean triggersAreActive;

    public TriggerManagerImpl(Session session) {
        this.session = session;
        this.triggers = new TriggersImpl();
        this.triggersAreActive = true;
    }

    public TriggerManagerImpl(Session session, Triggers triggers) {
        this.session = session;
        this.triggers = triggers;
        this.triggersAreActive = true;
    }

    @Override
    public boolean manageInsertTriggerBefore(String className, Object object) {
        if (!this.triggersAreActive) {
            return false;
        }
        if (!this.callTriggerOnClass(className)) {
            return false;
        }
        if (this.hasInsertTriggersFor(className)) {
            Object var3_3 = null;
            for (InsertTrigger insertTrigger : this.triggers.getListOfInsertTriggersFor(className)) {
                if (insertTrigger.getOdb() == null || insertTrigger.getOdb().isClosed()) {
                    insertTrigger.setOdb(new ODBForTrigger(this.session));
                }
                try {
                    if (this.isNull(object)) continue;
                    insertTrigger.beforeInsert(this.transform(object, insertTrigger));
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.BEFORE_INSERT_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(insertTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, false));
                    if (!this.session.getConfig().displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
        return true;
    }

    @Override
    public void manageInsertTriggerAfter(String className, Object object, ObjectOid oid) {
        if (!this.triggersAreActive) {
            return;
        }
        if (!this.callTriggerOnClass(className)) {
            return;
        }
        if (this.hasInsertTriggersFor(className)) {
            Object var4_4 = null;
            for (InsertTrigger insertTrigger : this.getListOfInsertTriggersFor(className)) {
                if (insertTrigger.getOdb() == null) {
                    insertTrigger.setOdb(new ODBForTrigger(this.session));
                }
                try {
                    insertTrigger.afterInsert(this.transform(object, insertTrigger), oid);
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.AFTER_INSERT_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(insertTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, false));
                    if (!this.session.getConfig().displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
    }

    @Override
    public boolean manageUpdateTriggerBefore(String className, NonNativeObjectInfo oldNnoi, Object newObject, ObjectOid oid) {
        if (!this.triggersAreActive) {
            return false;
        }
        if (!this.callTriggerOnClass(className)) {
            return false;
        }
        if (this.hasUpdateTriggersFor(className)) {
            Object var5_5 = null;
            for (UpdateTrigger updateTrigger : this.getListOfUpdateTriggersFor(className)) {
                if (updateTrigger.getOdb() == null) {
                    updateTrigger.setOdb(new ODBForTrigger(this.session));
                }
                try {
                    updateTrigger.beforeUpdate(new ObjectRepresentationImpl(oldNnoi, this.session.getEngine().getObjectIntrospector()), this.transform(newObject, updateTrigger), oid);
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.BEFORE_UPDATE_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(updateTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, false));
                    if (!this.session.getConfig().displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
        return true;
    }

    @Override
    public void manageUpdateTriggerAfter(String className, NonNativeObjectInfo oldNnoi, Object newObject, ObjectOid oid) {
        if (!this.triggersAreActive) {
            return;
        }
        if (!this.callTriggerOnClass(className)) {
            return;
        }
        if (this.hasUpdateTriggersFor(className)) {
            Object var5_5 = null;
            for (UpdateTrigger updateTrigger : this.getListOfUpdateTriggersFor(className)) {
                if (updateTrigger.getOdb() == null) {
                    updateTrigger.setOdb(new ODBForTrigger(this.session));
                }
                try {
                    updateTrigger.afterUpdate(new ObjectRepresentationImpl(oldNnoi, this.session.getEngine().getObjectIntrospector()), this.transform(newObject, updateTrigger), oid);
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.AFTER_UPDATE_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(updateTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, false));
                    if (!this.session.getConfig().displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
    }

    @Override
    public boolean manageDeleteTriggerBefore(String className, Object object, ObjectOid oid) {
        if (!this.triggersAreActive) {
            return false;
        }
        if (!this.callTriggerOnClass(className)) {
            return false;
        }
        if (this.hasDeleteTriggersFor(className)) {
            Object var4_4 = null;
            for (DeleteTrigger deleteTrigger : this.getListOfDeleteTriggersFor(className)) {
                if (deleteTrigger.getOdb() == null) {
                    deleteTrigger.setOdb(new ODBForTrigger(this.session));
                }
                try {
                    deleteTrigger.beforeDelete(this.transform(object, deleteTrigger), oid);
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.BEFORE_DELETE_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(deleteTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, true));
                    if (!this.session.getConfig().displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
        return true;
    }

    @Override
    public void manageDeleteTriggerAfter(String className, Object object, ObjectOid oid) {
        if (!this.triggersAreActive) {
            return;
        }
        if (!this.callTriggerOnClass(className)) {
            return;
        }
        if (this.hasDeleteTriggersFor(className)) {
            Object var4_4 = null;
            for (DeleteTrigger deleteTrigger : this.getListOfDeleteTriggersFor(className)) {
                if (deleteTrigger.getOdb() == null) {
                    deleteTrigger.setOdb(new ODBForTrigger(this.session));
                }
                try {
                    deleteTrigger.afterDelete(this.transform(object, deleteTrigger), oid);
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.AFTER_DELETE_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(deleteTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, false));
                    if (!this.session.getConfig().displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
    }

    @Override
    public void manageSelectTriggerAfter(String className, Object object, ObjectOid oid) {
        if (!this.triggersAreActive) {
            return;
        }
        if (!this.callTriggerOnClass(className)) {
            return;
        }
        if (this.hasSelectTriggersFor(className)) {
            Object var4_4 = null;
            for (SelectTrigger selectTrigger : this.getListOfSelectTriggersFor(className)) {
                if (selectTrigger.getOdb() == null) {
                    selectTrigger.setOdb(new ODBForTrigger(this.session));
                }
                if (this.isNull(object)) continue;
                selectTrigger.afterSelect(this.transform(object, selectTrigger), oid);
            }
        }
    }

    @Override
    public boolean manageOidTrigger(String className, Object o, ObjectOid oid) {
        if (!this.triggersAreActive) {
            return false;
        }
        if (!this.callTriggerOnClass(className)) {
            return false;
        }
        if (this.hasOidTriggersFor(className)) {
            Object var4_4 = null;
            for (OIDTrigger oIDTrigger : this.getListOfOidTriggersFor(className)) {
                if (oIDTrigger.getOdb() == null) {
                    oIDTrigger.setOdb(new ODBForTrigger(this.session));
                }
                try {
                    if (this.isNull(o)) continue;
                    Object oo = this.transform(o, oIDTrigger);
                    oIDTrigger.setOid(oo, oid);
                }
                catch (Exception e) {
                    IError warning = NeoDatisError.BEFORE_INSERT_TRIGGER_HAS_THROWN_EXCEPTION.addParameter(oIDTrigger.getClass().getName()).addParameter(OdbString.exceptionToString(e, false));
                    if (!this.session.getConfig().displayWarnings()) continue;
                    DLogger.info(warning);
                }
            }
        }
        return true;
    }

    private boolean triggerIsCompatibleWithSession(Trigger trigger) {
        boolean isServer;
        boolean isClient;
        boolean bl = isClient = ExecutionType.isClient(trigger.getExecutionType()) && ExecutionType.isClient(this.session.getExecutionType());
        if (isClient) {
            return true;
        }
        boolean bl2 = isServer = ExecutionType.isServer(trigger.getExecutionType()) && ExecutionType.isServer(this.session.getExecutionType());
        return isServer;
    }

    protected boolean isNull(Object object) {
        return object == null;
    }

    @Override
    public Object transform(Object object, Trigger trigger) {
        if (ExecutionType.isClient(trigger.getExecutionType())) {
            return object;
        }
        if (object instanceof ObjectRepresentationImpl) {
            ObjectRepresentationImpl or = (ObjectRepresentationImpl)object;
            or.addObserver(this.session);
            return or;
        }
        if (object instanceof NonNativeObjectInfo) {
            ObjectRepresentationImpl or = new ObjectRepresentationImpl((NonNativeObjectInfo)object, this.session.getEngine().getObjectIntrospector());
            or.addObserver(this.session);
            return or;
        }
        return object;
    }

    @Override
    public void addDeleteTriggerFor(String className, DeleteTrigger trigger) {
        this.triggers.addDeleteTriggerFor(className, trigger);
    }

    @Override
    public void addInsertTriggerFor(String className, InsertTrigger trigger) {
        this.triggers.addInsertTriggerFor(className, trigger);
    }

    @Override
    public void addSelectTriggerFor(String className, SelectTrigger trigger) {
        this.triggers.addSelectTriggerFor(className, trigger);
    }

    @Override
    public void addUpdateTriggerFor(String className, UpdateTrigger trigger) {
        this.triggers.addUpdateTriggerFor(className, trigger);
    }

    @Override
    public IOdbList<Trigger> getListOfDeleteTriggersFor(String className) {
        return this.triggers.getListOfDeleteTriggersFor(className);
    }

    @Override
    public IOdbList<Trigger> getListOfInsertTriggersFor(String className) {
        return this.triggers.getListOfInsertTriggersFor(className);
    }

    @Override
    public IOdbList<Trigger> getListOfOidTriggersFor(String className) {
        return this.triggers.getListOfOidTriggersFor(className);
    }

    @Override
    public IOdbList<Trigger> getListOfSelectTriggersFor(String className) {
        return this.triggers.getListOfSelectTriggersFor(className);
    }

    @Override
    public IOdbList<Trigger> getListOfUpdateTriggersFor(String className) {
        return this.triggers.getListOfUpdateTriggersFor(className);
    }

    @Override
    public boolean hasDeleteTriggersFor(String classsName) {
        return this.triggers.hasDeleteTriggersFor(classsName);
    }

    @Override
    public boolean hasInsertTriggersFor(String className) {
        return this.triggers.hasInsertTriggersFor(className);
    }

    @Override
    public boolean hasOidTriggersFor(String classsName) {
        return this.triggers.hasOidTriggersFor(classsName);
    }

    @Override
    public boolean hasSelectTriggersFor(String className) {
        return this.triggers.hasSelectTriggersFor(className);
    }

    @Override
    public boolean hasUpdateTriggersFor(String className) {
        return this.triggers.hasUpdateTriggersFor(className);
    }

    @Override
    public void addOidTriggerFor(String className, OIDTrigger trigger) {
        this.triggers.addOidTriggerFor(className, trigger);
    }

    @Override
    public void addClassesNotToCallTriggersOn(List<Class> classes) {
        this.triggers.addClassesNotToCallTriggersOn(classes);
    }

    @Override
    public boolean callTriggerOnClass(String className) {
        return this.triggers.callTriggerOnClass(className);
    }

    @Override
    public void resetClassesNotToCallTriggersOn() {
        this.triggers.resetClassesNotToCallTriggersOn();
    }

    @Override
    public synchronized void disableTriggers() {
        this.triggersAreActive = false;
    }

    public synchronized void enableTriggers() {
        this.triggersAreActive = true;
    }
}

