/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.impl.AbstractBTree;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.Objects;
import org.neodatis.odb.Query;
import org.neodatis.odb.Values;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.btree.LazyODBBTreePersister;
import org.neodatis.odb.core.btree.ODBBTreeMultiple;
import org.neodatis.odb.core.btree.ODBBTreeSingle;
import org.neodatis.odb.core.context.ObjectReconnector;
import org.neodatis.odb.core.index.IndexManager;
import org.neodatis.odb.core.layers.layer1.ClassIntrospector;
import org.neodatis.odb.core.layers.layer1.DefaultInstrospectionCallbackForStore;
import org.neodatis.odb.core.layers.layer1.IntrospectionCallback;
import org.neodatis.odb.core.layers.layer1.ObjectIntrospector;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilder;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderContext;
import org.neodatis.odb.core.layers.layer2.instance.InstanceBuilderImpl;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeDeletedObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer2.meta.ObjectRepresentationImpl;
import org.neodatis.odb.core.layers.layer3.Layer3Reader;
import org.neodatis.odb.core.layers.layer3.Layer3ReaderImpl;
import org.neodatis.odb.core.layers.layer3.Layer3Writer;
import org.neodatis.odb.core.layers.layer3.Layer3WriterImpl;
import org.neodatis.odb.core.layers.layer3.OidAndBytes;
import org.neodatis.odb.core.layers.layer4.ClassOidIterator;
import org.neodatis.odb.core.layers.layer4.ObjectOidIterator;
import org.neodatis.odb.core.layers.layer4.OidGenerator;
import org.neodatis.odb.core.layers.layer4.StorageEngine;
import org.neodatis.odb.core.query.IMatchingObjectAction;
import org.neodatis.odb.core.query.InternalQuery;
import org.neodatis.odb.core.query.QueryManager;
import org.neodatis.odb.core.query.ValuesQuery;
import org.neodatis.odb.core.query.criteria.CollectionQueryResultAction;
import org.neodatis.odb.core.query.criteria.CriteriaQuery;
import org.neodatis.odb.core.query.criteria.CriteriaQueryImpl;
import org.neodatis.odb.core.query.criteria.Criterion;
import org.neodatis.odb.core.query.criteria.W;
import org.neodatis.odb.core.query.values.GroupByValuesQueryResultAction;
import org.neodatis.odb.core.query.values.ValuesCriteriaQuery;
import org.neodatis.odb.core.query.values.ValuesQueryResultAction;
import org.neodatis.odb.core.refactor.CheckMetaModelResult;
import org.neodatis.odb.core.refactor.MetaModelEvolutionManagerImpl;
import org.neodatis.odb.core.refactor.RefactorManager;
import org.neodatis.odb.core.refactor.RefactorManagerImpl;
import org.neodatis.odb.core.server.message.Message;
import org.neodatis.odb.core.session.Cache;
import org.neodatis.odb.core.session.Session;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.odb.core.trigger.DeleteTrigger;
import org.neodatis.odb.core.trigger.InsertTrigger;
import org.neodatis.odb.core.trigger.OIDTrigger;
import org.neodatis.odb.core.trigger.SelectTrigger;
import org.neodatis.odb.core.trigger.TriggerManager;
import org.neodatis.odb.core.trigger.TriggerManagerImpl;
import org.neodatis.odb.core.trigger.UpdateTrigger;
import org.neodatis.odb.tool.MemoryMonitor;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionEngineImpl
extends Observable
implements SessionEngine {
    protected Session session;
    protected Cache cache;
    protected ObjectIntrospector objectIntrospector;
    protected IntrospectionCallback callback;
    protected InstanceBuilder instanceBuilder;
    protected Layer3Writer layer3Writer;
    protected Layer3Reader layer3Reader;
    protected StorageEngine storageEngine;
    protected boolean debug = true;
    protected RefactorManager refactorManager;
    protected TriggerManager triggerManager;
    protected IndexManager indexManager;
    protected ObjectReconnector objectReconnector;

    public SessionEngineImpl(Session session) {
        this.session = session;
        this.cache = session.getCache();
        this.initLayer4();
        OidGenerator oidGenerator = this.storageEngine.getOidGenerator();
        ClassIntrospector classIntrospector = session.getConfig().getCoreProvider().getClassIntrospector(session, oidGenerator);
        this.objectIntrospector = session.getConfig().getCoreProvider().getLocalObjectIntrospector(session, classIntrospector, oidGenerator);
        this.triggerManager = new TriggerManagerImpl(session);
        this.callback = new DefaultInstrospectionCallbackForStore(session, this.triggerManager);
        this.instanceBuilder = new InstanceBuilderImpl(session, classIntrospector, this.triggerManager);
        this.layer3Writer = new Layer3WriterImpl(session);
        this.layer3Reader = new Layer3ReaderImpl(session, this.storageEngine);
        this.debug = session.getConfig().debugLayers();
        this.refactorManager = new RefactorManagerImpl(this);
        this.indexManager = new IndexManager(session);
        this.objectReconnector = new ObjectReconnector();
    }

    protected void initLayer4() {
        Class<?> clazz = this.session.getConfig().getStorageEngineClass();
        String storageEngineClassName = null;
        try {
            String directory = this.getEngineDirectoryForBaseName(this.session.getBaseIdentification().getFullIdentification());
            storageEngineClassName = this.getStorageEngineClassName(directory);
            if (clazz != null && storageEngineClassName != null && !storageEngineClassName.equals(clazz.getName())) {
                throw new NeoDatisRuntimeException(NeoDatisError.LAYER4_DIFFERENT_STORAGE_ENGINE.addParameter(storageEngineClassName).addParameter(clazz.getName()));
            }
            if (clazz == null && storageEngineClassName != null) {
                clazz = Class.forName(storageEngineClassName);
            }
            if (clazz == null && storageEngineClassName == null) {
                throw new NeoDatisRuntimeException(NeoDatisError.LAYER4_UNDEFINED);
            }
            this.storageEngine = (StorageEngine)clazz.newInstance();
            if (storageEngineClassName == null && this.storageEngine.useDirectory()) {
                this.writeStorageEngineClassName(directory, clazz.getName());
            }
            this.storageEngine.init(this.session.getConfig());
            this.storageEngine.open(this.session.getBaseIdentification().getFullIdentification(), this.session.getBaseIdentification().getConfig());
        }
        catch (ClassNotFoundException e) {
            throw new NeoDatisRuntimeException(e, "The storage engine plugin class " + storageEngineClassName + " is not in the classpath. Please add the plugin and its dependencies to the Java Classpath");
        }
        catch (Exception e) {
            String className = "undefined";
            if (clazz != null) {
                className = clazz.getName();
            }
            throw new NeoDatisRuntimeException(e, "While creating Layer4 instance of " + className + " : " + e.getMessage());
        }
    }

    private String getEngineDirectoryForBaseName(String fullIdentification) {
        if (this.session.getConfig().getBaseDirectory() != null) {
            fullIdentification = this.session.getConfig().getBaseDirectory() + "/" + fullIdentification;
        }
        return fullIdentification;
    }

    private void writeStorageEngineClassName(String directory, String storageEngineClassName) throws IOException {
        File f = new File(directory);
        if (!f.exists()) {
            f.mkdirs();
        }
        String fileName = f.getAbsolutePath() + "/neodatis.root";
        FileOutputStream fos = new FileOutputStream(fileName);
        fos.write(storageEngineClassName.getBytes());
        fos.close();
    }

    private String getStorageEngineClassName(String directory) throws IOException {
        File f = new File(directory);
        if (!f.exists()) {
            return null;
        }
        String fileName = f.getAbsolutePath() + "/neodatis.root";
        if (!new File(fileName).exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(fileName);
        byte[] bytes = new byte[500];
        int size = fis.read(bytes);
        String className = new String(bytes, 0, size);
        fis.close();
        return className;
    }

    @Override
    public NonNativeObjectInfo layer1ToLayer2(Object object) {
        if (object == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.ODB_CAN_NOT_STORE_NULL_OBJECT);
        }
        Class<?> clazz = object.getClass();
        if (ODBType.isNative(clazz)) {
            throw new NeoDatisRuntimeException(NeoDatisError.ODB_CAN_NOT_STORE_NATIVE_OBJECT_DIRECTLY.addParameter(clazz.getName()).addParameter(ODBType.getFromClass(clazz).getName()).addParameter(clazz.getName()));
        }
        NonNativeObjectInfo nnoi = this.objectIntrospector.getMetaRepresentation(object, this.callback);
        return nnoi;
    }

    protected void checkClose() {
        if (this.session.isClosed()) {
            throw new NeoDatisRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.session.getId()));
        }
        if (this.session.isRollbacked()) {
            throw new NeoDatisRuntimeException(NeoDatisError.ODB_HAS_BEEN_ROLLBACKED.addParameter(this.session.getId().toString()));
        }
    }

    @Override
    public Object layer2ToLayer1(NonNativeObjectInfo nnoi, InstanceBuilderContext context) {
        if (this.debug) {
            DLogger.debug("<start layer2 to layer1 oid=" + nnoi.getOid().oidToString() + ">");
        }
        Object o = this.instanceBuilder.buildOneInstance(nnoi, context);
        if (this.debug) {
            DLogger.debug("<end layer2 to layer1 oid=" + nnoi.getOid().oidToString() + ">");
        }
        return o;
    }

    @Override
    public IOdbList<OidAndBytes> layer2ToLayer3(NonNativeObjectInfo nnoi) {
        if (this.debug) {
            DLogger.debug("<start layer2 to layer3 oid=" + nnoi.getOid().oidToString() + ">");
        }
        IOdbList<OidAndBytes> oidAndBytes = this.layer3Writer.metaToBytes(nnoi);
        if (this.debug) {
            DLogger.debug("<end layer2 to layer3 oid=" + nnoi.getOid().oidToString() + ">");
        }
        return oidAndBytes;
    }

    @Override
    public NonNativeObjectInfo layer3ToLayer2(OidAndBytes oidAndBytes, boolean full, int depth) {
        NonNativeObjectInfo nnoi;
        String fullClassName;
        if (this.debug) {
            DLogger.debug("<start layer3 to layer2 oid=" + oidAndBytes.oid.oidToString() + ">");
        }
        if (this.triggerManager.hasSelectTriggersFor(fullClassName = (nnoi = this.layer3Reader.metaFromBytes(oidAndBytes, full, depth)).getClassInfo().getFullClassName())) {
            this.triggerManager.manageSelectTriggerAfter(fullClassName, new ObjectRepresentationImpl(nnoi, this.objectIntrospector), nnoi.getOid());
        }
        if (this.debug) {
            DLogger.debug("<end layer3 to layer2 oid=" + nnoi.getOid().oidToString() + ">");
        }
        return nnoi;
    }

    @Override
    public NonNativeObjectInfo layer3ToLayer2(IOdbList<OidAndBytes> oabs, boolean full, Map<OID, OID> oidsToReplace, int depth) {
        if (this.debug) {
            DLogger.debug("<start layer3 to layer2 oid=" + oabs.get((int)0).oid.oidToString() + ">");
        }
        NonNativeObjectInfo nnoi = this.layer3Reader.metaFromBytes(oabs, full, oidsToReplace, depth);
        if (this.debug) {
            DLogger.debug("<end layer3 to layer2 oid=" + nnoi.getOid().oidToString() + ">");
        }
        return nnoi;
    }

    @Override
    public OID layer3ToLayer4(IOdbList<OidAndBytes> oidsAndBytes) {
        int nb = oidsAndBytes.size();
        OID mainOid = oidsAndBytes.get((int)0).oid;
        for (int i = 0; i < nb; ++i) {
            ClassInfo ci;
            OidAndBytes oab = oidsAndBytes.get(i);
            this.storageEngine.write(oab);
            if (!oab.isObject() || (ci = oab.nnoi.getClassInfo()).isSystemClass()) continue;
            if (oab.oid.isNew()) {
                this.indexManager.manageIndexesForInsert(oab.oid, oab.nnoi);
                this.insertTriggerAfter(oab.nnoi);
                continue;
            }
            boolean hasIndex = oab.nnoi.getClassInfo().hasIndex();
            if (hasIndex) {
                NonNativeObjectInfo oldNnoi = this.getMetaObjectFromOid((ObjectOid)oab.oid, true, new InstanceBuilderContext(true, null, 1));
                this.indexManager.manageIndexesForUpdate(oab.oid, oab.nnoi, oldNnoi);
            }
            this.updateTriggerAfter(oab.nnoi);
        }
        return mainOid;
    }

    protected void updateTriggerAfter(NonNativeObjectInfo nnoi) {
        if (this.session.isLocal()) {
            this.triggerManager.manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), nnoi, nnoi.getObject(), nnoi.getOid());
        } else {
            this.triggerManager.manageUpdateTriggerAfter(nnoi.getClassInfo().getFullClassName(), nnoi, nnoi, nnoi.getOid());
        }
    }

    protected void insertTriggerAfter(NonNativeObjectInfo nnoi) {
        if (this.session.isLocal()) {
            this.triggerManager.manageInsertTriggerAfter(nnoi.getClassInfo().getFullClassName(), nnoi.getObject(), nnoi.getOid());
        } else {
            this.triggerManager.manageInsertTriggerAfter(nnoi.getClassInfo().getFullClassName(), nnoi, nnoi.getOid());
        }
    }

    @Override
    public OidAndBytes layer4ToLayer3(OID oid) {
        if (this.debug) {
            DLogger.debug("<start layer4 to layer3 oid=" + oid.oidToString() + ">");
        }
        OidAndBytes oab = this.storageEngine.read(oid, true);
        if (this.debug) {
            DLogger.debug("<end layer4 to layer3 oid=" + oid.oidToString() + ">");
        }
        return oab;
    }

    @Override
    public ObjectOid store(ObjectOid oid, Object object) {
        this.checkClose();
        if (oid != null) {
            this.cache.addObject(oid, object);
        }
        NonNativeObjectInfo nnoi = this.layer1ToLayer2(object);
        IOdbList<OidAndBytes> oidAndBytes = this.layer2ToLayer3(nnoi);
        ObjectOid mainOid = (ObjectOid)this.layer3ToLayer4(oidAndBytes);
        return mainOid;
    }

    @Override
    public ObjectOid storeMeta(ObjectOid oid, NonNativeObjectInfo nnoi) {
        this.checkClose();
        IOdbList<OidAndBytes> oidAndBytes = this.layer2ToLayer3(nnoi);
        this.layer3ToLayer4(oidAndBytes);
        return nnoi.getOid();
    }

    @Override
    public ObjectOid store(Object object) {
        return this.store(null, object);
    }

    @Override
    public ObjectOidIterator getObjectOidIterator(ClassOid classOid, ObjectOidIterator.Way way) {
        this.checkClose();
        int oidType = 4;
        return this.storageEngine.getObjectOidIterator(classOid, way);
    }

    @Override
    public ClassOidIterator getClassOidIterator() {
        return this.storageEngine.getClassOidIterator();
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public ObjectOid delete(Object o, boolean cascade) {
        boolean withIndex;
        this.checkClose();
        if (o == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.CAN_NOT_DELETE_NULL_OBJECT);
        }
        ObjectOid oid = this.cache.getOid(o, false);
        if (oid == null && (oid = this.objectReconnector.tryToGetOid(o)) == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.DELETE_OBJECT_NOT_LOADED_OR_CONNECTED);
        }
        ClassInfo ci = this.session.getMetaModel().getClassInfoFromId(oid.getClassOid());
        boolean bl = withIndex = !ci.getIndexes().isEmpty();
        if (withIndex) {
            NonNativeObjectInfo nnoi = this.getMetaObjectFromOid(oid, true, new InstanceBuilderContext(true, null, 1));
            this.indexManager.manageIndexesForDelete(oid, nnoi);
        }
        this.internalDeleteObjectWithOid(oid, cascade, false);
        this.triggerManager.manageDeleteTriggerAfter(this.session.getMetaModel().getClassInfoFromId(oid.getClassOid()).getFullClassName(), o, oid);
        return oid;
    }

    @Override
    public void deleteObjectWithOid(ObjectOid oid, boolean cascade) {
        this.internalDeleteObjectWithOid(oid, cascade, true);
    }

    protected void internalDeleteObjectWithOid(ObjectOid oid, boolean cascade, boolean callTriggerAndIndex) {
        if (callTriggerAndIndex) {
            boolean withIndex;
            ClassInfo ci = this.session.getMetaModel().getClassInfoFromId(oid.getClassOid());
            boolean bl = withIndex = !ci.getIndexes().isEmpty();
            if (withIndex) {
                NonNativeObjectInfo nnoi = this.getMetaObjectFromOid(oid, true, new InstanceBuilderContext(true, null, 1));
                this.indexManager.manageIndexesForDelete(oid, nnoi);
            }
            this.triggerManager.manageDeleteTriggerAfter(this.session.getMetaModel().getClassInfoFromId(oid.getClassOid()).getFullClassName(), null, oid);
        }
        this.storageEngine.deleteObjectWithOid(oid);
        this.cache.remove(oid);
    }

    @Override
    public AttributeValuesMap getFieldValuesFromOid(OID oid, HashSet<String> involvedFields, boolean optimizeObjectCompararison, int depth) {
        OidAndBytes oab = this.layer4ToLayer3(oid);
        if (oab == null) {
            return null;
        }
        AttributeValuesMap values = this.layer3Reader.valuesFromBytes(oab, involvedFields, depth);
        return values;
    }

    @Override
    public NonNativeObjectInfo getMetaObjectFromOid(ObjectOid oid, boolean throwExceptionIfNotExist, InstanceBuilderContext context) {
        OidAndBytes oab = this.layer4ToLayer3(oid);
        if (oab == null) {
            if (throwExceptionIfNotExist) {
                throw new NeoDatisRuntimeException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST.addParameter(oid.oidToString()));
            }
            return new NonNativeDeletedObjectInfo(oid);
        }
        NonNativeObjectInfo nnoi = this.layer3ToLayer2(oab, true, context.depth);
        return nnoi;
    }

    @Override
    public OidAndBytes getBytesOfObjectFromOid(ObjectOid oid, boolean throwExceptionIfNotExist) {
        OidAndBytes oab = this.layer4ToLayer3(oid);
        if (oab == null && throwExceptionIfNotExist) {
            throw new NeoDatisRuntimeException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST.addParameter(oid.oidToString()));
        }
        return oab;
    }

    @Override
    public ObjectInfoHeader getMetaHeaderFromOid(ObjectOid oid, boolean throwExceptinIfNotFound, boolean useCache) {
        OidAndBytes oab = this.layer4ToLayer3(oid);
        if (oab == null) {
            if (throwExceptinIfNotFound) {
                throw new NeoDatisRuntimeException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST.addParameter(oid));
            }
            return null;
        }
        NonNativeObjectInfo nnoi = this.layer3ToLayer2(oab, false, 1);
        return nnoi.getHeader();
    }

    @Override
    public Object getObjectFromOid(ObjectOid oid, boolean throwExceptionIfNotFound, InstanceBuilderContext context) {
        this.checkClose();
        NonNativeObjectInfo nnoi = this.getMetaObjectFromOid(oid, throwExceptionIfNotFound, context);
        Object o = this.layer2ToLayer1(nnoi, context);
        return o;
    }

    @Override
    public ObjectOid getObjectOid(Object object, boolean throwExceptionIfNotFound) {
        this.checkClose();
        ObjectOid oid = this.session.getCache().getOid(object, throwExceptionIfNotFound);
        return oid;
    }

    @Override
    public void addIndexOn(String className, String indexName, String[] indexFields, boolean verbose, boolean acceptMultipleValuesForSameKey) {
        this.checkClose();
        ClassInfo classInfo = this.session.getClassInfo(className);
        if (classInfo.hasIndex(indexName)) {
            throw new NeoDatisRuntimeException(NeoDatisError.INDEX_ALREADY_EXIST.addParameter(indexName).addParameter(className));
        }
        ClassInfoIndex cii = classInfo.addIndexOn(indexName, indexFields, acceptMultipleValuesForSameKey);
        AbstractBTree btree = null;
        btree = acceptMultipleValuesForSameKey ? new ODBBTreeMultiple(className, this.session.getConfig().getDefaultIndexBTreeDegree(), new LazyODBBTreePersister(this)) : new ODBBTreeSingle(className, this.session.getConfig().getDefaultIndexBTreeDegree(), new LazyODBBTreePersister(this));
        cii.setBTree(btree);
        this.store(cii);
        if (verbose) {
            DLogger.info("Creating index " + indexName + " on class " + className);
        }
        CriteriaQueryImpl q = this.criteriaQuery(className);
        q.getQueryParameters().setInMemory(false);
        Objects objects = this.getMetaObjects(q);
        if (verbose) {
            DLogger.info(indexName + " : " + objects.size() + " object(s) loaded to update the index");
        }
        NonNativeObjectInfo nnoi = null;
        int i = 0;
        boolean monitorMemory = this.session.getConfig().monitoringMemory();
        while (objects.hasNext()) {
            nnoi = (NonNativeObjectInfo)objects.next();
            btree.insert(cii.computeKey(nnoi), nnoi.getOid());
            if (verbose && i % 1000 == 0 && monitorMemory) {
                MemoryMonitor.displayCurrentMemory("Index " + indexName + " " + i + " objects inserted", true);
            }
            ++i;
        }
        if (verbose) {
            DLogger.info(indexName + " created!");
        }
    }

    @Override
    public void addInsertTriggerFor(String className, InsertTrigger trigger) {
        this.checkClose();
        this.triggerManager.addInsertTriggerFor(className, trigger);
    }

    @Override
    public void addSelectTriggerFor(String className, SelectTrigger trigger) {
        this.checkClose();
        this.triggerManager.addSelectTriggerFor(className, trigger);
    }

    @Override
    public void addUpdateTriggerFor(String className, UpdateTrigger trigger) {
        this.checkClose();
        this.triggerManager.addUpdateTriggerFor(className, trigger);
    }

    @Override
    public void addOidTriggerFor(String className, OIDTrigger trigger) {
        this.checkClose();
        this.triggerManager.addOidTriggerFor(className, trigger);
    }

    @Override
    public void addDeleteTriggerFor(String className, DeleteTrigger trigger) {
        this.checkClose();
        this.triggerManager.addDeleteTriggerFor(className, trigger);
    }

    @Override
    public CriteriaQueryImpl criteriaQuery(Class clazz, Criterion criterion) {
        this.checkClose();
        CriteriaQueryImpl q = new CriteriaQueryImpl(clazz, criterion);
        q.setSessionEngine(this);
        if (criterion != null) {
            criterion.ready();
        }
        return q;
    }

    @Override
    public CriteriaQuery criteriaQuery(String className, Criterion criterion) {
        this.checkClose();
        CriteriaQueryImpl q = new CriteriaQueryImpl(className, criterion);
        q.setSessionEngine(this);
        if (criterion != null) {
            criterion.ready();
        }
        return q;
    }

    @Override
    public CriteriaQueryImpl criteriaQuery(String className) {
        this.checkClose();
        CriteriaQueryImpl q = new CriteriaQueryImpl(className);
        q.setSessionEngine(this);
        return q;
    }

    @Override
    public CriteriaQuery criteriaQuery(Class clazz) {
        this.checkClose();
        CriteriaQueryImpl q = new CriteriaQueryImpl(clazz);
        q.setSessionEngine(this);
        return q;
    }

    @Override
    public void defragmentTo(String newFileName) {
        this.checkClose();
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_SUPPORTED);
    }

    @Override
    public void deleteIndex(String fullClassName, String indexName, boolean verbose) {
        this.checkClose();
        ClassInfo classInfo = this.session.getMetaModel().getClassInfo(fullClassName, true);
        if (!classInfo.hasIndex(indexName)) {
            throw new NeoDatisRuntimeException(NeoDatisError.INDEX_DOES_NOT_EXIST.addParameter(indexName).addParameter(fullClassName));
        }
        ClassInfoIndex cii = classInfo.getIndexWithName(indexName);
        if (verbose) {
            DLogger.info("Deleting index " + indexName + " on class " + fullClassName);
        }
        this.delete(cii, true);
        classInfo.removeIndex(cii);
        this.storeClassInfo(classInfo);
        if (verbose) {
            DLogger.info("Index " + indexName + " deleted");
        }
    }

    @Override
    public void disconnect(Object object) {
    }

    @Override
    public <T> Objects<T> getMetaObjects(InternalQuery query) {
        this.checkClose();
        boolean returnObjects = false;
        CollectionQueryResultAction queryResultAction = new CollectionQueryResultAction(query, this, returnObjects);
        return QueryManager.getQueryExecutor(query, this).execute(queryResultAction);
    }

    @Override
    public <T> Objects<T> execute(InternalQuery query) {
        this.checkClose();
        if (query instanceof ValuesCriteriaQuery) {
            throw new NeoDatisRuntimeException(NeoDatisError.VALUES_QUERY_MUST_USE_GET_VALUES);
        }
        boolean returnObjects = true;
        CollectionQueryResultAction queryResultAction = new CollectionQueryResultAction(query, this, returnObjects);
        return QueryManager.getQueryExecutor(query, this).execute(queryResultAction);
    }

    @Override
    public Values getValues(ValuesQuery valuesQuery) {
        this.checkClose();
        valuesQuery.setSessionEngine(this);
        IMatchingObjectAction queryResultAction = null;
        queryResultAction = valuesQuery.hasGroupBy() ? new GroupByValuesQueryResultAction(valuesQuery, this, this.instanceBuilder) : new ValuesQueryResultAction(valuesQuery, this, this.instanceBuilder);
        Objects r = QueryManager.getQueryExecutor(valuesQuery, this).execute(queryResultAction);
        return (Values)r;
    }

    @Override
    public void rebuildIndex(String fullClassName, String indexName, boolean verbose) {
        ClassInfo classInfo;
        this.checkClose();
        if (verbose) {
            DLogger.info("Rebuilding index " + indexName + " on class " + fullClassName);
        }
        if (!(classInfo = this.session.getMetaModel().getClassInfo(fullClassName, true)).hasIndex(indexName)) {
            throw new NeoDatisRuntimeException(NeoDatisError.INDEX_DOES_NOT_EXIST.addParameter(indexName).addParameter(fullClassName));
        }
        ClassInfoIndex cii = classInfo.getIndexWithName(indexName);
        this.deleteIndex(fullClassName, indexName, verbose);
        this.addIndexOn(fullClassName, indexName, classInfo.getAttributeNames(cii.getAttributeIds()), verbose, !cii.isUnique());
    }

    @Override
    public void reconnect(Object object) {
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED.addParameter("getValues()"));
    }

    @Override
    public RefactorManager getRefactorManager() {
        return this.refactorManager;
    }

    @Override
    public ClassInfoList introspectClass(String fullClassName) {
        return this.objectIntrospector.getClassIntrospector().introspect(fullClassName);
    }

    @Override
    public void commit() {
        this.checkClose();
        this.storageEngine.getOidGenerator().commit();
        this.storageEngine.commit();
    }

    @Override
    public void close() {
        if (this.session.isClosed()) {
            throw new NeoDatisRuntimeException(NeoDatisError.ODB_IS_CLOSED.addParameter(this.session.getId()));
        }
        this.storageEngine.close();
    }

    @Override
    public StorageEngine getStorageEngine() {
        return this.storageEngine;
    }

    @Override
    public ObjectIntrospector getObjectIntrospector() {
        return this.objectIntrospector;
    }

    @Override
    public void storeClassInfos(ClassInfoList ciList) {
        Collection<ClassInfo> c = ciList.getClassInfos();
        for (ClassInfo ci : c) {
            this.storeClassInfo(ci);
        }
    }

    @Override
    public void storeClassInfo(ClassInfo ci) {
        IOdbList<OidAndBytes> oidsAndBytes = this.layer3Writer.classInfoToBytes(ci);
        this.layer3ToLayer4(oidsAndBytes);
    }

    @Override
    public ClassInfo classInfoFromBytes(OidAndBytes oab, boolean full) {
        return this.layer3Reader.classInfoFromBytes(oab, full);
    }

    @Override
    public MetaModel loadMetaModel(MetaModel metaModel) {
        ClassOidIterator iterator = this.storageEngine.getClassOidIterator();
        HashMap<ClassOid, OidAndBytes> classInfoBytes = new HashMap<ClassOid, OidAndBytes>();
        while (iterator.hasNext()) {
            ClassOid classOid = iterator.next();
            OidAndBytes bytesClassInfo = this.storageEngine.read(classOid, true);
            classInfoBytes.put(classOid, bytesClassInfo);
            if (bytesClassInfo == null) continue;
            ClassInfo ci = this.layer3Reader.classInfoFromBytes(bytesClassInfo, false);
            metaModel.addClass(ci, false);
        }
        for (ClassOid classOid : classInfoBytes.keySet()) {
            OidAndBytes bytesClassInfo = (OidAndBytes)classInfoBytes.get(classOid);
            if (bytesClassInfo == null) continue;
            ClassInfo ci = this.layer3Reader.classInfoFromBytes(bytesClassInfo, true);
            metaModel.addClass(ci, true);
        }
        OdbArrayList<ClassInfoIndex> indexes = null;
        LazyODBBTreePersister persister = null;
        ClassInfoIndex cii = null;
        CriteriaQueryImpl queryClassInfo = null;
        IBTree btree = null;
        for (ClassInfo classInfo : metaModel.getAllClasses()) {
            indexes = new OdbArrayList<ClassInfoIndex>();
            queryClassInfo = this.criteriaQuery(ClassInfoIndex.class, W.equal("classInfoId", classInfo.getOid()));
            Objects classIndexes = queryClassInfo.objects();
            indexes.addAll(classIndexes);
            for (int j = 0; j < indexes.size(); ++j) {
                cii = (ClassInfoIndex)indexes.get(j);
                persister = new LazyODBBTreePersister(this);
                btree = cii.getBTree();
                btree.setPersister(persister);
                btree.getRoot().setBTree(btree);
            }
            if (this.debug) {
                DLogger.debug("Reading indexes for " + classInfo.getFullClassName() + " : " + indexes.size() + " indexes");
            }
            classInfo.setIndexes(indexes);
        }
        if (this.session.getConfig().checkMetaModelCompatibility()) {
            new MetaModelEvolutionManagerImpl(this.session).check(this.session.getConfig().checkMetaModelCompatibility(), true, this.session.getConfig().logSchemaEvolutionAnalysis());
        }
        return metaModel;
    }

    @Override
    public boolean existOid(OID oid) {
        return this.storageEngine.existOid(oid);
    }

    @Override
    public String getFileFormatVersion() {
        return "1";
    }

    @Override
    public TriggerManager getTriggerManager() {
        return this.triggerManager;
    }

    @Override
    public void rollback() {
        this.checkClose();
        this.storageEngine.rollback();
    }

    @Override
    public CheckMetaModelResult checkMetaModelCompatibility(Map<String, ClassInfo> currentCIs) {
        return null;
    }

    @Override
    public BigInteger count(Query query) {
        this.checkClose();
        if (!(query instanceof CriteriaQuery)) {
            throw new NeoDatisRuntimeException("count only works with Criteria queries for instance :-(");
        }
        ValuesQuery q = new ValuesCriteriaQuery((CriteriaQuery)query).count("count");
        q.setPolymorphic(query.isPolymorphic());
        Values values = this.getValues(q);
        BigInteger count = (BigInteger)values.nextValues().getByIndex(0);
        return count;
    }

    @Override
    public OidAndBytes classInfoToBytes(ClassInfo ci) {
        IOdbList<OidAndBytes> oidsAndBytes = this.layer3Writer.classInfoToBytes(ci);
        return oidsAndBytes.get(0);
    }

    @Override
    public void setTriggerManager(TriggerManager triggerManager) {
        this.triggerManager = triggerManager;
    }

    @Override
    public void refresh(Object o, int depth) {
        ObjectOid ooid = this.session.getCache().getOid(o, true);
        InstanceBuilderContext ibc = new InstanceBuilderContext(false, o, depth);
        o = this.getObjectFromOid(ooid, true, ibc);
    }

    @Override
    public ValuesQuery queryValues(Class clazz, Criterion criterion) {
        this.checkClose();
        ValuesCriteriaQuery q = new ValuesCriteriaQuery(clazz, criterion);
        q.setSessionEngine(this);
        if (criterion != null) {
            criterion.ready();
        }
        return q;
    }

    @Override
    public ValuesQuery queryValues(String className, Criterion criterion) {
        this.checkClose();
        ValuesCriteriaQuery q = new ValuesCriteriaQuery(className, criterion);
        q.setSessionEngine(this);
        if (criterion != null) {
            criterion.ready();
        }
        return q;
    }

    @Override
    public ValuesQuery queryValues(String className) {
        this.checkClose();
        ValuesCriteriaQuery q = new ValuesCriteriaQuery(className);
        q.setSessionEngine(this);
        return q;
    }

    @Override
    public ValuesCriteriaQuery queryValues(Class clazz, ObjectOid oid) {
        this.checkClose();
        ValuesCriteriaQuery q = new ValuesCriteriaQuery(clazz, oid);
        q.setSessionEngine(this);
        return q;
    }

    @Override
    public ValuesQuery queryValues(Class clazz) {
        this.checkClose();
        ValuesCriteriaQuery q = new ValuesCriteriaQuery(clazz);
        q.setSessionEngine(this);
        return q;
    }

    @Override
    public Message sendMessage(Message message) {
        throw new NeoDatisRuntimeException("SendMessage is only available in Client/Server mode");
    }
}

