/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server.connection;

import java.util.Map;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.server.connection.ConnectionAction;
import org.neodatis.odb.core.server.connection.IConnection;
import org.neodatis.odb.core.server.connection.SessionManager;
import org.neodatis.odb.core.session.SessionEngine;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class ServerConnectionImpl
implements IConnection {
    public static final String LOG_ID = "Connection";
    private String id;
    private SessionManager connectionManager;
    private SessionEngine sessionEngine;
    private String baseIdentifier;
    private Map<OID, Long> oidsLockedForUpdate;
    private Map<String, Long> lockedClasses;
    private String currentAction;
    private long currentActionStart;
    private long lastActionDuration;
    private String lastAction;
    private int[] actions;

    public ServerConnectionImpl(SessionManager connectionManager, String connectionId, SessionEngine storageEngine) {
        this.connectionManager = connectionManager;
        this.id = connectionId;
        this.sessionEngine = storageEngine;
        this.baseIdentifier = storageEngine.getSession().getBaseIdentification().getBaseId();
        this.oidsLockedForUpdate = new OdbHashMap<OID, Long>();
        this.lockedClasses = new OdbHashMap<String, Long>();
        this.actions = new int[ConnectionAction.getNumberOfActions()];
    }

    public String getId() {
        return this.id;
    }

    public SessionEngine getSessionEngine() {
        return this.sessionEngine;
    }

    public void close() throws Exception {
        this.commit();
    }

    public void commit() throws Exception {
        this.sessionEngine.commit();
        this.releaseOidLocks();
        this.releaseClassLocks();
    }

    protected void releaseOidLocks() throws InterruptedException {
        OID oid2 = null;
        for (OID oid2 : this.oidsLockedForUpdate.keySet()) {
            this.connectionManager.unlockOidForSession(oid2, null);
            if (!this.sessionEngine.getSession().getConfig().isDebugEnabled(LOG_ID)) continue;
            DLogger.debug("Release object lock for " + oid2);
        }
        this.oidsLockedForUpdate.clear();
    }

    protected void releaseClassLocks() throws InterruptedException {
        for (String fullClassName : this.lockedClasses.keySet()) {
            this.connectionManager.unlockClass(fullClassName, null);
            if (!this.sessionEngine.getSession().getConfig().isDebugEnabled(LOG_ID)) continue;
            DLogger.debug("Release class lock for " + fullClassName);
        }
        this.lockedClasses.clear();
    }

    public synchronized void unlockObjectWithOid(OID oid) throws Exception {
        this.connectionManager.unlockOidForSession(oid, null);
        this.oidsLockedForUpdate.remove(oid);
    }

    public synchronized void unlockClass(String fullClassName) throws Exception {
        this.connectionManager.unlockClass(fullClassName, null);
        this.lockedClasses.remove(fullClassName);
    }

    public void rollback() throws Exception {
        this.sessionEngine.rollback();
        this.releaseOidLocks();
        this.releaseClassLocks();
    }

    public synchronized boolean lockObjectWithOid(OID oid) throws InterruptedException {
        this.connectionManager.lockOidForSession(oid, null, 100L);
        this.oidsLockedForUpdate.put(oid, new Long(OdbTime.getCurrentTimeInMs()));
        return true;
    }

    public boolean lockClass(String fullClassName) throws InterruptedException {
        this.connectionManager.lockClassForSession(fullClassName, null, 1000L);
        this.lockedClasses.put(fullClassName, new Long(OdbTime.getCurrentTimeInMs()));
        return true;
    }

    public void setCurrentAction(int action) {
        this.currentActionStart = OdbTime.getCurrentTimeInMs();
        this.currentAction = ConnectionAction.getActionLabel(action);
        this.actions[action] = this.actions[action] + 1;
    }

    public void endCurrentAction() {
        this.lastAction = this.currentAction;
        this.lastActionDuration = OdbTime.getCurrentTimeInMs() - this.currentActionStart;
        this.currentAction = "-";
    }

    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("cid=" + this.id).append("\n\t\t+ Current action : ");
        buffer.append(this.currentAction).append("(").append(OdbTime.getCurrentTimeInMs() - this.currentActionStart).append("ms) | last action : ");
        buffer.append(this.lastAction).append("(").append(this.lastActionDuration).append("ms)");
        buffer.append("\n\t\t+ Actions : ");
        for (int i = 0; i < this.actions.length; ++i) {
            buffer.append(ConnectionAction.getActionLabel(i)).append("=").append(this.actions[i]).append(" | ");
        }
        buffer.append("\n\t\t+ Blocked Oid (").append(this.oidsLockedForUpdate.size()).append(") : ");
        buffer.append(this.oidsLockedForUpdate.keySet());
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ServerConnectionImpl)) {
            return false;
        }
        ServerConnectionImpl c = (ServerConnectionImpl)obj;
        return this.id.equals(c.id);
    }
}

