/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server.connection;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ODBServer;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.server.MessageStreamer;
import org.neodatis.odb.core.server.connection.ClientServerConnection;
import org.neodatis.odb.core.server.message.Message;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbRunnable;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.OdbThread;
import org.neodatis.tool.wrappers.io.MessageStreamerBuilder;

public class RemoteClientServerConnection
extends ClientServerConnection
implements OdbRunnable {
    private static final String LOG_ID = "RemoteClientServerConnection";
    private Socket socketConnection;
    private String name;
    private MessageStreamer messageStreamer;

    public RemoteClientServerConnection(ODBServer server, Socket connection) {
        super(server);
        this.socketConnection = connection;
    }

    /*
     * Loose catch block
     */
    public void run() {
        block21: {
            OutputStream out = null;
            InputStream in = null;
            String messageType = null;
            this.socketConnection.setTcpNoDelay(true);
            this.connectionIsUp = true;
            out = this.socketConnection.getOutputStream();
            in = this.socketConnection.getInputStream();
            this.messageStreamer = MessageStreamerBuilder.getMessageStreamer(this.socketConnection, this.server.getConfig());
            Message message = null;
            Message rmessage = null;
            do {
                messageType = "'No message'";
                message = null;
                message = this.messageStreamer.read();
                if (message != null) {
                    messageType = message.getClass().getName();
                    rmessage = this.manageMessage(message);
                    this.messageStreamer.write(rmessage);
                } else {
                    messageType = "Null Message";
                }
                if (!this.connectionIsUp) break;
            } while (message != null);
            Object var7_9 = null;
            try {
                if (this.messageStreamer != null) {
                    this.messageStreamer.close();
                    this.socketConnection.close();
                }
            }
            catch (IOException e) {
                DLogger.error("Error while closing socket - connection thread baseId=" + this.baseIdentifier + " and cid=" + this.connectionId + ": \n" + OdbString.exceptionToString(e, false));
            }
            if (this.debug) {
                DLogger.info("Exiting thread " + OdbThread.getCurrentThreadName());
            }
            break block21;
            {
                catch (EOFException eoe) {
                    DLogger.error(this.getClass().getSimpleName() + " : Client connection is dead : Thread " + OdbThread.getCurrentThreadName() + ": Error in connection thread baseId=" + this.baseIdentifier + " and cid=" + this.connectionId + " for message of type " + messageType + " : Client has terminated the connection!");
                    this.connectionIsUp = false;
                    Object var7_10 = null;
                    try {
                        if (this.messageStreamer != null) {
                            this.messageStreamer.close();
                            this.socketConnection.close();
                        }
                    }
                    catch (IOException e) {
                        DLogger.error("Error while closing socket - connection thread baseId=" + this.baseIdentifier + " and cid=" + this.connectionId + ": \n" + OdbString.exceptionToString(e, false));
                    }
                    if (this.debug) {
                        DLogger.info("Exiting thread " + OdbThread.getCurrentThreadName());
                    }
                    break block21;
                }
                catch (Throwable e) {
                    String m = OdbString.exceptionToString(e, false);
                    DLogger.error("Thread " + OdbThread.getCurrentThreadName() + ": Error in connection thread baseId=" + this.baseIdentifier + " and cid=" + this.connectionId + " for message of type " + messageType + " : \n" + m);
                    this.connectionIsUp = false;
                    throw new NeoDatisRuntimeException(NeoDatisError.NET_SERIALISATION_ERROR.addParameter(e.getMessage()).addParameter(m));
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    if (this.messageStreamer != null) {
                        this.messageStreamer.close();
                        this.socketConnection.close();
                    }
                }
                catch (IOException e) {
                    DLogger.error("Error while closing socket - connection thread baseId=" + this.baseIdentifier + " and cid=" + this.connectionId + ": \n" + OdbString.exceptionToString(e, false));
                }
                if (this.debug) {
                    DLogger.info("Exiting thread " + OdbThread.getCurrentThreadName());
                }
                throw throwable;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

