/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.server;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neodatis.odb.NeoDatis;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ODB;
import org.neodatis.odb.ODBServer;
import org.neodatis.odb.Release;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer4.IOFileParameter;
import org.neodatis.odb.core.server.connection.ClientServerConnection;
import org.neodatis.odb.core.server.connection.RemoteClientServerConnection;
import org.neodatis.odb.core.server.connection.SessionManager;
import org.neodatis.odb.core.server.trigger.ServerDeleteTrigger;
import org.neodatis.odb.core.server.trigger.ServerInsertTrigger;
import org.neodatis.odb.core.server.trigger.ServerOidTrigger;
import org.neodatis.odb.core.server.trigger.ServerSelectTrigger;
import org.neodatis.odb.core.server.trigger.ServerUpdateTrigger;
import org.neodatis.odb.core.session.Session;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbRunnable;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.OdbThread;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODBServerImpl
implements OdbRunnable,
ODBServer {
    public static final String LOG_ID = "ODBServer";
    private int port;
    private OdbThread thread;
    private boolean serverIsUp;
    private ServerSocket socketServer;
    private boolean isRunning;
    private Map<String, String> bases;
    private Map<String, SessionManager> sessionManagers;
    private boolean automaticallyCreateDatabase;
    private long start;
    protected NeoDatisConfig config;

    public ODBServerImpl(int port, NeoDatisConfig config) {
        this.port = port;
        this.automaticallyCreateDatabase = true;
        this.config = config;
        this.initServer();
    }

    private void initServer() {
        this.bases = new OdbHashMap<String, String>();
        this.sessionManagers = new OdbHashMap<String, SessionManager>();
    }

    private void initSocketServer() {
        try {
            this.socketServer = this.createSocketServer();
            this.isRunning = true;
        }
        catch (BindException e1) {
            this.isRunning = false;
            throw new NeoDatisRuntimeException(NeoDatisError.CLIENT_SERVER_PORT_IS_BUSY.addParameter(this.port), (Throwable)e1);
        }
        catch (IOException e2) {
            this.isRunning = false;
            throw new NeoDatisRuntimeException(NeoDatisError.CLIENT_SERVER_CAN_NOT_OPEN_ODB_SERVER_ON_PORT.addParameter(this.port), (Throwable)e2);
        }
    }

    protected ServerSocket createSocketServer() throws IOException {
        return new ServerSocket(this.port);
    }

    @Override
    public void addBase(String baseIdentifier, String fileName) {
        this.addBase(baseIdentifier, fileName, null, null);
    }

    @Override
    public void addBase(String baseIdentifier, String fileName, String user, String password) {
        this.bases.put(baseIdentifier, fileName);
        NeoDatisConfig config2 = this.config.copy();
        config2.setIsLocal(false);
        if (user != null && password != null) {
            config2.setUser(user);
            config2.setPassword(password);
        }
        this.sessionManagers.put(baseIdentifier, new SessionManager(new IOFileParameter(fileName, true, config2)));
        if (config2.isInfoEnabled(LOG_ID)) {
            DLogger.info("ODBServer:Adding base : name=" + baseIdentifier + " (file=" + fileName + ") to server");
        }
    }

    public void addUserForBase(String baseIdentifier, String user, String password) {
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
    }

    @Override
    public void startServer(boolean inThread) {
        this.initSocketServer();
        if (inThread) {
            this.thread = new OdbThread(this);
            this.thread.start();
        } else {
            this.run();
        }
    }

    @Override
    public void run() {
        try {
            this.startServer();
        }
        catch (IOException e) {
            DLogger.error(OdbString.exceptionToString(e, true));
        }
    }

    public void startServer() throws IOException {
        this.start = OdbTime.getCurrentTimeInMs();
        if (this.config.logServerStartupAndShutdown()) {
            DLogger.info("NeoDatis ODB Server [version=" + Release.RELEASE_NUMBER + " - build=" + Release.RELEASE_BUILD + " - " + Release.RELEASE_DATE + "] running on port " + this.port);
            if (this.bases.size() != 0) {
                DLogger.info("Managed bases: ");
                for (String baseName : this.bases.keySet()) {
                    DLogger.info("\t" + baseName + " => " + this.bases.get(baseName));
                }
            }
        }
        while (this.isRunning) {
            try {
                this.waitForRemoteConnection();
            }
            catch (SocketException e) {
                if (!this.isRunning) continue;
                DLogger.error("ODBServer:ODBServerImpl.startServer:" + OdbString.exceptionToString(e, true));
            }
        }
    }

    public ClientServerConnection waitForRemoteConnection() throws IOException {
        Socket connection = this.socketServer.accept();
        connection.setTcpNoDelay(true);
        RemoteClientServerConnection connectionThread = new RemoteClientServerConnection(this, connection);
        OdbThread thread = new OdbThread(connectionThread);
        connectionThread.setName(thread.getName());
        thread.start();
        return connectionThread;
    }

    @Override
    public void close() {
        if (this.config.logServerStartupAndShutdown()) {
            long end = OdbTime.getCurrentTimeInMs();
            double timeInHour = (double)(end - this.start) / 3600000.0;
            DLogger.info(String.format("NeoDatis ODB Server (port %d) shutdown [uptime=%dHours]", this.port, (long)timeInHour));
        }
        try {
            this.isRunning = false;
            this.socketServer.close();
            Iterator<String> iterator = this.bases.keySet().iterator();
            Object baseIdentifier = null;
            for (String base : this.bases.keySet()) {
                SessionManager sessionManager = this.sessionManagers.get(base);
                for (String sessionId : sessionManager.getSessions().keySet()) {
                    Session session = sessionManager.getSessions().get(sessionId);
                    session.close();
                }
            }
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        catch (Exception e) {
            throw new NeoDatisRuntimeException(NeoDatisError.SERVER_ERROR.addParameter("While closing server"), (Throwable)e);
        }
    }

    @Override
    public void setAutomaticallyCreateDatabase(boolean yes) {
        this.automaticallyCreateDatabase = yes;
    }

    @Override
    public ODB openClient(String baseIdentifier) {
        NeoDatisConfig c = NeoDatis.getConfig().setHostAndPort("localhost", this.getPort());
        DLogger.info("Warning: Client Server Same VM mode not yet supported : using normal client server connection");
        return NeoDatis.openClient(baseIdentifier, c);
    }

    @Override
    public ODB openClient(String baseIdentifier, NeoDatisConfig config) {
        config.setHostAndPort("localhost", this.getPort());
        DLogger.info("Warning: Client Server Same VM mode not yet supported : using normal client server connection");
        return NeoDatis.openClient(baseIdentifier, config);
    }

    @Override
    public void addDeleteTrigger(String baseIdentifier, String className, ServerDeleteTrigger trigger) {
        SessionManager sm = this.sessionManagers.get(baseIdentifier);
        if (sm == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.UNREGISTERED_BASE_ON_SERVER.addParameter(baseIdentifier));
        }
        sm.getTriggers().addDeleteTriggerFor(className, trigger);
    }

    @Override
    public void addInsertTrigger(String baseIdentifier, String className, ServerInsertTrigger trigger) {
        SessionManager sm = this.sessionManagers.get(baseIdentifier);
        if (sm == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.UNREGISTERED_BASE_ON_SERVER.addParameter(baseIdentifier));
        }
        sm.getTriggers().addInsertTriggerFor(className, trigger);
    }

    @Override
    public void addOidTrigger(String baseIdentifier, String className, ServerOidTrigger trigger) {
        SessionManager sm = this.sessionManagers.get(baseIdentifier);
        if (sm == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.UNREGISTERED_BASE_ON_SERVER.addParameter(baseIdentifier));
        }
        sm.getTriggers().addOidTriggerFor(className, trigger);
    }

    @Override
    public void addSelectTrigger(String baseIdentifier, String className, ServerSelectTrigger trigger) {
        SessionManager sm = this.sessionManagers.get(baseIdentifier);
        if (sm == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.UNREGISTERED_BASE_ON_SERVER.addParameter(baseIdentifier));
        }
        sm.getTriggers().addSelectTriggerFor(className, trigger);
    }

    @Override
    public void addUpdateTrigger(String baseIdentifier, String className, ServerUpdateTrigger trigger) {
        SessionManager sm = this.sessionManagers.get(baseIdentifier);
        if (sm == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.UNREGISTERED_BASE_ON_SERVER.addParameter(baseIdentifier));
        }
        sm.getTriggers().addUpdateTriggerFor(className, trigger);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(String.format("%d bases", this.bases.size()));
        for (String baseName : this.bases.keySet()) {
            b.append(String.format("\tBase %s", baseName));
            SessionManager sessionManager = this.sessionManagers.get(baseName);
            for (String sessionId : sessionManager.getSessions().keySet()) {
                Session s = sessionManager.getSession(sessionId);
                b.append(String.format("\n\t\tsession id = %s : %s", sessionId, s.toString()));
            }
        }
        return b.toString();
    }

    @Override
    public SessionManager getSessionManagerForBase(String baseIdentifier) {
        return this.sessionManagers.get(baseIdentifier);
    }

    @Override
    public void removeSessionManagerForBase(String baseId) {
        this.sessionManagers.remove(baseId);
    }

    @Override
    public List<String> getSessionDescriptions() {
        ArrayList<String> descriptions = new ArrayList<String>();
        for (String baseName : this.bases.keySet()) {
            SessionManager sessionManager = this.sessionManagers.get(baseName);
            for (String sessionId : sessionManager.getSessions().keySet()) {
                Session s = sessionManager.getSession(sessionId);
                descriptions.add(String.format("base %s session id = %s : %s", baseName, sessionId, s.toString()));
            }
        }
        return descriptions;
    }

    @Override
    public boolean automaticallyCreateDatabase() {
        return this.automaticallyCreateDatabase;
    }

    @Override
    public NeoDatisConfig getConfig() {
        return this.config;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void dontCallTriggersForClasses(String baseIdentifier, List<Class> classes) {
        SessionManager sm = this.sessionManagers.get(baseIdentifier);
        if (sm == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.UNREGISTERED_BASE_ON_SERVER.addParameter(baseIdentifier));
        }
        sm.getTriggers().addClassesNotToCallTriggersOn(classes);
    }
}

