/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.refactor;

import java.util.Map;
import org.neodatis.odb.NeoDatisEventType;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.event.EventManager;
import org.neodatis.odb.core.event.MetaModelHasChangedEvent;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.refactor.CheckMetaModelResult;
import org.neodatis.odb.core.refactor.ClassHasChangedListener;
import org.neodatis.odb.core.refactor.ClassInfoComparator;
import org.neodatis.odb.core.refactor.ClassInfoCompareResult;
import org.neodatis.odb.core.refactor.MetaModelEvolutionManager;
import org.neodatis.odb.core.session.Session;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.list.IOdbList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaModelEvolutionManagerImpl
implements MetaModelEvolutionManager {
    protected Session session;
    protected EventManager eventManager;
    protected boolean verbose;
    protected boolean abortIfChangesAreNotCompatible;

    public MetaModelEvolutionManagerImpl(Session session) {
        this.session = session;
        this.eventManager = session.getEventManager();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public CheckMetaModelResult check(boolean updateDatabaseMetaModelIfPossible, boolean abortIfChangesAreNotCompatible, boolean verbose) {
        this.abortIfChangesAreNotCompatible = abortIfChangesAreNotCompatible;
        this.verbose = verbose;
        IOdbList<ClassInfo> databaseCIs = this.session.getMetaModel().getAllClasses();
        Map<String, ClassInfo> javaClasses = this.session.getEngine().getObjectIntrospector().getClassIntrospector().instrospect(databaseCIs);
        CheckMetaModelResult checkMetaModelResult = this.checkMetaModelCompatibility(javaClasses);
        ClassInfoCompareResult result = null;
        for (int i = 0; i < checkMetaModelResult.size(); ++i) {
            result = checkMetaModelResult.getResults().get(i);
            if (!result.hasChanged()) continue;
            DLogger.info("Class " + result.getFullClassName() + " has changed :");
            DLogger.info(result.toString());
        }
        if (updateDatabaseMetaModelIfPossible) {
            if (checkMetaModelResult.getResults().isEmpty()) return checkMetaModelResult;
            if (!checkMetaModelResult.changesAreCompatible()) throw new NeoDatisRuntimeException(NeoDatisError.INCOMPATIBLE_METAMODEL.addParameter(checkMetaModelResult.toString()));
            if (!checkMetaModelResult.hasChanged()) return checkMetaModelResult;
            this.session.updateMetaModel();
            checkMetaModelResult.setModelHasBeenUpdated(true);
            return checkMetaModelResult;
        } else {
            this.session.getEventManager().fireEvent(new MetaModelHasChangedEvent(checkMetaModelResult));
        }
        return checkMetaModelResult;
    }

    protected CheckMetaModelResult checkMetaModelCompatibility(Map<String, ClassInfo> currentCIs) {
        ClassInfo persistedCI2 = null;
        ClassInfo currentCI = null;
        ClassInfoCompareResult result = null;
        CheckMetaModelResult checkMetaModelResult = new CheckMetaModelResult();
        ClassInfoComparator ciComparator = new ClassInfoComparator();
        for (ClassInfo persistedCI2 : this.session.getMetaModel().getUserClasses()) {
            currentCI = currentCIs.get(persistedCI2.getFullClassName());
            if (this.verbose) {
                DLogger.info("Analysing class " + persistedCI2.getFullClassName());
            }
            result = ciComparator.compare(persistedCI2, currentCI, true, this.session.getConfig().getCoreProvider().getClassPool());
            if (this.abortIfChangesAreNotCompatible && !result.isCompatible()) {
                throw new NeoDatisRuntimeException(NeoDatisError.INCOMPATIBLE_METAMODEL.addParameter(result.toString()));
            }
            checkMetaModelResult.add(result);
        }
        for (ClassInfo persistedCI2 : this.session.getMetaModel().getSystemClasses()) {
            currentCI = currentCIs.get(persistedCI2.getFullClassName());
            result = ciComparator.compare(persistedCI2, currentCI, true, this.session.getConfig().getCoreProvider().getClassPool());
            if (this.abortIfChangesAreNotCompatible && !result.isCompatible()) {
                throw new NeoDatisRuntimeException(NeoDatisError.INCOMPATIBLE_METAMODEL.addParameter(result.toString()));
            }
            checkMetaModelResult.add(result);
        }
        return checkMetaModelResult;
    }

    @Override
    public void addListener(ClassHasChangedListener listener) {
        this.eventManager.addEventListener(NeoDatisEventType.META_MODEL_HAS_CHANGED, listener);
    }
}

