/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.criteria;

import java.util.HashSet;
import java.util.Iterator;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.query.IQueryExecutionPlan;
import org.neodatis.odb.core.query.criteria.CriteriaQueryImpl;
import org.neodatis.odb.core.query.criteria.Criterion;
import org.neodatis.tool.wrappers.OdbTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaQueryExecutionPlan
implements IQueryExecutionPlan {
    protected transient ClassInfo classInfo;
    protected transient CriteriaQueryImpl criteriaQuery;
    protected boolean useIndex;
    protected transient ClassInfoIndex classInfoIndex;
    protected long start;
    protected long end;
    protected String details;

    public CriteriaQueryExecutionPlan() {
    }

    public CriteriaQueryExecutionPlan(ClassInfo classInfo, CriteriaQueryImpl query) {
        this.classInfo = classInfo;
        this.criteriaQuery = query;
        this.criteriaQuery.setExecutionPlan(this);
        this.init();
    }

    protected void init() {
        this.start = 0L;
        this.end = 0L;
        if (this.classInfo.hasIndex() && this.criteriaQuery.hasCriteria() && this.canUseIndex(this.criteriaQuery.getCriteria())) {
            HashSet<String> fields = this.criteriaQuery.getAllInvolvedFields();
            if (fields.isEmpty()) {
                this.useIndex = false;
            } else {
                int[] fieldIds = this.getAllInvolvedFieldIds(fields);
                this.classInfoIndex = this.classInfo.getIndexForAttributeIds(fieldIds);
                if (this.classInfoIndex != null) {
                    this.useIndex = true;
                }
            }
        }
        this.details = this.getDetails();
    }

    protected int[] getAllInvolvedFieldIds(HashSet<String> fields) {
        int nbFields = fields.size();
        int[] fieldIds = new int[nbFields];
        Iterator<String> iterator = fields.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            fieldIds[i++] = this.classInfo.getAttributeId(iterator.next());
        }
        return fieldIds;
    }

    private boolean canUseIndex(Criterion criteria) {
        return criteria.canUseIndex();
    }

    @Override
    public ClassInfoIndex getIndex() {
        return this.classInfoIndex;
    }

    @Override
    public boolean useIndex() {
        return this.useIndex;
    }

    @Override
    public String getDetails() {
        if (this.details != null) {
            return this.details;
        }
        StringBuffer buffer = new StringBuffer();
        if (this.classInfoIndex == null) {
            buffer.append("No index used, Execution time=").append(this.getDuration()).append("ms");
            return buffer.toString();
        }
        return buffer.append("Following indexes have been used : ").append(this.classInfoIndex.getName()).append(", Execution time=").append(this.getDuration()).append("ms").toString();
    }

    @Override
    public void end() {
        this.end = OdbTime.getCurrentTimeInMs();
    }

    @Override
    public long getDuration() {
        return this.end - this.start;
    }

    @Override
    public void start() {
        this.start = OdbTime.getCurrentTimeInMs();
    }
}

