/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.oid.uuid;

import java.util.UUID;
import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatis;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverterImpl;
import org.neodatis.odb.core.oid.uuid.ClassOidImpl;
import org.neodatis.odb.core.oid.uuid.OIDImpl;

public class ObjectOidImpl
extends OIDImpl
implements ObjectOid {
    private static final String SEP = "@";
    protected ClassOid classOid;
    public static int i = 0;
    protected static ByteArrayConverter converter = new ByteArrayConverterImpl(false, null, NeoDatis.getConfig());
    protected UUID uuid;

    public ObjectOidImpl() {
    }

    public ObjectOidImpl(UUID uuid, ClassOid classOid) {
        this.classOid = classOid;
        this.uuid = uuid;
    }

    public String toString() {
        return this.oidToString();
    }

    public int compareTo(Object obj) {
        if (obj == null || !(obj instanceof ObjectOidImpl) || this.uuid == null) {
            return -1000;
        }
        ObjectOidImpl ooi = (ObjectOidImpl)obj;
        return this.uuid.compareTo(ooi.uuid);
    }

    public int getType() {
        return 4;
    }

    public ClassOid getClassOid() {
        return this.classOid;
    }

    public void setClassOid(ClassOid classOid) {
        this.classOid = classOid;
    }

    public String oidToString() {
        if (this.uuid == null) {
            return "null-oid";
        }
        return this.uuid.toString() + SEP + this.classOid.oidToString();
    }

    public byte[] toByte() {
        byte[] b = new byte[32];
        ClassOidImpl coid = (ClassOidImpl)this.classOid;
        long lc = 0L;
        long mc = 0L;
        long lo = 0L;
        long mo = 0L;
        if (this.uuid != null) {
            lc = coid.uuid.getLeastSignificantBits();
            mc = coid.uuid.getMostSignificantBits();
            lo = this.uuid.getLeastSignificantBits();
            mo = this.uuid.getMostSignificantBits();
        }
        converter.longToByteArray(lc, b, 0, "least class");
        converter.longToByteArray(mc, b, 8, "most class");
        converter.longToByteArray(lo, b, 16, "least object");
        converter.longToByteArray(mo, b, 24, "most object");
        return b;
    }

    public boolean isNull() {
        return this.uuid == null;
    }

    public int hashCode() {
        if (this.uuid == null) {
            return -1;
        }
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectOidImpl)) {
            return false;
        }
        if (this.uuid == null || obj == null) {
            return false;
        }
        ObjectOidImpl oid2 = (ObjectOidImpl)obj;
        return this.uuid.equals(oid2.uuid);
    }

    public static ObjectOid objectOidfromString(String s) {
        String[] tokens = s.split(SEP);
        UUID objectUuid = UUID.fromString(tokens[0]);
        UUID classUuid = UUID.fromString(tokens[1]);
        return new ObjectOidImpl(objectUuid, new ClassOidImpl(classUuid));
    }
}

