/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.oid.sequential;

import org.neodatis.odb.ClassOid;
import org.neodatis.odb.NeoDatis;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverterImpl;
import org.neodatis.odb.core.oid.sequential.ClassOidImpl;
import org.neodatis.odb.core.oid.sequential.OIDImpl;

public class ObjectOidImpl
extends OIDImpl
implements ObjectOid {
    protected static ByteArrayConverter converter = new ByteArrayConverterImpl(false, null, NeoDatis.getConfig());
    protected ClassOid classOid;
    protected long objectId;
    protected String text;

    public ObjectOidImpl(ClassOid classOid, long objectId) {
        super(4);
        this.classOid = classOid;
        this.objectId = objectId;
    }

    public String toString() {
        return this.oidToString();
    }

    public static ObjectOid oidFromString(String s) {
        String[] tokens = s.split("\\.");
        if (tokens.length != 3) {
            throw new NeoDatisRuntimeException(NeoDatisError.INVALID_OID_REPRESENTATION.addParameter(s));
        }
        int type = Integer.parseInt(tokens[0]);
        if (type != 4) {
            throw new NeoDatisRuntimeException(NeoDatisError.INVALID_OID_REPRESENTATION.addParameter(s));
        }
        long classId = Long.parseLong(tokens[1]);
        long objectId = Long.parseLong(tokens[2]);
        return new ObjectOidImpl(new ClassOidImpl(classId), objectId);
    }

    public String oidToString() {
        if (this.text != null) {
            return this.text;
        }
        this.text = new StringBuilder(15).append(this.type).append(".").append(((ClassOidImpl)this.classOid).classId).append(".").append(this.objectId).toString();
        return this.text;
    }

    public byte[] oidToByte() {
        byte[] bytes = new byte[12];
        return bytes;
    }

    public int compareTo(Object obj) {
        if (obj == null || !(obj instanceof ObjectOidImpl)) {
            return -1000;
        }
        ObjectOidImpl ooi = (ObjectOidImpl)obj;
        int difClassId = this.classOid.compareTo(ooi.classOid);
        if (difClassId != 0) {
            return difClassId;
        }
        int difObjectId = (int)(this.objectId - ooi.objectId) % Integer.MAX_VALUE;
        return difObjectId;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public ClassOid getClassOid() {
        return this.classOid;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public int hashCode() {
        return (int)(this.objectId ^ this.objectId >>> 32);
    }

    public boolean isNull() {
        return this.objectId == 0L;
    }

    public void setClassOid(ClassOid classOid) {
    }

    public byte[] toByte() {
        byte[] b = new byte[16];
        ClassOidImpl coid = (ClassOidImpl)this.getClassOid();
        converter.longToByteArray(this.objectId, b, 0, "oid");
        converter.longToByteArray(coid.classId, b, 8, "coid");
        return b;
    }
}

