/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer3;

import java.util.ArrayList;
import java.util.List;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer3.Bytes;

public class BytesImpl
implements Bytes {
    protected static final int SIZE = 256;
    protected List<byte[]> listOfByteArray;
    protected byte[] bytes;
    protected int currentBlockNumber = -1;
    protected int min;
    protected int max;
    protected int maxPosition;
    protected int deltaOffset;
    protected long offset;

    public BytesImpl() {
        this.initByteArrayForIndex(0);
        this.maxPosition = -1;
        this.offset = -1L;
        this.deltaOffset = 0;
    }

    public BytesImpl(long offset) {
        this();
        this.offset = offset;
        this.deltaOffset = 0;
    }

    public BytesImpl(byte[] array) {
        this();
        this.copy(array, 0, 0, array.length, true);
    }

    public BytesImpl(byte[] array, long offset) {
        this(array);
        this.offset = offset;
    }

    public BytesImpl(byte[] array, long offset, int delta) {
        this(array);
        this.offset = offset;
        this.deltaOffset = delta;
    }

    void initByteArrayForIndex(int start) {
        int blockNumber = start / 256;
        if (blockNumber == this.currentBlockNumber) {
            return;
        }
        if (blockNumber == 1 && this.listOfByteArray == null) {
            this.listOfByteArray = new ArrayList<byte[]>();
            this.listOfByteArray.add(this.bytes);
        }
        this.currentBlockNumber = blockNumber;
        this.min = blockNumber * 256;
        this.max = this.min + 256 - 1;
        if (this.listOfByteArray != null && this.listOfByteArray.size() > blockNumber) {
            this.bytes = this.listOfByteArray.get(blockNumber);
        } else {
            this.bytes = new byte[256];
            if (blockNumber > 0 && this.listOfByteArray != null) {
                this.listOfByteArray.add(this.bytes);
            }
        }
    }

    public void set(int index, byte b) {
        int realIndex = index + this.deltaOffset;
        if (realIndex < this.min || realIndex > this.max) {
            this.initByteArrayForIndex(realIndex);
        }
        int ajustedIndex = realIndex - this.min;
        this.bytes[ajustedIndex] = b;
        if (index > this.maxPosition) {
            this.maxPosition = realIndex;
        }
    }

    public void set(int index, byte[] bb) {
        int realIndex = index + this.deltaOffset;
        int length = bb.length;
        int maxPos = realIndex + length - 1;
        if (realIndex < this.min || realIndex > this.max) {
            this.initByteArrayForIndex(realIndex);
        }
        if (maxPos <= this.max) {
            for (int i = 0; i < bb.length; ++i) {
                this.bytes[realIndex - this.min + i] = bb[i];
            }
            if (maxPos > this.maxPosition) {
                this.maxPosition = maxPos;
            }
            return;
        }
        for (int i = 0; i < length; ++i) {
            this.set(realIndex + i, bb[i]);
        }
    }

    public void copy(byte[] bytesToCopy, int from, int to, int length, boolean check) {
        boolean sizeOk;
        int availableSpace;
        int realTo = to + this.deltaOffset;
        int ajustedTo = realTo - this.min;
        if (realTo + length > this.maxPosition + 1) {
            this.maxPosition = realTo + length - 1;
        }
        boolean toIsIn = (availableSpace = 256 - ajustedTo) > 0;
        boolean bl = sizeOk = length <= availableSpace;
        if (toIsIn && sizeOk) {
            System.arraycopy(bytesToCopy, from, this.bytes, realTo - this.min, length);
            return;
        }
        if (toIsIn) {
            int newLength = availableSpace;
            System.arraycopy(bytesToCopy, from, this.bytes, ajustedTo, newLength);
            this.initByteArrayForIndex(this.max + 1);
            this.copy(bytesToCopy, from + availableSpace, realTo + availableSpace, length - availableSpace, check);
            return;
        }
        this.initByteArrayForIndex(this.max + 1);
        this.copy(bytesToCopy, from, to, length, check);
    }

    public int getNbBlocks() {
        if (this.listOfByteArray == null) {
            return 1;
        }
        return this.listOfByteArray.size();
    }

    public int getRealSize() {
        return this.maxPosition + 1;
    }

    public byte get(int index) {
        int realIndex = index + this.deltaOffset;
        if (this.listOfByteArray == null) {
            if (realIndex > this.maxPosition) {
                throw new IndexOutOfBoundsException(String.format("Max size of array is %d, trying to get index %d", this.maxPosition, index));
            }
            return this.bytes[realIndex];
        }
        int blockNumber = realIndex / 256;
        byte[] bb = this.listOfByteArray.get(blockNumber);
        int adjustedPosition = realIndex - blockNumber * 256;
        return bb[adjustedPosition];
    }

    public byte[] get(int index, byte[] dest, int destOffset, int size) {
        if (size == 0) {
            return dest;
        }
        int realIndex = index + this.deltaOffset;
        int maxPos = realIndex + size - 1;
        if (this.listOfByteArray == null) {
            if (realIndex > this.maxPosition || maxPos > this.maxPosition) {
                throw new IndexOutOfBoundsException(String.format("Max size of array is %d, trying to get index %d with length %d", this.maxPosition, index, size));
            }
            try {
                System.arraycopy(this.bytes, realIndex, dest, destOffset, size);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return dest;
        }
        int blockNumber = realIndex / 256;
        byte[] bb = this.listOfByteArray.get(blockNumber);
        int adjustedPosition = realIndex - blockNumber * 256;
        dest[destOffset] = bb[adjustedPosition];
        return this.get(index + 1, dest, destOffset + 1, size - 1);
    }

    public byte[] extract(int offset, int length) {
        int realIndex = this.deltaOffset + offset;
        if (realIndex + length > this.getRealSize()) {
            throw new NeoDatisRuntimeException(NeoDatisError.LAYER3_BUFFER_OVER_FLOW.addParameter(this.getRealSize()).addParameter(realIndex + length));
        }
        byte[] rbytes = new byte[length];
        return this.internalExtract(rbytes, 0, realIndex, length);
    }

    public byte[] extract(byte[] bytesWhereToWrite, int offsetWhereToWrite, int offsetWhereToRead, int length) {
        int realIndex = this.deltaOffset + offsetWhereToRead;
        return this.internalExtract(bytesWhereToWrite, offsetWhereToWrite, realIndex, length);
    }

    protected byte[] internalExtract(byte[] dest, int destOffset, int offset, int length) {
        this.initByteArrayForIndex(offset);
        byte[] bb = this.bytes;
        int end = offset + length - 1;
        if (offset >= this.min && offset <= this.max && end >= this.min && end <= this.max) {
            System.arraycopy(bb, offset - this.min, dest, destOffset, length);
            return dest;
        }
        if (offset >= this.min && offset <= this.max) {
            int l = 256 - (offset - this.min);
            System.arraycopy(bb, offset - this.min, dest, destOffset, l);
            return this.internalExtract(dest, destOffset + l, offset + l, length - l);
        }
        throw new IndexOutOfBoundsException(String.format("Trying to extract byte with offset=%d and length=%d", offset, length));
    }

    public byte[] getByteArray() {
        return this.extract(0, this.maxPosition + 1);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Offset=").append(this.offset).append(" - delta Offset = ").append(this.deltaOffset).append(" - size=").append(this.getRealSize());
        return b.toString();
    }

    public int append(Bytes bytes) {
        byte[] abytes = bytes.getByteArray();
        return this.append(bytes);
    }

    public int append(byte[] bytes) {
        this.copy(bytes, 0, this.maxPosition + 1, bytes.length, true);
        return this.maxPosition;
    }

    public byte[] getByteArray(int index) {
        if (index == 0 && this.listOfByteArray == null) {
            return this.bytes;
        }
        return this.listOfByteArray.get(index);
    }

    public long getOffset() {
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public boolean hasOffset() {
        return this.offset != -1L;
    }
}

