/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.layers.layer2.meta;

import java.util.Map;
import org.neodatis.odb.NeoDatisRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.ObjectOid;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AttributeIdentification;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.GroupObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeDeletedObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer2.meta.ObjectReference;
import org.neodatis.tool.wrappers.OdbClassUtil;
import org.neodatis.tool.wrappers.OdbString;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonNativeObjectInfo
extends AbstractObjectInfo {
    protected transient Object object;
    private ClassInfo classInfo;
    private ObjectInfoHeader objectHeader;
    private AbstractObjectInfo[] attributeValues;
    private IOdbList<NonNativeObjectInfo> directNonNativeAttributes;
    private IOdbList<NonNativeObjectInfo> nonDirectNonNativeObjects;
    private int maxNbattributes;

    public NonNativeObjectInfo() {
        super(null);
        this.objectHeader = new ObjectInfoHeader();
    }

    public NonNativeObjectInfo(ObjectInfoHeader oip, ClassInfo classInfo) {
        super(null);
        this.classInfo = classInfo;
        this.objectHeader = oip;
        if (classInfo != null) {
            this.maxNbattributes = classInfo.getMaxAttributeId();
            this.attributeValues = new AbstractObjectInfo[this.maxNbattributes];
        }
        this.directNonNativeAttributes = new OdbArrayList<NonNativeObjectInfo>();
        this.nonDirectNonNativeObjects = new OdbArrayList<NonNativeObjectInfo>();
    }

    public NonNativeObjectInfo(ClassInfo classInfo) {
        super(null);
        this.classInfo = classInfo;
        this.objectHeader = new ObjectInfoHeader(classInfo != null ? classInfo.getOid() : null, null);
        if (classInfo != null) {
            this.maxNbattributes = classInfo.getMaxAttributeId();
            this.attributeValues = new AbstractObjectInfo[this.maxNbattributes];
        }
        this.directNonNativeAttributes = new OdbArrayList<NonNativeObjectInfo>();
        this.nonDirectNonNativeObjects = new OdbArrayList<NonNativeObjectInfo>();
    }

    public NonNativeObjectInfo(Object object, ClassInfo ci, AbstractObjectInfo[] values, AttributeIdentification[] attributesIdentification) {
        super(ODBType.getFromName(ci.getFullClassName()));
        this.object = object;
        this.classInfo = ci;
        this.attributeValues = values;
        this.maxNbattributes = this.classInfo.getMaxAttributeId();
        if (this.attributeValues == null) {
            this.attributeValues = new AbstractObjectInfo[this.maxNbattributes];
        }
        this.objectHeader = new ObjectInfoHeader(this.classInfo != null ? this.classInfo.getOid() : null, attributesIdentification);
        this.directNonNativeAttributes = new OdbArrayList<NonNativeObjectInfo>();
        this.nonDirectNonNativeObjects = new OdbArrayList<NonNativeObjectInfo>();
    }

    public ObjectInfoHeader getHeader() {
        return this.objectHeader;
    }

    public AbstractObjectInfo getAttributeValueFromId(int attributeId) {
        return this.attributeValues[attributeId - 1];
    }

    public ClassInfo getClassInfo() {
        return this.classInfo;
    }

    public void setClassInfo(ClassInfo classInfo) {
        if (classInfo != null) {
            this.classInfo = classInfo;
            this.objectHeader.setClassInfoId(classInfo.getOid());
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.classInfo.getFullClassName()).append("(").append(this.getOid()).append(")=");
        if (this.attributeValues == null) {
            buffer.append("null attribute values");
            return buffer.toString();
        }
        for (int i = 0; i < this.attributeValues.length; ++i) {
            if (i != 0) {
                buffer.append(",");
            }
            String attributeName = this.classInfo != null ? this.classInfo.getAttributeInfo(i).getName() : "?";
            buffer.append(attributeName).append("=");
            AbstractObjectInfo object = this.attributeValues[i];
            if (object == null) {
                buffer.append(" null java object - should not happen , ");
                continue;
            }
            ODBType type = ODBType.getFromClass(this.attributeValues[i].getClass());
            if (object instanceof NonNativeNullObjectInfo) {
                buffer.append("null");
                continue;
            }
            if (object instanceof NonNativeDeletedObjectInfo) {
                buffer.append("deleted object");
                continue;
            }
            if (object instanceof NativeObjectInfo) {
                NativeObjectInfo noi = (NativeObjectInfo)object;
                buffer.append(noi.toString());
                continue;
            }
            if (object instanceof ObjectReference) {
                buffer.append(object.toString());
                continue;
            }
            if (object instanceof NonNativeObjectInfo) {
                NonNativeObjectInfo nnoi = (NonNativeObjectInfo)object;
                buffer.append("@").append(nnoi.getClassInfo().getFullClassName()).append("(id=").append(nnoi.getOid()).append(")");
                continue;
            }
            buffer.append("@").append(OdbClassUtil.getClassName(type.getName()));
        }
        return buffer.toString();
    }

    @Override
    public Object getObject() {
        return this.object;
    }

    public Object getValueOf(String attributeName) {
        boolean isRelation;
        int attributeId = -1;
        boolean bl = isRelation = attributeName.indexOf(".") != -1;
        if (!isRelation) {
            attributeId = this.getClassInfo().getAttributeId(attributeName);
            return this.getAttributeValueFromId(attributeId).getObject();
        }
        int firstDotIndex = attributeName.indexOf(".");
        String firstAttributeName = OdbString.substring(attributeName, 0, firstDotIndex);
        attributeId = this.getClassInfo().getAttributeId(firstAttributeName);
        AbstractObjectInfo object = this.attributeValues[attributeId];
        if (object instanceof NonNativeObjectInfo) {
            NonNativeObjectInfo nnoi = (NonNativeObjectInfo)object;
            return nnoi.getValueOf(OdbString.substring(attributeName, firstDotIndex + 1, attributeName.length()));
        }
        throw new NeoDatisRuntimeException(NeoDatisError.CLASS_INFO_DO_NOT_HAVE_THE_ATTRIBUTE.addParameter(this.getClassInfo().getFullClassName()).addParameter(attributeName));
    }

    public AbstractObjectInfo getMetaValueOf(String attributeName) {
        boolean isRelation;
        int attributeId = -1;
        boolean bl = isRelation = attributeName.indexOf(".") != -1;
        if (!isRelation) {
            attributeId = this.getClassInfo().getAttributeId(attributeName);
            return this.getAttributeValueFromId(attributeId);
        }
        int firstDotIndex = attributeName.indexOf(".");
        String firstAttributeName = OdbString.substring(attributeName, 0, firstDotIndex);
        attributeId = this.getClassInfo().getAttributeId(firstAttributeName);
        AbstractObjectInfo object = this.attributeValues[attributeId];
        if (object instanceof NonNativeObjectInfo) {
            NonNativeObjectInfo nnoi = (NonNativeObjectInfo)object;
            return nnoi.getMetaValueOf(OdbString.substring(attributeName, firstDotIndex + 1, attributeName.length()));
        }
        throw new NeoDatisRuntimeException(NeoDatisError.CLASS_INFO_DO_NOT_HAVE_THE_ATTRIBUTE.addParameter(this.getClassInfo().getFullClassName()).addParameter(attributeName));
    }

    public void setValueOf(String attributeName, AbstractObjectInfo aoi) {
        boolean isRelation;
        int attributeId = -1;
        boolean bl = isRelation = attributeName.indexOf(".") != -1;
        if (!isRelation) {
            attributeId = this.getClassInfo().getAttributeId(attributeName);
            this.setAttributeValue(attributeId, aoi);
            return;
        }
        int firstDotIndex = attributeName.indexOf(".");
        String firstAttributeName = OdbString.substring(attributeName, 0, firstDotIndex);
        attributeId = this.getClassInfo().getAttributeId(firstAttributeName);
        AbstractObjectInfo object = this.attributeValues[attributeId];
        if (object instanceof NonNativeObjectInfo) {
            NonNativeObjectInfo nnoi = (NonNativeObjectInfo)object;
            nnoi.setValueOf(OdbString.substring(attributeName, firstDotIndex + 1, attributeName.length()), aoi);
        }
        throw new NeoDatisRuntimeException(NeoDatisError.CLASS_INFO_DO_NOT_HAVE_THE_ATTRIBUTE.addParameter(this.getClassInfo().getFullClassName()).addParameter(attributeName));
    }

    public ObjectOid getOid() {
        if (this.getHeader() == null) {
            throw new NeoDatisRuntimeException(NeoDatisError.UNEXPECTED_SITUATION.addParameter("Null Object Info Header"));
        }
        return this.getHeader().getOid();
    }

    public void setOid(ObjectOid oid) {
        if (this.getHeader() != null) {
            this.getHeader().setOid(oid);
        }
    }

    @Override
    public boolean isNonNativeObject() {
        return true;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    public void clear() {
        this.attributeValues = null;
    }

    @Override
    public AbstractObjectInfo createCopy(Map<OID, AbstractObjectInfo> cache, boolean onlyData) {
        NonNativeObjectInfo nnoi = (NonNativeObjectInfo)cache.get(this.objectHeader.getOid());
        if (nnoi != null) {
            return nnoi;
        }
        if (onlyData) {
            ObjectInfoHeader oih = new ObjectInfoHeader();
            nnoi = new NonNativeObjectInfo(this.object, this.classInfo, null, oih.getAttributesIdentification());
        } else {
            nnoi = new NonNativeObjectInfo(this.object, this.classInfo, null, this.objectHeader.getAttributesIdentification());
            nnoi.getHeader().setOid(this.getHeader().getOid());
        }
        AbstractObjectInfo[] newAttributeValues = new AbstractObjectInfo[this.attributeValues.length];
        for (int i = 0; i < this.attributeValues.length; ++i) {
            newAttributeValues[i] = this.attributeValues[i].createCopy(cache, onlyData);
        }
        nnoi.attributeValues = newAttributeValues;
        cache.put(this.objectHeader.getOid(), nnoi);
        return nnoi;
    }

    public void setAttributeValue(int attributeId, AbstractObjectInfo aoi) {
        this.attributeValues[attributeId - 1] = aoi;
        if (aoi.isNonNativeObject()) {
            this.directNonNativeAttributes.add((NonNativeObjectInfo)aoi);
        } else if (aoi.isGroup()) {
            GroupObjectInfo goi = (GroupObjectInfo)aoi;
            this.nonDirectNonNativeObjects.addAll(goi.getNonNativeObjects());
        }
    }

    public AbstractObjectInfo[] getAttributeValues() {
        return this.attributeValues;
    }

    public int getMaxNbattributes() {
        return this.maxNbattributes;
    }

    public int getAttributeId(AbstractObjectInfo aoi) {
        for (int i = 0; i < this.attributeValues.length; ++i) {
            if (aoi != this.attributeValues[i]) continue;
            return i + 1;
        }
        return -1;
    }

    public long getAttributeDefinitionPosition(int attributeId) {
        throw new NeoDatisRuntimeException(NeoDatisError.NOT_YET_IMPLEMENTED);
    }

    @Override
    public void setObject(Object object) {
        this.object = object;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.objectHeader == null) {
            return -1;
        }
        return this.objectHeader.hashCode();
    }

    public void setHeader(ObjectInfoHeader header) {
        this.objectHeader = header;
    }

    public IOdbList<NonNativeObjectInfo> getDirectNonNativeAttributes() {
        return this.directNonNativeAttributes;
    }

    public void setDirectNonNativeAttributes(IOdbList<NonNativeObjectInfo> directNonNativeAttributes) {
        this.directNonNativeAttributes = directNonNativeAttributes;
    }

    public IOdbList<NonNativeObjectInfo> getNonDirectNonNativeObjects() {
        return this.nonDirectNonNativeObjects;
    }

    public void setNonDirectNonNativeObjects(IOdbList<NonNativeObjectInfo> nonDirectNonNativeObjects) {
        this.nonDirectNonNativeObjects = nonDirectNonNativeObjects;
    }
}

