/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.btree.nativ;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.IBTreePersister;
import org.neodatis.btree.exception.BTreeException;
import org.neodatis.odb.NeoDatisConfig;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.btree.nativ.NativeBTree;
import org.neodatis.odb.core.btree.nativ.NativeNode;
import org.neodatis.odb.core.btree.nativ.Position;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverterImpl;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesFactory;
import org.neodatis.odb.core.layers.layer3.ReadSize;

public class NativeBTreePersister
implements IBTreePersister {
    protected RandomAccessFile raf;
    protected String fileName;
    protected long maxFileSize;
    protected int btreeDegree;
    protected int nodeSize;
    protected ByteArrayConverter converter;
    protected IBTree btree;
    protected int HEADER_OFFSET = 36;
    protected Map<Long, IBTreeNode> nodes = new HashMap<Long, IBTreeNode>();
    protected Map<Long, IBTreeNode> modifiedNodes = new HashMap<Long, IBTreeNode>();
    protected boolean commit;
    protected boolean withCacheForRead;
    protected boolean withCacheForWrite;
    protected Map<String, RandomAccessFile> rafs;

    public NativeBTreePersister(String fileName, long maxFileSize, int degree, boolean debug, String characterEncoding, NeoDatisConfig config) {
        this.fileName = fileName;
        this.maxFileSize = maxFileSize;
        this.btreeDegree = degree;
        this.converter = new ByteArrayConverterImpl(debug, characterEncoding, config);
        this.computeNodeSize();
        try {
            this.raf = new RandomAccessFile(fileName, "rw");
        }
        catch (FileNotFoundException e) {
            throw new BTreeException("Error while opening btree file " + fileName, e);
        }
        this.withCacheForRead = true;
        this.withCacheForWrite = true;
    }

    private void computeNodeSize() {
        int size = 2 * this.btreeDegree - 1;
        this.nodeSize = 20 + size * 8 + size * 20 + (size + 1) * 8;
    }

    public void clear() {
    }

    public void close() throws Exception {
        this.commit = true;
        this.saveBTree(this.btree, true);
        this.saveModifiedNodes();
        this.raf.close();
    }

    private void saveModifiedNodes() {
        Iterator<IBTreeNode> mnodes = this.modifiedNodes.values().iterator();
        System.out.println("Saving " + this.modifiedNodes.size() + " nodes");
        boolean i = false;
        while (mnodes.hasNext()) {
            this.saveNode(mnodes.next());
        }
    }

    public Object deleteNode(IBTreeNode node) {
        System.out.println("Deleting node with id " + node.getId());
        return null;
    }

    public void flush() {
    }

    public IBTree loadBTree(Object id) {
        if (this.btree != null) {
            return this.btree;
        }
        System.out.println("Loading Btree with id " + id);
        Long nid = (Long)id;
        byte[] bbytes = new byte[this.HEADER_OFFSET];
        int arraySize = 0;
        try {
            this.raf.seek(0L);
            arraySize = this.raf.read(bbytes);
        }
        catch (Exception e) {
            throw new BTreeException("Error while loading btree with id " + id.toString(), e);
        }
        if (arraySize != this.HEADER_OFFSET) {
            throw new BTreeException("Error while reading btree header, different size, expected " + this.HEADER_OFFSET + ", found " + arraySize);
        }
        Bytes bytes = BytesFactory.getBytes(bbytes);
        ReadSize readSize = new ReadSize();
        long nid2 = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "btree id");
        int degree = this.converter.byteArrayToInt(bytes, readSize.get(), readSize, "btree degree");
        long size = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "btree size");
        long rootId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "btree root id");
        long nextNodeId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "btree next node id");
        NativeBTree nbtree = new NativeBTree(new Long(nid2), degree, this, new Long(nextNodeId));
        nbtree.setSize(size);
        IBTreeNode root = this.loadNodeById(rootId);
        nbtree.setRoot(root);
        return nbtree;
    }

    public OID saveBTree(IBTree tree) {
        return null;
    }

    public OID saveBTree(IBTree tree, boolean force) {
        if (tree.getId() == null) {
            return null;
        }
        NativeBTree nbtree = (NativeBTree)tree;
        Bytes bytes = BytesFactory.getBytes();
        int objectSize = this.converter.longToByteArray((long)((Long)tree.getId()), bytes, 0, "btree id");
        objectSize += this.converter.intToByteArray(tree.getDegree(), bytes, objectSize, "btree degree");
        objectSize += this.converter.longToByteArray(tree.getSize(), bytes, objectSize, "btree size");
        objectSize += this.converter.longToByteArray((long)((Long)tree.getRoot().getId()), bytes, objectSize, "btree root id");
        objectSize += this.converter.longToByteArray((long)nbtree.getNextNodeId(), bytes, objectSize, "btree next node id");
        try {
            this.raf.seek(0L);
            this.raf.write(bytes.getByteArray());
            return null;
        }
        catch (IOException e) {
            throw new BTreeException("Error while saving btree with id " + tree.getId(), e);
        }
    }

    public IBTreeNode loadNodeById(Object id) {
        if (this.withCacheForRead) {
            IBTreeNode nodeFromCache = this.nodes.get(id);
            if (nodeFromCache != null) {
                return nodeFromCache;
            }
            nodeFromCache = this.modifiedNodes.get((Comparable)id);
            if (nodeFromCache != null) {
                return nodeFromCache;
            }
        }
        Long nid = (Long)id;
        byte[] bbytes = new byte[this.nodeSize];
        int arraySize = 0;
        try {
            long position = (long)this.HEADER_OFFSET + (nid - 1L) * (long)this.nodeSize;
            this.raf.seek(position);
            arraySize = this.raf.read(bbytes);
        }
        catch (Exception e) {
            throw new BTreeException("Error while loading node with id " + id, e);
        }
        Bytes bytes = BytesFactory.getBytes(bbytes);
        ReadSize readSize = new ReadSize();
        long nodeId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "id");
        long parentId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "parent id");
        int size = this.converter.byteArrayToInt(bytes, readSize.get(), readSize, "size");
        Long[] keys = new Long[size];
        int nbKeys = 0;
        for (int i = 0; i < size; ++i) {
            keys[i] = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "key");
            if (keys[i] == -1L) continue;
            ++nbKeys;
        }
        Position[] positions = new Position[size];
        for (int i = 0; i < size; ++i) {
            Position p;
            long fileId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "file id");
            long blockId = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "block id");
            int offset = this.converter.byteArrayToInt(bytes, readSize.get(), readSize, "offset");
            positions[i] = p = new Position(fileId, blockId, offset);
        }
        Long[] childrens = new Long[size + 1];
        int nbChildren = 0;
        for (int i = 0; i < size + 1; ++i) {
            childrens[i] = this.converter.byteArrayToLong(bytes, readSize.get(), readSize, "child");
            if (childrens[i] == -1L) continue;
            ++nbChildren;
        }
        NativeNode node = new NativeNode(this.btree, nid, parentId, size, keys, positions, childrens, nbKeys, nbChildren);
        if (this.withCacheForRead) {
            this.nodes.put(nid, node);
        }
        return node;
    }

    public Object saveNode(IBTreeNode node) {
        int i;
        if (!this.commit && this.withCacheForWrite) {
            this.modifiedNodes.put((Long)node.getId(), node);
            return null;
        }
        Bytes bytes = BytesFactory.getBytes();
        long id = (Long)node.getId();
        long parentId = node.getParentId() == null ? -1L : (Long)node.getParentId();
        int size = 2 * this.btreeDegree - 1;
        int objectSize = 0;
        objectSize += this.converter.longToByteArray(id, bytes, objectSize, "id");
        objectSize += this.converter.longToByteArray(parentId, bytes, objectSize, "parent id");
        objectSize += this.converter.intToByteArray(size, bytes, objectSize, "size");
        for (i = 0; i < size; ++i) {
            if (i < node.getNbKeys()) {
                objectSize += this.converter.longToByteArray((long)((Long)node.getKeyAt(i)), bytes, objectSize, "key");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
        }
        for (i = 0; i < size; ++i) {
            if (i < node.getNbKeys()) {
                Position p = (Position)node.getValueAsObjectAt(i);
                objectSize += this.converter.longToByteArray(p.fileId, bytes, objectSize, "file id");
                objectSize += this.converter.longToByteArray(p.blockId, bytes, objectSize, "block id");
                objectSize += this.converter.intToByteArray(p.offset, bytes, objectSize, "ofsset");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "key");
            objectSize += this.converter.intToByteArray(-1, bytes, objectSize, "key");
        }
        for (i = 0; i < size + 1; ++i) {
            if (i < node.getNbChildren()) {
                Long childId = (Long)node.getChildIdAt(i, false);
                if (childId == null) {
                    System.out.println("null");
                }
                objectSize += this.converter.longToByteArray((long)childId, bytes, objectSize, "childId");
                continue;
            }
            objectSize += this.converter.longToByteArray(-1L, bytes, objectSize, "childId");
        }
        try {
            long position = (long)this.HEADER_OFFSET + (id - 1L) * (long)this.nodeSize;
            this.raf.seek(position);
            this.raf.write(bytes.getByteArray());
            if (this.withCacheForRead && !this.commit) {
                this.nodes.put(id, node);
            }
            return node.getId();
        }
        catch (IOException e) {
            throw new BTreeException("Error while saving node with id " + id, e);
        }
    }

    public void setBTree(IBTree tree) {
        this.btree = tree;
    }
}

