/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.fs.transaction;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.neodatis.fs.NDFS;
import org.neodatis.fs.NdfsConfig;
import org.neodatis.fs.NdfsFile;
import org.neodatis.fs.io.AsyncBlockWriter;
import org.neodatis.fs.io.BlockReader;
import org.neodatis.fs.io.NdfsFileImpl;
import org.neodatis.fs.io.SplittedNDFSFileImpl;
import org.neodatis.fs.memory.GMA;
import org.neodatis.fs.memory.TMA;
import org.neodatis.fs.transaction.NdfsTransaction;
import org.neodatis.odb.NeoDatis;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverter;
import org.neodatis.odb.core.layers.layer3.ByteArrayConverterImpl;
import org.neodatis.odb.core.layers.layer3.Bytes;
import org.neodatis.odb.core.layers.layer3.BytesFactory;
import org.neodatis.odb.core.layers.layer3.ReadSize;
import org.neodatis.tool.DLogger;

public class NdfsTransactionImpl
implements NdfsTransaction {
    protected long id;
    protected TMA tma;
    protected GMA gma;
    protected NdfsFile transactionFile;
    protected AsyncBlockWriter asyncBlockWriter;
    protected NDFS ndfs;
    protected Map<String, NdfsFile> openFilesNames;
    protected boolean debug = NdfsConfig.debug();
    protected ByteArrayConverter converter;

    public NdfsTransactionImpl(NDFS ndfs, long id) {
        this.ndfs = ndfs;
        this.id = id;
        this.gma = ndfs.getGMA();
        this.tma = new TMA(this);
        this.openFilesNames = new HashMap<String, NdfsFile>();
        this.transactionFile = new NdfsFileImpl(this, 0L, ndfs.getProperties().getTransactionDirectory(false), ndfs.getProperties().getTransactionFileName(id));
        this.asyncBlockWriter = new AsyncBlockWriter(this, NdfsConfig.debug(), NdfsConfig.getCharacterEncoding());
        this.converter = new ByteArrayConverterImpl(NdfsConfig.debug(), NdfsConfig.getCharacterEncoding(), NeoDatis.getConfig());
        if (this.debug) {
            DLogger.debug("Transaction:Starting transaction with id" + id + " (file=" + this.transactionFile.getFullName());
        }
        this.initTransactionFlags();
    }

    private void initTransactionFlags() {
        Bytes bytes = BytesFactory.getBytes();
        this.converter.byteToByteArray((byte)0, bytes, 0, "status");
        this.converter.longToByteArray(System.currentTimeMillis(), bytes, 1, "timestamp");
        this.converter.longToByteArray(this.id, bytes, 9, "id");
        this.transactionFile.writeDirect(bytes);
    }

    public void markTransactionFileAsCommited() {
        Bytes bytes = BytesFactory.getBytes();
        this.converter.byteToByteArray((byte)1, bytes, 0, "status");
        this.converter.longToByteArray(System.currentTimeMillis(), bytes, 1, "timestamp");
        this.transactionFile.writeDirect(bytes);
        if (this.debug) {
            DLogger.debug("Transaction:file marked as committed");
        }
    }

    public void markTransactionFileAsRollbacked() {
        Bytes bytes = BytesFactory.getBytes();
        this.converter.byteToByteArray((byte)2, bytes, 0, "status");
        this.converter.longToByteArray(System.currentTimeMillis(), bytes, 1, "timestamp");
        this.transactionFile.writeDirect(bytes);
        if (this.debug) {
            DLogger.debug("Transaction:file marked as rollbacked");
        }
    }

    public void markTransactionFileAsApplied() {
        Bytes bytes = BytesFactory.getBytes();
        this.converter.byteToByteArray((byte)3, bytes, 0, "status");
        this.converter.longToByteArray(System.currentTimeMillis(), bytes, 1, "timestamp");
        this.transactionFile.writeDirect(bytes);
        if (this.debug) {
            DLogger.debug("Transaction:file marked as applied");
        }
    }

    public static byte getStatusOfTransaction(NdfsFile file) {
        Bytes bytes = file.read(0L, 1L);
        return bytes.get(0);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public TMA getTma() {
        return this.tma;
    }

    public void setTma(TMA tma) {
        this.tma = tma;
    }

    public GMA getGma() {
        return this.gma;
    }

    public void setGma(GMA gma) {
        this.gma = gma;
    }

    public NdfsFile getTransactionFile() {
        return this.transactionFile;
    }

    public void setFile(NdfsFile file) {
        this.transactionFile = file;
    }

    public void writeTo(NdfsFile file, Bytes bytes) {
        this.asyncBlockWriter.writeTo(file, bytes);
    }

    public BlockReader getReader(NdfsFile file) {
        return new BlockReader(file);
    }

    public void commit() {
        if (this.debug) {
            DLogger.debug(String.format("Transaction:Committing transaction with id %d (file=%s) - nb open files=%d", this.id, this.transactionFile.getFullName(), this.getNbOpenFiles()));
        }
        this.ndfs.markAsCommited(this);
    }

    public void rollback() {
        if (this.debug) {
            DLogger.debug(String.format("Transaction:Rollbacking transaction with id %d (file=%s) - nb open files=%d", this.id, this.transactionFile.getFullName(), this.getNbOpenFiles()));
        }
        this.markTransactionFileAsRollbacked();
        this.tma.clear();
        this.ndfs.release(this);
    }

    public synchronized NdfsFile getFile(String directory, String fileName) {
        String completeFileName = this.getFileName(directory, fileName);
        NdfsFile file = this.openFilesNames.get(completeFileName);
        if (file != null) {
            return file;
        }
        long fileId = this.ndfs.getFileIdFromFullFileName(completeFileName);
        file = new NdfsFileImpl(this, fileId, directory, fileName);
        this.openFilesNames.put(completeFileName, file);
        return file;
    }

    public synchronized NdfsFile getSplitFile(String directory, String fileName, int maxNbBlockPerFile) {
        String completeFileName = this.getFileName(directory, fileName);
        NdfsFile file = this.openFilesNames.get(completeFileName);
        if (file != null) {
            return file;
        }
        long fileId = this.ndfs.getFileIdFromFullFileName(completeFileName);
        file = new SplittedNDFSFileImpl(this, fileId, directory, fileName, maxNbBlockPerFile);
        this.openFilesNames.put(completeFileName, file);
        return file;
    }

    private String getFileName(String directory, String fileName) {
        if (directory == null || directory.equals(".")) {
            return fileName;
        }
        return new StringBuffer(directory).append("/").append(fileName).toString();
    }

    public int getNbOpenFiles() {
        return this.openFilesNames.size();
    }

    public NDFS getNdfs() {
        return this.ndfs;
    }

    public static NdfsTransaction loadFromFile(NdfsFile file) {
        long fileSize = new File(file.getFullName()).length();
        Bytes bytes = file.read(0L, fileSize);
        ByteArrayConverterImpl converter = new ByteArrayConverterImpl(NdfsConfig.debug(), NdfsConfig.getCharacterEncoding(), NeoDatis.getConfig());
        ReadSize readSize = new ReadSize();
        byte status = converter.byteArrayToByte(bytes, 0, readSize, "status");
        long creation = converter.byteArrayToLong(bytes, readSize.get(), readSize, "creation");
        long id = converter.byteArrayToLong(bytes, readSize.get(), readSize, "id");
        NdfsTransactionImpl transaction = new NdfsTransactionImpl(file.getNdfs(), id);
        while ((long)readSize.get() < fileSize) {
            long fileId = converter.byteArrayToLong(bytes, readSize.get(), readSize, "file id");
            long position = converter.byteArrayToLong(bytes, readSize.get(), readSize, "position");
            int length = converter.byteArrayToInt(bytes, readSize.get(), readSize, "length");
            byte[] data = bytes.extract(readSize.get(), length);
            readSize.add(length);
            String fullFileName = file.getNdfs().getFileNameFromFileId(fileId);
            NdfsFile f = null;
            transaction.getTma().add(f, bytes);
        }
        return transaction;
    }
}

