/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jdbm.helper.CacheEntry;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.ICacheEntry;
import jdbm.helper.MRUEnumeration;
import jdbm.helper.ResolvingMRUEnumeration;
import jdbm.helper.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MRU<K, V>
implements CachePolicy<K, V> {
    Hashtable<K, CacheEntry<K, V>> _hash = new Hashtable();
    int _max;
    float _loadFactor;
    CacheEntry<K, V> _first;
    CacheEntry<K, V> _last;
    Vector<CachePolicyListener> listeners = new Vector();
    private int reentrantPutCounter = 0;
    private Vector<ICacheOrderChangeListener<K, V>> _cacheOrderChangeListeners = null;

    public MRU(int max) {
        this(max, 0.75f);
    }

    public MRU(int max, float loadFactor) {
        if (max <= 0) {
            throw new IllegalArgumentException("MRU cache must contain at least one entry");
        }
        this._max = max;
        this._loadFactor = loadFactor;
    }

    public int capacity() {
        return this._max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value, boolean dirty, Serializer<V> ser) throws CacheEvictionException {
        ++this.reentrantPutCounter;
        try {
            CacheEntry<K, V> entry = this._hash.get(key);
            if (entry != null) {
                entry._value = value;
                entry._dirty = dirty;
                entry._ser = ser;
                this.touchEntry(entry);
            } else {
                if (this._hash.size() >= this._max && this.reentrantPutCounter == 1) {
                    while (this._hash.size() >= this._max) {
                        entry = this.purgeEntry();
                    }
                    entry._key = key;
                    entry._value = value;
                    entry._dirty = dirty;
                    entry._ser = ser;
                } else {
                    entry = new CacheEntry<K, V>(key, value, dirty, ser);
                }
                this.addEntry(entry);
                this._hash.put(entry._key, entry);
            }
        }
        finally {
            --this.reentrantPutCounter;
        }
    }

    @Override
    public V get(K key) {
        CacheEntry<K, V> entry = this._hash.get(key);
        if (entry != null) {
            this.touchEntry(entry);
            return entry._value;
        }
        return null;
    }

    @Override
    public void remove(K key) {
        CacheEntry<K, V> entry = this._hash.get(key);
        if (entry != null) {
            this.removeEntry(entry);
            this._hash.remove(entry._key);
        }
    }

    @Override
    public void removeAll() {
        this._hash = new Hashtable(this._max, this._loadFactor);
        this._first = null;
        this._last = null;
    }

    @Override
    public Enumeration<V> elements() {
        return new ResolvingMRUEnumeration(this);
    }

    @Override
    public Enumeration<ICacheEntry<K, V>> entries() {
        return new MRUEnumeration(this);
    }

    @Override
    public void addListener(CachePolicyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Cannot add null listener.");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    @Override
    public void removeListener(CachePolicyListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void addEntry(CacheEntry<K, V> entry) {
        if (this._first == null) {
            this._first = entry;
            this._last = entry;
        } else {
            this._last._next = entry;
            entry._previous = this._last;
            this._last = entry;
        }
    }

    protected void removeEntry(CacheEntry<K, V> entry) {
        if (this._cacheOrderChangeListeners != null) {
            this.fireCacheOrderChangeEvent(true, entry);
        }
        CacheEntry previous = entry._previous;
        CacheEntry next = entry._next;
        if (entry == this._first) {
            this._first = next;
        }
        if (this._last == entry) {
            this._last = previous;
        }
        if (previous != null) {
            previous._next = next;
        }
        if (next != null) {
            next._previous = previous;
        }
        entry._previous = null;
        entry._next = null;
    }

    protected void touchEntry(CacheEntry<K, V> entry) {
        if (this._last == entry) {
            return;
        }
        this.removeEntry(entry);
        this.addEntry(entry);
    }

    protected CacheEntry<K, V> purgeEntry() throws CacheEvictionException {
        CacheEntry<K, V> entry = this._first;
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            CachePolicyListener listener = this.listeners.elementAt(i);
            listener.cacheObjectEvicted(entry._key, entry._value, entry._dirty, entry._ser);
        }
        this.removeEntry(entry);
        this._hash.remove(entry._key);
        entry._value = null;
        return entry;
    }

    protected synchronized void addCacheOrderChangeListener(ICacheOrderChangeListener<K, V> l) {
        if (this._cacheOrderChangeListeners == null) {
            this._cacheOrderChangeListeners = new Vector();
        }
        this._cacheOrderChangeListeners.add(l);
    }

    protected synchronized void removeCacheOrderChangeListener(ICacheOrderChangeListener<K, V> l) {
        if (this._cacheOrderChangeListeners == null) {
            return;
        }
        this._cacheOrderChangeListeners.remove(l);
        if (this._cacheOrderChangeListeners.size() == 0) {
            this._cacheOrderChangeListeners = null;
        }
    }

    private void fireCacheOrderChangeEvent(boolean removed, ICacheEntry<K, V> entry) {
        if (this._cacheOrderChangeListeners == null) {
            return;
        }
        for (ICacheOrderChangeListener<K, V> listener : this._cacheOrderChangeListeners) {
            if (removed) {
                listener.willRemove(entry);
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface ICacheOrderChangeListener<K, V> {
        public void willRemove(ICacheEntry<K, V> var1);
    }
}

