/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.mybatis;

import griffon.plugins.mybatis.MybatisProvider;
import griffon.util.CallableWithArgs;
import griffon.util.GriffonNameUtils;
import groovy.lang.Closure;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMybatisProvider
implements MybatisProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMybatisProvider.class);
    private static final String DEFAULT = "default";

    @Override
    public <R> R withSqlSession(Closure<R> closure) {
        return this.withSqlSession(DEFAULT, closure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withSqlSession(String sessionFactoryName, Closure<R> closure) {
        if (GriffonNameUtils.isBlank((String)sessionFactoryName)) {
            sessionFactoryName = DEFAULT;
        }
        if (closure != null) {
            SqlSessionFactory sf = this.getSessionFactory(sessionFactoryName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing SQL stament on sqlSession '" + sessionFactoryName + "'");
            }
            try (SqlSession session = sf.openSession(true);){
                Object object = closure.call(new Object[]{sessionFactoryName, session});
                return (R)object;
            }
        }
        return null;
    }

    @Override
    public <R> R withSqlSession(CallableWithArgs<R> callable) {
        return this.withSqlSession(DEFAULT, callable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R withSqlSession(String sessionFactoryName, CallableWithArgs<R> callable) {
        if (GriffonNameUtils.isBlank((String)sessionFactoryName)) {
            sessionFactoryName = DEFAULT;
        }
        if (callable != null) {
            SqlSessionFactory sf = this.getSessionFactory(sessionFactoryName);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing SQL stament on sqlSession '" + sessionFactoryName + "'");
            }
            try (SqlSession session = sf.openSession(true);){
                callable.setArgs(new Object[]{sessionFactoryName, session});
                Object object = callable.call();
                return (R)object;
            }
        }
        return null;
    }

    protected abstract SqlSessionFactory getSessionFactory(String var1);
}

