/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.mybatis.MybatisAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.MybatisAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleMybatisAware
extends EclipseAnnotationHandler<MybatisAware> {
    private final EclipseMybatisAwareHandler handler = new EclipseMybatisAwareHandler();

    public void handle(AnnotationValues<MybatisAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(MybatisAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.mybatis.MybatisContributionHandler", (Annotation)source);
        this.handler.addMybatisProviderField(type);
        this.handler.addMybatisProviderAccessors(type);
        this.handler.addMybatisContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseMybatisAwareHandler
    extends MybatisAwareHandler<EclipseType> {
        private EclipseMybatisAwareHandler() {
        }
    }
}

