/*
 * Decompiled with CFR 0.152.
 */
package griffon.plugins.miglayout;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.DefaultProperty;
import javafx.collections.ListChangeListener;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Screen;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.Grid;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutUtil;

@DefaultProperty(value="children")
public class MigLayoutPane
extends Pane {
    private FX2ContainerWrapper fx2ContainerWrapper;
    protected static final Map<Node, CC> cNodeToCC = new WeakHashMap<Node, CC>();
    private Object layoutConstraints = "";
    private Object colConstraints = "";
    private Object rowConstraints = "";
    private transient LC lc = null;
    private transient AC colSpecs = null;
    private transient AC rowSpecs = null;
    private final List<FX2ComponentWrapper> componentWrapperList = new ArrayList<FX2ComponentWrapper>();
    private final Map<Node, FX2ComponentWrapper> nodeToComponentWrapperMap = new WeakHashMap<Node, FX2ComponentWrapper>();
    private final Map<ComponentWrapper, CC> fx2ComponentWrapperToCCMap = new WeakHashMap<ComponentWrapper, CC>();
    private final Map<Node, Integer> nodeToHashcodeMap = new WeakHashMap<Node, Integer>();
    private volatile boolean iDebug = false;
    private volatile Grid grid;
    volatile boolean valid = false;
    private final List<Node> debugRectangles = new ArrayList<Node>();
    private Color debugCellColor = Color.RED;
    private Color debugExternalColor = Color.BLUE;
    private Color debugOutlineColor = Color.GREEN;
    private Color debugContainerOutlineColor = Color.PURPLE;
    private String fxmLayoutConstraints;
    private String fxmlColumConstraints;
    private String fxmlRowConstraints;

    public MigLayoutPane() {
        this("", "", "");
    }

    public MigLayoutPane(LC layoutConstraints) {
        this(layoutConstraints, null, null);
    }

    public MigLayoutPane(LC layoutConstraints, AC colConstraints) {
        this(layoutConstraints, colConstraints, null);
    }

    public MigLayoutPane(LC layoutConstraints, AC colConstraints, AC rowConstraints) {
        this.setLayoutConstraints(layoutConstraints);
        this.setColumnConstraints(colConstraints);
        this.setRowConstraints(rowConstraints);
        this.construct();
    }

    public MigLayoutPane(String layoutConstraints) {
        this(layoutConstraints, "", "");
    }

    public MigLayoutPane(String layoutConstraints, String colConstraints) {
        this(layoutConstraints, colConstraints, "");
    }

    public MigLayoutPane(String layoutConstraints, String colConstraints, String rowConstraints) {
        this.setLayoutConstraints(layoutConstraints);
        this.setColumnConstraints(colConstraints);
        this.setRowConstraints(rowConstraints);
        this.construct();
    }

    private void construct() {
        if (this.getLayoutConstraints() == null) {
            this.setLayoutConstraints(new LC());
        }
        if (this.getRowConstraints() == null) {
            this.setRowConstraints(new AC());
        }
        if (this.getColumnConstraints() == null) {
            this.setColumnConstraints(new AC());
        }
        this.fx2ContainerWrapper = new FX2ContainerWrapper((Node)this);
        this.getChildren().addListener((ListChangeListener)new ListChangeListener<Node>(){

            public void onChanged(ListChangeListener.Change<? extends Node> c) {
                while (c.next()) {
                    for (Node node : c.getRemoved()) {
                        if (node instanceof DebugRectangle) continue;
                        FX2ComponentWrapper lFX2ComponentWrapper = (FX2ComponentWrapper)MigLayoutPane.this.nodeToComponentWrapperMap.remove(node);
                        MigLayoutPane.this.componentWrapperList.remove(lFX2ComponentWrapper);
                        MigLayoutPane.this.fx2ComponentWrapperToCCMap.remove(lFX2ComponentWrapper);
                        MigLayoutPane.this.invalidateMigLayoutGrid();
                    }
                    for (Node node : c.getAddedSubList()) {
                        if (node instanceof DebugRectangle) continue;
                        CC cc = cNodeToCC.remove(node);
                        if (cc == null) {
                            cc = new CC();
                        }
                        FX2ComponentWrapper lFX2ComponentWrapper = new FX2ComponentWrapper(node);
                        MigLayoutPane.this.componentWrapperList.add(lFX2ComponentWrapper);
                        MigLayoutPane.this.nodeToComponentWrapperMap.put(node, lFX2ComponentWrapper);
                        MigLayoutPane.this.fx2ComponentWrapperToCCMap.put(lFX2ComponentWrapper, cc);
                        MigLayoutPane.this.invalidateMigLayoutGrid();
                    }
                }
            }
        });
        this.createMigLayoutGrid();
    }

    public Object getLayoutConstraints() {
        return this.layoutConstraints;
    }

    public void setLayoutConstraints(Object constr) {
        if (constr == null || constr instanceof String) {
            constr = ConstraintParser.prepare((String)((String)constr));
            this.lc = ConstraintParser.parseLayoutConstraint((String)((String)constr));
        } else if (constr instanceof LC) {
            this.lc = (LC)constr;
        } else {
            throw new IllegalArgumentException("Illegal constraint type: " + constr.getClass().toString());
        }
        this.layoutConstraints = constr;
    }

    public Object getColumnConstraints() {
        return this.colConstraints;
    }

    public void setColumnConstraints(Object constr) {
        if (constr == null || constr instanceof String) {
            constr = ConstraintParser.prepare((String)((String)constr));
            this.colSpecs = ConstraintParser.parseColumnConstraints((String)((String)constr));
        } else if (constr instanceof AC) {
            this.colSpecs = (AC)constr;
        } else {
            throw new IllegalArgumentException("Illegal constraint type: " + constr.getClass().toString());
        }
        this.colConstraints = constr;
    }

    public Object getRowConstraints() {
        return this.rowConstraints;
    }

    public void setRowConstraints(Object constr) {
        if (constr == null || constr instanceof String) {
            constr = ConstraintParser.prepare((String)((String)constr));
            this.rowSpecs = ConstraintParser.parseRowConstraints((String)((String)constr));
        } else if (constr instanceof AC) {
            this.rowSpecs = (AC)constr;
        } else {
            throw new IllegalArgumentException("Illegal constraint type: " + constr.getClass().toString());
        }
        this.rowConstraints = constr;
    }

    public void add(Node node, CC cc) {
        cNodeToCC.put(node, cc);
        this.getChildren().add((Object)node);
    }

    public void add(Node node) {
        this.add(node, new CC());
    }

    public void add(Node node, String cc) {
        CC lCC = ConstraintParser.parseComponentConstraint((String)ConstraintParser.prepare((String)cc));
        this.add(node, lCC);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.validateMigLayoutGrid();
        int[] lBounds = new int[]{0, 0, (int)Math.ceil(this.getWidth()), (int)Math.ceil(this.getHeight())};
        this.grid.layout(lBounds, this.lc.getAlignX(), this.lc.getAlignY(), this.iDebug, true);
        if (this.iDebug) {
            this.clearDebug();
            this.grid.paintDebug();
        }
    }

    private void createMigLayoutGrid() {
        this.grid = new Grid((ContainerWrapper)this.fx2ContainerWrapper, this.lc, this.rowSpecs, this.colSpecs, this.fx2ComponentWrapperToCCMap, null);
        this.valid = true;
        this.setMinWidth(LayoutUtil.getSizeSafe((int[])this.grid.getWidth(), (int)0));
        this.setPrefWidth(LayoutUtil.getSizeSafe((int[])this.grid.getWidth(), (int)1));
        this.setMaxWidth(LayoutUtil.getSizeSafe((int[])this.grid.getWidth(), (int)2));
        this.setMinHeight(LayoutUtil.getSizeSafe((int[])this.grid.getHeight(), (int)0));
        this.setPrefHeight(LayoutUtil.getSizeSafe((int[])this.grid.getHeight(), (int)1));
        this.setMaxHeight(LayoutUtil.getSizeSafe((int[])this.grid.getHeight(), (int)2));
    }

    private void validateMigLayoutGrid() {
        if (this.isMiglayoutGridValid()) {
            for (Node lChild : this.getChildren()) {
                if (!this.nodeToComponentWrapperMap.containsKey(lChild)) continue;
                Integer lPreviousHashcode = this.nodeToHashcodeMap.get(lChild);
                Integer lCurrentHashcode = this.calculateHashcode(lChild);
                if (lPreviousHashcode != null && lPreviousHashcode.equals(lCurrentHashcode)) continue;
                this.invalidateMigLayoutGrid();
                this.nodeToHashcodeMap.put(lChild, (int)lCurrentHashcode);
            }
        }
        if (!this.isMiglayoutGridValid()) {
            this.createMigLayoutGrid();
        }
    }

    private void invalidateMigLayoutGrid() {
        this.valid = false;
    }

    private boolean isMiglayoutGridValid() {
        return this.valid;
    }

    private Integer calculateHashcode(Node node) {
        StringBuffer lStringBuffer = new StringBuffer();
        lStringBuffer.append(node.minWidth(-1.0));
        lStringBuffer.append("x");
        lStringBuffer.append(node.minHeight(-1.0));
        lStringBuffer.append("/");
        lStringBuffer.append(node.prefWidth(-1.0));
        lStringBuffer.append("x");
        lStringBuffer.append(node.prefHeight(-1.0));
        lStringBuffer.append("/");
        lStringBuffer.append(node.maxWidth(-1.0));
        lStringBuffer.append("x");
        lStringBuffer.append(node.maxHeight(-1.0));
        lStringBuffer.append("/");
        lStringBuffer.append(node.getLayoutBounds().getWidth());
        lStringBuffer.append("x");
        lStringBuffer.append(node.getLayoutBounds().getHeight());
        lStringBuffer.append("/");
        lStringBuffer.append(node.isVisible());
        return lStringBuffer.toString().hashCode();
    }

    public void clearDebug() {
        this.getChildren().removeAll(this.debugRectangles);
        this.debugRectangles.clear();
    }

    private void addDebugRectangle(double x, double y, double w, double h, DebugRectangleType type) {
        DebugRectangle lRectangle = new DebugRectangle(x, y, w, h);
        if (type == DebugRectangleType.CELL) {
            lRectangle.setStroke((Paint)this.getDebugCellColor());
            lRectangle.getStrokeDashArray().addAll((Object[])new Double[]{3.0, 3.0});
        } else if (type == DebugRectangleType.EXTERNAL) {
            lRectangle.setStroke((Paint)this.getDebugExternalColor());
            lRectangle.getStrokeDashArray().addAll((Object[])new Double[]{5.0, 5.0});
        } else if (type == DebugRectangleType.OUTLINE) {
            lRectangle.setStroke((Paint)this.getDebugOutlineColor());
            lRectangle.getStrokeDashArray().addAll((Object[])new Double[]{4.0, 4.0});
        } else if (type == DebugRectangleType.CONTAINER_OUTLINE) {
            lRectangle.setStroke((Paint)this.getDebugContainerOutlineColor());
            lRectangle.getStrokeDashArray().addAll((Object[])new Double[]{7.0, 7.0});
        } else {
            throw new IllegalStateException("Unknown debug rectangle type");
        }
        lRectangle.setFill(null);
        lRectangle.mouseTransparentProperty().set(true);
        this.getChildren().add((Object)lRectangle);
        this.debugRectangles.add((Node)lRectangle);
    }

    public Color getDebugCellColor() {
        return this.debugCellColor;
    }

    public void setDebugCellColor(Color value) {
        this.debugCellColor = value;
    }

    public Color getDebugExternalColor() {
        return this.debugExternalColor;
    }

    public void setDebugExternalColor(Color value) {
        this.debugExternalColor = value;
    }

    public Color getDebugOutlineColor() {
        return this.debugOutlineColor;
    }

    public void setDebugOutlineColor(Color value) {
        this.debugOutlineColor = value;
    }

    public Color getDebugContainerOutlineColor() {
        return this.debugContainerOutlineColor;
    }

    public void setDebugContainerOutlineColor(Color value) {
        this.debugContainerOutlineColor = value;
    }

    protected double computeMaxHeight(double width) {
        int h = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getHeight() : null), (int)2);
        return h;
    }

    protected double computeMaxWidth(double height) {
        int w = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getWidth() : null), (int)2);
        return w;
    }

    protected double computeMinHeight(double width) {
        int h = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getHeight() : null), (int)0);
        return h;
    }

    protected double computeMinWidth(double height) {
        int w = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getWidth() : null), (int)0);
        return w;
    }

    protected double computePrefHeight(double width) {
        int h = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getHeight() : null), (int)1);
        return h;
    }

    protected double computePrefWidth(double height) {
        int w = LayoutUtil.getSizeSafe((int[])(this.grid != null ? this.grid.getWidth() : null), (int)1);
        return w;
    }

    public void setLayout(String value) {
        this.fxmLayoutConstraints = value;
        this.setLayoutConstraints(ConstraintParser.parseLayoutConstraint((String)ConstraintParser.prepare((String)value)));
    }

    public String getLayout() {
        return this.fxmLayoutConstraints;
    }

    public void setCols(String value) {
        this.fxmlColumConstraints = value;
        this.setColumnConstraints(ConstraintParser.parseColumnConstraints((String)ConstraintParser.prepare((String)value)));
    }

    public String getCols() {
        return this.fxmlColumConstraints;
    }

    public void setRows(String value) {
        this.fxmlRowConstraints = value;
        this.setRowConstraints(ConstraintParser.parseRowConstraints((String)ConstraintParser.prepare((String)value)));
    }

    public String getRows() {
        return this.fxmlRowConstraints;
    }

    public static void setCc(Node node, CC cc) {
        cNodeToCC.put(node, cc);
    }

    public static void setCc(Node node, String cc) {
        CC lCC = ConstraintParser.parseComponentConstraint((String)ConstraintParser.prepare((String)cc));
        MigLayoutPane.setCc(node, lCC);
    }

    class FX2ComponentWrapper
    implements ComponentWrapper {
        protected final Node node;

        public FX2ComponentWrapper(Node node) {
            this.node = node;
        }

        public Object getComponent() {
            return this.node;
        }

        public ContainerWrapper getParent() {
            return MigLayoutPane.this.fx2ContainerWrapper;
        }

        public int getComponetType(boolean arg0) {
            if (this.node instanceof TextField || this.node instanceof TextArea) {
                return 3;
            }
            if (this.node instanceof Group) {
                return 1;
            }
            return 0;
        }

        public void setBounds(int x, int y, int width, int height) {
            this.node.resizeRelocate((double)x, (double)y, (double)width, (double)height);
        }

        public int getX() {
            int v = (int)Math.ceil(this.node.getLayoutBounds().getMinX());
            return v;
        }

        public int getY() {
            int v = (int)Math.ceil(this.node.getLayoutBounds().getMinY());
            return v;
        }

        public int getWidth() {
            int v = (int)Math.ceil(this.node.getLayoutBounds().getWidth());
            return v;
        }

        public int getMinimumWidth(int height) {
            int v = (int)Math.ceil(this.node.minWidth((double)height));
            return v;
        }

        public int getPreferredWidth(int height) {
            int v = (int)Math.ceil(this.node.prefWidth((double)height));
            return v;
        }

        public int getMaximumWidth(int height) {
            int v = (int)Math.ceil(this.node.maxWidth((double)height));
            if (this.node instanceof Button) {
                v = Integer.MAX_VALUE;
            }
            if (this.node instanceof ToggleButton) {
                v = Integer.MAX_VALUE;
            }
            if (this.node instanceof CheckBox) {
                v = Integer.MAX_VALUE;
            }
            if (this.node instanceof ChoiceBox) {
                v = Integer.MAX_VALUE;
            }
            return v;
        }

        public int getHeight() {
            int v = (int)Math.ceil(this.node.getLayoutBounds().getHeight());
            return v;
        }

        public int getMinimumHeight(int width) {
            int v = (int)Math.ceil(this.node.minHeight((double)width));
            return v;
        }

        public int getPreferredHeight(int width) {
            int v = (int)Math.ceil(this.node.prefHeight((double)width));
            return v;
        }

        public int getMaximumHeight(int width) {
            int v = (int)Math.ceil(this.node.maxHeight((double)width));
            return v;
        }

        public int getBaseline(int width, int height) {
            return -1;
        }

        public int getScreenLocationX() {
            Bounds lBoundsInScenenode = this.node.localToScene(this.node.getBoundsInLocal());
            int v = (int)Math.ceil(this.node.getScene().getX() + this.node.getScene().getX() + lBoundsInScenenode.getMinX());
            return v;
        }

        public int getScreenLocationY() {
            Bounds lBoundsInScenenode = this.node.localToScene(this.node.getBoundsInLocal());
            int v = (int)Math.ceil(this.node.getScene().getY() + this.node.getScene().getY() + lBoundsInScenenode.getMinY());
            return v;
        }

        public int getScreenHeight() {
            int v = (int)Math.ceil(Screen.getPrimary().getBounds().getHeight());
            return v;
        }

        public int getScreenWidth() {
            int v = (int)Math.ceil(Screen.getPrimary().getBounds().getWidth());
            return v;
        }

        public int[] getVisualPadding() {
            return null;
        }

        public int getHorizontalScreenDPI() {
            return (int)Math.ceil(Screen.getPrimary().getDpi());
        }

        public int getVerticalScreenDPI() {
            return (int)Math.ceil(Screen.getPrimary().getDpi());
        }

        public float getPixelUnitFactor(boolean arg0) {
            return 1.0f;
        }

        public int getLayoutHashCode() {
            int lHashCode = 0;
            lHashCode += (int)this.node.getLayoutBounds().getWidth() + (int)this.node.getLayoutBounds().getHeight() * 32;
            if (this.node.isVisible()) {
                lHashCode += 1324511;
            }
            if (this.node.isManaged()) {
                lHashCode += 1324513;
            }
            if (this.node.getId().length() > 0) {
                lHashCode += this.node.getId().hashCode();
            }
            return lHashCode;
        }

        public String getLinkId() {
            return this.node.getId();
        }

        public boolean hasBaseline() {
            return false;
        }

        public boolean isVisible() {
            return this.node.isVisible();
        }

        public void paintDebugOutline() {
            ComponentWrapper lComponentWrapper = (ComponentWrapper)MigLayoutPane.this.nodeToComponentWrapperMap.get(this.node);
            CC lCC = (CC)MigLayoutPane.this.fx2ComponentWrapperToCCMap.get(lComponentWrapper);
            if (lCC != null && lCC.isExternal()) {
                MigLayoutPane.this.addDebugRectangle(this.node.getLayoutX() + this.node.getLayoutBounds().getMinX(), this.node.getLayoutY() + this.node.getLayoutBounds().getMinY(), this.getWidth(), this.getHeight(), DebugRectangleType.EXTERNAL);
            } else {
                MigLayoutPane.this.addDebugRectangle(this.node.getLayoutX() + this.node.getLayoutBounds().getMinX(), this.node.getLayoutY() + this.node.getLayoutBounds().getMinY(), this.getWidth(), this.getHeight(), DebugRectangleType.OUTLINE);
            }
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof FX2ComponentWrapper)) {
                return false;
            }
            return this.getComponent().equals(((FX2ComponentWrapper)o).getComponent());
        }
    }

    class FX2ContainerWrapper
    extends FX2ComponentWrapper
    implements ContainerWrapper {
        public FX2ContainerWrapper(Node node) {
            super(node);
        }

        public ComponentWrapper[] getComponents() {
            return MigLayoutPane.this.componentWrapperList.toArray(new FX2ComponentWrapper[0]);
        }

        public int getComponentCount() {
            return MigLayoutPane.this.fx2ComponentWrapperToCCMap.size();
        }

        public Object getLayout() {
            return MigLayoutPane.this;
        }

        public boolean isLeftToRight() {
            return true;
        }

        public void paintDebugCell(int x, int y, int w, int h) {
            MigLayoutPane.this.addDebugRectangle(x, y, w, h, DebugRectangleType.CELL);
        }

        @Override
        public void paintDebugOutline() {
            MigLayoutPane.this.addDebugRectangle(0.0, 0.0, this.getWidth(), this.getHeight(), DebugRectangleType.CONTAINER_OUTLINE);
        }
    }

    class DebugRectangle
    extends Rectangle {
        public DebugRectangle(double x, double y, double w, double h) {
            super(x, y, w, h);
        }
    }

    static enum DebugRectangleType {
        CELL,
        OUTLINE,
        CONTAINER_OUTLINE,
        EXTERNAL;

    }
}

