/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.auth;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.compat.SpyThread;
import net.spy.memcached.ops.Operation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationStatus;

public class AuthThread
extends SpyThread {
    private final MemcachedConnection conn;
    private final AuthDescriptor authDescriptor;
    private final OperationFactory opFact;
    private final MemcachedNode node;

    public AuthThread(MemcachedConnection c, OperationFactory o, AuthDescriptor a, MemcachedNode n) {
        this.conn = c;
        this.opFact = o;
        this.authDescriptor = a;
        this.node = n;
        this.start();
    }

    @Override
    public void run() {
        OperationStatus priorStatus = null;
        final AtomicBoolean done = new AtomicBoolean();
        while (!done.get()) {
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference foundStatus = new AtomicReference();
            OperationCallback cb = new OperationCallback(){

                @Override
                public void receivedStatus(OperationStatus val) {
                    if (val.getMessage().length() == 0) {
                        done.set(true);
                        AuthThread.this.node.authComplete();
                        AuthThread.this.getLogger().info("Authenticated to " + AuthThread.this.node.getSocketAddress());
                    } else {
                        foundStatus.set(val);
                    }
                }

                @Override
                public void complete() {
                    latch.countDown();
                }
            };
            Operation op = this.buildOperation(priorStatus, cb);
            this.conn.insertOperation(this.node, op);
            try {
                latch.await();
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (op != null) {
                    op.cancel();
                }
                done.set(true);
            }
            if ((priorStatus = (OperationStatus)foundStatus.get()) == null || priorStatus.isSuccess()) continue;
            this.getLogger().warn("Authentication failed to " + this.node.getSocketAddress());
        }
    }

    private Operation buildOperation(OperationStatus st, OperationCallback cb) {
        if (st == null) {
            return this.opFact.saslAuth(this.authDescriptor.getMechs(), this.node.getSocketAddress().toString(), null, this.authDescriptor.getCallback(), cb);
        }
        return this.opFact.saslStep(this.authDescriptor.getMechs(), KeyUtil.getKeyBytes(st.getMessage()), this.node.getSocketAddress().toString(), null, this.authDescriptor.getCallback(), cb);
    }
}

