/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import net.spy.memcached.HashAlgorithm;
import net.spy.memcached.KetamaIterator;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.MemcachedNodeROImpl;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.util.DefaultKetamaNodeLocatorConfiguration;
import net.spy.memcached.util.KetamaNodeLocatorConfiguration;
import net.spy.memcached.vbucket.config.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KetamaNodeLocator
extends SpyObject
implements NodeLocator {
    private volatile TreeMap<Long, MemcachedNode> ketamaNodes;
    final Collection<MemcachedNode> allNodes;
    final HashAlgorithm hashAlg;
    final KetamaNodeLocatorConfiguration config;

    public KetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg) {
        this(nodes, alg, new DefaultKetamaNodeLocatorConfiguration());
    }

    public KetamaNodeLocator(List<MemcachedNode> nodes, HashAlgorithm alg, KetamaNodeLocatorConfiguration conf) {
        this.allNodes = nodes;
        this.hashAlg = alg;
        this.config = conf;
        this.setKetamaNodes(nodes);
    }

    private KetamaNodeLocator(TreeMap<Long, MemcachedNode> smn, Collection<MemcachedNode> an, HashAlgorithm alg, KetamaNodeLocatorConfiguration conf) {
        this.ketamaNodes = smn;
        this.allNodes = an;
        this.hashAlg = alg;
        this.config = conf;
    }

    @Override
    public Collection<MemcachedNode> getAll() {
        return this.allNodes;
    }

    @Override
    public MemcachedNode getPrimary(String k) {
        MemcachedNode rv = this.getNodeForKey(this.hashAlg.hash(k));
        assert (rv != null) : "Found no node for key " + k;
        return rv;
    }

    long getMaxKey() {
        return this.getKetamaNodes().lastKey();
    }

    MemcachedNode getNodeForKey(long hash) {
        if (!this.ketamaNodes.containsKey(hash)) {
            SortedMap<Long, MemcachedNode> tailMap = this.getKetamaNodes().tailMap(hash);
            hash = tailMap.isEmpty() ? this.getKetamaNodes().firstKey().longValue() : tailMap.firstKey().longValue();
        }
        MemcachedNode rv = this.getKetamaNodes().get(hash);
        return rv;
    }

    @Override
    public Iterator<MemcachedNode> getSequence(String k) {
        return new KetamaIterator(k, 7, this.getKetamaNodes(), this.hashAlg);
    }

    @Override
    public NodeLocator getReadonlyCopy() {
        TreeMap<Long, MemcachedNode> smn = new TreeMap<Long, MemcachedNode>((SortedMap<Long, MemcachedNode>)this.getKetamaNodes());
        ArrayList<MemcachedNode> an = new ArrayList<MemcachedNode>(this.allNodes.size());
        for (Map.Entry<Long, MemcachedNode> me : smn.entrySet()) {
            me.setValue(new MemcachedNodeROImpl(me.getValue()));
        }
        for (MemcachedNode n : this.allNodes) {
            an.add(new MemcachedNodeROImpl(n));
        }
        return new KetamaNodeLocator(smn, an, this.hashAlg, this.config);
    }

    @Override
    public void updateLocator(List<MemcachedNode> nodes, Config conf) {
        this.setKetamaNodes(nodes);
    }

    protected TreeMap<Long, MemcachedNode> getKetamaNodes() {
        return this.ketamaNodes;
    }

    protected void setKetamaNodes(List<MemcachedNode> nodes) {
        TreeMap<Long, MemcachedNode> newNodeMap = new TreeMap<Long, MemcachedNode>();
        int numReps = this.config.getNodeRepetitions();
        for (MemcachedNode node : nodes) {
            int i;
            if (this.hashAlg == HashAlgorithm.KETAMA_HASH) {
                for (i = 0; i < numReps / 4; ++i) {
                    byte[] digest = HashAlgorithm.computeMd5(this.config.getKeyForNode(node, i));
                    for (int h = 0; h < 4; ++h) {
                        Long k = (long)(digest[3 + h * 4] & 0xFF) << 24 | (long)(digest[2 + h * 4] & 0xFF) << 16 | (long)(digest[1 + h * 4] & 0xFF) << 8 | (long)(digest[h * 4] & 0xFF);
                        newNodeMap.put(k, node);
                        this.getLogger().debug("Adding node %s in position %d", node, k);
                    }
                }
                continue;
            }
            for (i = 0; i < numReps; ++i) {
                newNodeMap.put(this.hashAlg.hash(this.config.getKeyForNode(node, i)), node);
            }
        }
        assert (newNodeMap.size() == numReps * nodes.size());
        this.ketamaNodes = newNodeMap;
    }
}

