/*
 * Decompiled with CFR 0.152.
 */
package lombok.eclipse.handlers;

import griffon.plugins.mail.MailAware;
import lombok.core.AnnotationValues;
import lombok.core.handlers.MailAwareHandler;
import lombok.core.util.ErrorMessages;
import lombok.eclipse.EclipseAnnotationHandler;
import lombok.eclipse.EclipseNode;
import lombok.eclipse.handlers.EclipseUtil;
import lombok.eclipse.handlers.ast.EclipseType;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class HandleMailAware
extends EclipseAnnotationHandler<MailAware> {
    private final EclipseMailAwareHandler handler = new EclipseMailAwareHandler();

    public void handle(AnnotationValues<MailAware> annotation, Annotation source, EclipseNode annotationNode) {
        EclipseType type = EclipseType.typeOf((EclipseNode)annotationNode, (ASTNode)source);
        if (type.isAnnotation() || type.isInterface()) {
            annotationNode.addError(ErrorMessages.canBeUsedOnClassAndEnumOnly(MailAware.class));
            return;
        }
        EclipseUtil.addInterface((TypeDeclaration)type.get(), (String)"griffon.plugins.mail.MailContributionHandler", (Annotation)source);
        this.handler.addMailProviderField(type);
        this.handler.addMailProviderAccessors(type);
        this.handler.addMailContributionMethods(type);
        type.editor().rebuild();
    }

    private static class EclipseMailAwareHandler
    extends MailAwareHandler<EclipseType> {
        private EclipseMailAwareHandler() {
        }
    }
}

