/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.ast;

import griffon.plugins.mail.DefaultMailProvider;
import griffon.plugins.mail.MailAware;
import griffon.plugins.mail.MailContributionHandler;
import griffon.plugins.mail.MailProvider;
import java.util.ArrayList;
import java.util.Arrays;
import lombok.core.handlers.MailAwareConstants;
import org.codehaus.griffon.ast.AbstractASTTransformation;
import org.codehaus.griffon.ast.GriffonASTUtils;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SimpleMessage;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class MailAwareASTTransformation
extends AbstractASTTransformation
implements MailAwareConstants {
    private static final Logger LOG = LoggerFactory.getLogger(MailAwareASTTransformation.class);
    private static final ClassNode MAIL_CONTRIBUTION_HANDLER_CNODE = MailAwareASTTransformation.makeClassSafe(MailContributionHandler.class);
    private static final ClassNode MAIL_AWARE_CNODE = MailAwareASTTransformation.makeClassSafe(MailAware.class);
    private static final ClassNode MAIL_PROVIDER_CNODE = MailAwareASTTransformation.makeClassSafe(MailProvider.class);
    private static final ClassNode DEFAULT_MAIL_PROVIDER_CNODE = MailAwareASTTransformation.makeClassSafe(DefaultMailProvider.class);
    private static final String[] DELEGATING_METHODS = new String[]{"withMail"};

    public static boolean hasMailAwareAnnotation(AnnotatedNode node) {
        for (AnnotationNode annotation : node.getAnnotations()) {
            if (!MAIL_AWARE_CNODE.equals((Object)annotation.getClassNode())) continue;
            return true;
        }
        return false;
    }

    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.checkNodesForAnnotationAndType(nodes[0], nodes[1]);
        MailAwareASTTransformation.addMailContributionIfNeeded(source, (ClassNode)nodes[1]);
    }

    public static void addMailContributionIfNeeded(SourceUnit source, ClassNode classNode) {
        if (MailAwareASTTransformation.needsMailContribution(classNode, source)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Injecting " + MailContributionHandler.class.getName() + " into " + classNode.getName());
            }
            MailAwareASTTransformation.apply(classNode);
        }
    }

    protected static boolean needsMailContribution(ClassNode declaringClass, SourceUnit sourceUnit) {
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        boolean found4 = false;
        for (ClassNode consideredClass = declaringClass; consideredClass != null; consideredClass = consideredClass.getSuperClass()) {
            for (MethodNode method : consideredClass.getMethods()) {
                found1 = method.getName().equals("withMail") && method.getParameters().length == 1;
                found2 = method.getName().equals("withMail") && method.getParameters().length == 2;
                found3 = method.getName().equals("setMailProvider") && method.getParameters().length == 1;
                boolean bl = found4 = method.getName().equals("getMailProvider") && method.getParameters().length == 0;
                if (!found1 || !found2 || !found3 || !found4) continue;
                return false;
            }
        }
        if (found1 || found2 || found3 || found4) {
            sourceUnit.getErrorCollector().addErrorAndContinue((Message)new SimpleMessage("@MailAware cannot be processed on " + declaringClass.getName() + " because some but not all of methods from " + MailContributionHandler.class.getName() + " were declared in the current class or super classes.", (ProcessingUnit)sourceUnit));
            return false;
        }
        return true;
    }

    public static void apply(ClassNode declaringClass) {
        GriffonASTUtils.injectInterface((ClassNode)declaringClass, (ClassNode)MAIL_CONTRIBUTION_HANDLER_CNODE);
        FieldNode providerField = declaringClass.addField("this$mailProvider", 4098, MAIL_PROVIDER_CNODE, MailAwareASTTransformation.defaultMailProviderInstance());
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("getMailProvider", 1, MAIL_PROVIDER_CNODE, Parameter.EMPTY_ARRAY, GriffonASTUtils.NO_EXCEPTIONS, GriffonASTUtils.returns((Expression)GriffonASTUtils.field((FieldNode)providerField))));
        GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)new MethodNode("setMailProvider", 1, ClassHelper.VOID_TYPE, GriffonASTUtils.params((Parameter[])new Parameter[]{GriffonASTUtils.param((ClassNode)MAIL_PROVIDER_CNODE, (String)"provider")}), GriffonASTUtils.NO_EXCEPTIONS, (Statement)GriffonASTUtils.block((Statement[])new Statement[]{GriffonASTUtils.ifs_no_return((Expression)GriffonASTUtils.cmp((Expression)GriffonASTUtils.var((String)"provider"), (Expression)ConstantExpression.NULL), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)MailAwareASTTransformation.defaultMailProviderInstance()), (Statement)GriffonASTUtils.assigns((Expression)GriffonASTUtils.field((FieldNode)providerField), (Expression)GriffonASTUtils.var((String)"provider")))})));
        for (MethodNode method : MAIL_CONTRIBUTION_HANDLER_CNODE.getMethods()) {
            if (Arrays.binarySearch(DELEGATING_METHODS, method.getName()) < 0) continue;
            ArrayList<VariableExpression> variables = new ArrayList<VariableExpression>();
            Parameter[] parameters = new Parameter[method.getParameters().length];
            for (int i = 0; i < method.getParameters().length; ++i) {
                Parameter p = method.getParameters()[i];
                parameters[i] = new Parameter(MailAwareASTTransformation.makeClassSafe((ClassNode)p.getType()), p.getName());
                parameters[i].getType().setGenericsTypes(p.getType().getGenericsTypes());
                variables.add(GriffonASTUtils.var((String)p.getName()));
            }
            ClassNode returnType = MailAwareASTTransformation.makeClassSafe((ClassNode)method.getReturnType());
            returnType.setGenericsTypes(method.getReturnType().getGenericsTypes());
            returnType.setGenericsPlaceHolder(method.getReturnType().isGenericsPlaceHolder());
            MethodNode newMethod = new MethodNode(method.getName(), 1, returnType, parameters, GriffonASTUtils.NO_EXCEPTIONS, (Statement)GriffonASTUtils.stmnt((Expression)GriffonASTUtils.call((Expression)GriffonASTUtils.field((FieldNode)providerField), (String)method.getName(), (ArgumentListExpression)GriffonASTUtils.args(variables))));
            newMethod.setGenericsTypes(method.getGenericsTypes());
            GriffonASTUtils.injectMethod((ClassNode)declaringClass, (MethodNode)newMethod);
        }
    }

    private static Expression defaultMailProviderInstance() {
        return GriffonASTUtils.call((ClassNode)DEFAULT_MAIL_PROVIDER_CNODE, (String)"getInstance", (ArgumentListExpression)GriffonASTUtils.NO_ARGS);
    }

    static {
        Arrays.sort(DELEGATING_METHODS);
    }
}

