/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.util;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import net.beeger.squareness.SquarenessLookAndFeel;

public class SquarenessButtonPainter {
    public static void paintButton(Graphics graphics, AbstractButton button) {
        Color oldColor = graphics.getColor();
        ButtonModel model = button.getModel();
        Insets buttonInsets = SquarenessButtonPainter.getInnermostOpaqueBorderInsets(button.getBorder(), button);
        if (buttonInsets == null) {
            buttonInsets = new Insets(0, 0, 0, 0);
        }
        boolean isRollover = (Boolean)button.getClientProperty("SquarenessRollover");
        if (buttonInsets.top == 0 && buttonInsets.bottom == 0 && buttonInsets.right == 0 && buttonInsets.left == 0 && button.getBackground() instanceof UIResource) {
            SquarenessButtonPainter.paintBorderlessButton(graphics, button);
        } else if (button.isEnabled() && (isRollover || model.isArmed() && model.isPressed() || button.hasFocus() || button.isSelected())) {
            boolean paintShadow = model.isArmed() && model.isPressed() || button.isSelected() && !isRollover;
            SquarenessButtonPainter.paintNormalButton(graphics, buttonInsets, button, paintShadow);
        } else if (button.getParent() != null && button.getParent() instanceof JToolBar && ((JToolBar)button.getParent()).getClientProperty("JToolBar.isRollover") != null && ((Boolean)((JToolBar)button.getParent()).getClientProperty("JToolBar.isRollover")).booleanValue()) {
            SquarenessButtonPainter.paintBorderlessButton(graphics, button);
        }
        graphics.setColor(oldColor);
    }

    private static void paintNormalButton(Graphics graphics, Insets buttonInsets, AbstractButton button, boolean paintShadow) {
        graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor());
        graphics.fillRect(buttonInsets.left, buttonInsets.top, button.getWidth() - buttonInsets.right, button.getHeight() - buttonInsets.bottom);
        if (paintShadow) {
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundShadowColor());
            graphics.fillRect(buttonInsets.left, buttonInsets.top, 2, button.getHeight() - buttonInsets.bottom);
            graphics.fillRect(buttonInsets.left, buttonInsets.top, button.getWidth() - buttonInsets.right, 2);
        }
    }

    private static void paintBorderlessButton(Graphics graphics, AbstractButton button) {
        graphics.setColor(button.getParent() != null ? button.getParent().getBackground() : SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
        graphics.fillRect(0, 0, button.getWidth(), button.getHeight());
    }

    private static Insets getInnermostOpaqueBorderInsets(Border border, JComponent component) {
        Insets result = null;
        if (border != null) {
            if (border instanceof CompoundBorder) {
                CompoundBorder compoundBorder = (CompoundBorder)border;
                Insets insets = SquarenessButtonPainter.getInnermostOpaqueBorderInsets(compoundBorder.getInsideBorder(), component);
                if (insets != null) {
                    result = new Insets(0, 0, 0, 0);
                    SquarenessButtonPainter.addInsets(result, compoundBorder.getOutsideBorder().getBorderInsets(component));
                    SquarenessButtonPainter.addInsets(result, insets);
                } else {
                    insets = SquarenessButtonPainter.getInnermostOpaqueBorderInsets(compoundBorder.getOutsideBorder(), component);
                    if (insets != null) {
                        result = new Insets(0, 0, 0, 0);
                        SquarenessButtonPainter.addInsets(result, insets);
                    }
                }
            } else if (border.isBorderOpaque()) {
                result = border.getBorderInsets(component);
            }
        }
        return result;
    }

    private static void addInsets(Insets insetsToAddTo, Insets insetsToAdd) {
        insetsToAddTo.top += insetsToAdd.top;
        insetsToAddTo.bottom += insetsToAdd.bottom;
        insetsToAddTo.right += insetsToAdd.right;
        insetsToAddTo.left += insetsToAdd.left;
    }
}

