/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.delegate;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import net.beeger.squareness.SquarenessLookAndFeel;

public class SquarenessSliderUI
extends BasicSliderUI {
    public static ComponentUI createUI(JComponent component) {
        return new SquarenessSliderUI((JSlider)component);
    }

    public SquarenessSliderUI(JSlider slider) {
        super(slider);
    }

    public void paintTrack(Graphics graphics) {
        int height;
        int width;
        int y;
        int x;
        Color oldColor = graphics.getColor();
        if (this.slider.getOrientation() == 0) {
            x = this.trackRect.x;
            y = this.trackRect.y + (this.trackRect.height >> 1) - 2;
            width = this.trackRect.width;
            height = 5;
        } else {
            x = this.trackRect.x + (this.trackRect.width >> 1) - 2;
            y = this.trackRect.y;
            width = 5;
            height = this.trackRect.height;
        }
        graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getProgressBarBackgroundColor());
        graphics.fillRect(x, y, width, height);
        graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        graphics.drawRect(x, y, width - 1, height - 1);
        if (this.slider.getClientProperty("JSlider.isFilled") != null && ((Boolean)this.slider.getClientProperty("JSlider.isFilled")).booleanValue()) {
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getSelectedControlBackgroundColor());
            if (this.slider.getOrientation() == 0) {
                if (this.drawInverted()) {
                    graphics.fillRect(this.thumbRect.x, y + 1, width - 2 - (this.thumbRect.x - x), height - 2);
                } else {
                    graphics.fillRect(x + 1, y + 1, this.thumbRect.x - x, height - 2);
                }
            } else if (this.drawInverted()) {
                graphics.fillRect(x + 1, this.thumbRect.y, width - 2 - (this.thumbRect.y - y), height - 2);
            } else {
                graphics.fillRect(x + 1, y + 1, width - 2, this.thumbRect.y - y);
            }
        }
        graphics.setColor(oldColor);
    }

    public void paintThumb(Graphics graphics) {
        Color oldColor = graphics.getColor();
        graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalControlBackgroundColor());
        graphics.fillRect(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height);
        if (this.slider.isEnabled()) {
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getNormalBorderColor());
        } else {
            graphics.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getDisabledBorderColor());
        }
        graphics.drawRect(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width - 1, this.thumbRect.height - 1);
        if (this.slider.getPaintTicks()) {
            int yBot = this.thumbRect.y + this.thumbRect.height - 1;
            int xRight = this.thumbRect.x + this.thumbRect.width - 1;
            if (this.slider.getOrientation() == 0) {
                graphics.drawLine(this.thumbRect.x + 2, yBot - 5, this.thumbRect.x + 5, yBot - 2);
                graphics.drawLine(this.thumbRect.x + 3, yBot - 5, this.thumbRect.x + 5, yBot - 3);
                graphics.drawLine(this.thumbRect.x + 3, yBot - 6, this.thumbRect.x + 5, yBot - 4);
                graphics.drawLine(xRight - 2, yBot - 5, this.thumbRect.x + 5, yBot - 2);
                graphics.drawLine(xRight - 3, yBot - 5, this.thumbRect.x + 5, yBot - 3);
                graphics.drawLine(xRight - 3, yBot - 6, this.thumbRect.x + 5, yBot - 4);
            } else {
                graphics.drawLine(xRight - 5, this.thumbRect.y + 2, xRight - 2, this.thumbRect.y + 5);
                graphics.drawLine(xRight - 5, this.thumbRect.y + 3, xRight - 3, this.thumbRect.y + 5);
                graphics.drawLine(xRight - 6, this.thumbRect.y + 3, xRight - 4, this.thumbRect.y + 5);
                graphics.drawLine(xRight - 5, yBot - 2, xRight - 2, this.thumbRect.y + 5);
                graphics.drawLine(xRight - 5, yBot - 3, xRight - 3, this.thumbRect.y + 5);
                graphics.drawLine(xRight - 6, yBot - 3, xRight - 4, this.thumbRect.y + 5);
            }
        }
        graphics.setColor(oldColor);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle tickBounds, int x) {
        graphics.drawLine(x, 1, x, (tickBounds.height >> 1) - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle tickBounds, int x) {
        graphics.drawLine(x, 1, x, tickBounds.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle tickBounds, int y) {
        graphics.drawLine(1, y, (tickBounds.width >> 1) - 1, y);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle tickBounds, int y) {
        graphics.drawLine(1, y, tickBounds.width - 2, y);
    }
}

