/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsBorders;
import com.pagosoft.plaf.PgsLookAndFeel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class PgsTableHeaderUI
extends BasicTableHeaderUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new PgsTableHeaderUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.header.setBorder(null);
        TableCellRenderer tableCellRenderer = this.header.getDefaultRenderer();
        if (tableCellRenderer instanceof UIResource) {
            this.header.setDefaultRenderer(new PgsDefaultTableHeaderCellRenderer(tableCellRenderer));
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        int n;
        if (this.header.getColumnModel().getColumnCount() <= 0) {
            return;
        }
        boolean bl = this.header.getComponentOrientation().isLeftToRight();
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        int n2 = this.header.columnAtPoint(bl ? point : point2);
        int n3 = this.header.columnAtPoint(bl ? point2 : point);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = tableColumnModel.getColumnCount() - 1;
        }
        TableColumn tableColumn = this.header.getDraggedColumn();
        Rectangle rectangle2 = this.header.getHeaderRect(bl ? n2 : n3);
        if (bl) {
            for (n = n2; n <= n3; ++n) {
                int n4;
                TableColumn tableColumn2 = tableColumnModel.getColumn(n);
                rectangle2.width = n4 = tableColumn2.getWidth();
                if (tableColumn2 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n);
                }
                rectangle2.x += n4;
            }
        } else {
            for (n = n3; n >= n2; --n) {
                int n5;
                TableColumn tableColumn3 = tableColumnModel.getColumn(n);
                rectangle2.width = n5 = tableColumn3.getWidth();
                if (tableColumn3 != tableColumn) {
                    this.paintCell(graphics, rectangle2, n);
                }
                rectangle2.x += n5;
            }
        }
        if (tableColumn != null) {
            n = this.viewIndexForColumn(tableColumn);
            Rectangle rectangle3 = this.header.getHeaderRect(n);
            graphics.setColor(this.header.getParent().getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            rectangle3.x += this.header.getDraggedDistance();
            graphics.setColor(this.header.getBackground());
            graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            this.paintCell(graphics, rectangle3, n);
        }
        this.rendererPane.removeAll();
    }

    private Component getHeaderRenderer(int n) {
        TableColumn tableColumn = this.header.getColumnModel().getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.header.getDefaultRenderer();
        }
        return tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), tableColumn.getHeaderValue(), false, false, -1, n);
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            if (tableColumnModel.getColumn(i) != tableColumn) continue;
            return i;
        }
        return -1;
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n) {
        Component component = this.getHeaderRenderer(n);
        this.rendererPane.paintComponent(graphics, component, this.header, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
    }

    private static class PgsDefaultTableHeaderCellRenderer
    implements TableCellRenderer,
    UIResource {
        private TableCellRenderer delegate;

        private PgsDefaultTableHeaderCellRenderer(TableCellRenderer tableCellRenderer) {
            this.delegate = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.delegate.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                if (n2 == jTable.getColumnCount()) {
                    jComponent.setBorder(new PgsBorders.Generic(new Insets(0, 0, 1, 0), PgsLookAndFeel.getControlDarkShadow()));
                } else {
                    jComponent.setBorder(new PgsBorders.Generic(new Insets(0, 0, 1, 1), PgsLookAndFeel.getControlDarkShadow()));
                }
                jComponent.setBackground(PgsLookAndFeel.getControl());
            }
            return component;
        }
    }
}

