/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsIconFactory;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.PlafOptions;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class PgsMenuItemUI
extends BasicMenuItemUI {
    private PropertyChangeListener menuItemIconChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new PgsMenuItemUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        if (this.menuItem.getIcon() == null && PlafOptions.isEmptyMenuIconUsed()) {
            this.menuItem.setIcon(PgsIconFactory.getEmptyIcon());
        }
    }

    protected void installListeners() {
        super.installListeners();
        if (this.menuItemIconChangeListener == null) {
            this.menuItemIconChangeListener = new IconChangeListener(this.menuItem);
        }
        this.menuItem.addPropertyChangeListener("icon", this.menuItemIconChangeListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.menuItem.removePropertyChangeListener("icon", this.menuItemIconChangeListener);
    }

    protected void paintBackground(Graphics graphics, JMenuItem jMenuItem, Color color) {
        PgsUtils.paintMenuItemBackground(graphics, jMenuItem, color, this.getPropertyPrefix());
    }

    protected void paintText(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle, String string) {
        PgsUtils.installAntialiasing(graphics);
        super.paintText(graphics, jMenuItem, rectangle, string);
        PgsUtils.uninstallAntialiasing(graphics);
    }

    public static class IconChangeListener
    implements PropertyChangeListener {
        private AbstractButton button;

        public IconChangeListener(AbstractButton abstractButton) {
            this.button = abstractButton;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.button.getClientProperty("allow.no.icon") == null && this.button.getIcon() == null) {
                this.button.setIcon(PgsIconFactory.getEmptyIcon());
            }
        }
    }
}

