/*
 * Decompiled with CFR 0.152.
 */
package org.fife.plaf.OfficeXP;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class OfficeXPUtilities {
    public static final int LEFT_EDGE_WIDTH = 24;
    public static final AlphaComposite ICON_COMPOSITE = AlphaComposite.getInstance(3, 0.55f);

    public static Border createWindowsXPBorder(String string) {
        return OfficeXPUtilities.createWindowsXPBorder(string, new Color(140, 140, 140));
    }

    public static Border createWindowsXPBorder(String string, Color color) {
        if (string.charAt(string.length() - 1) != ':') {
            string = string + ":";
        }
        return BorderFactory.createTitledBorder(new RoundedLineBorder(color, 1), string, 0, 0, null, Color.BLUE.brighter());
    }

    public static void paintDisabledButtonIcon(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle) {
        Icon icon = abstractButton.getDisabledIcon();
        if (icon != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setComposite(ICON_COMPOSITE);
            icon.paintIcon(abstractButton, graphics2D, rectangle.x, rectangle.y);
            graphics2D = null;
        }
    }

    public static void paintMenuItemBackground(Graphics graphics, Component component) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = (Paint)UIManager.get("OfficeLnF.MenuItemIconAreaPaint");
        graphics2D.setPaint(paint);
        int n = component.getWidth();
        int n2 = n - 24;
        int n3 = component.getHeight();
        if (component.getComponentOrientation().isLeftToRight()) {
            graphics.fillRect(0, 0, 24, n3);
            graphics.setColor(component.getBackground());
            graphics.fillRect(24, 0, n2, n3);
        } else {
            graphics2D.translate(n, n3);
            graphics2D.rotate(Math.PI);
            graphics2D.fillRect(0, 0, 24, n3);
            graphics2D.rotate(Math.PI);
            graphics2D.translate(-n, -n3);
            graphics2D.setColor(component.getBackground());
            graphics2D.fillRect(0, 0, n2, n3);
        }
    }

    public static void paintMenuItemIcon(Graphics graphics, JMenuItem jMenuItem, Rectangle rectangle) {
        ButtonModel buttonModel = jMenuItem.getModel();
        if (!buttonModel.isEnabled()) {
            OfficeXPUtilities.paintDisabledButtonIcon(graphics, jMenuItem, rectangle);
        } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
            Icon icon = jMenuItem.getPressedIcon();
            if (icon == null) {
                icon = jMenuItem.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(jMenuItem, graphics, rectangle.x, rectangle.y);
            }
        } else {
            Icon icon = jMenuItem.getIcon();
            if (icon != null) {
                if (buttonModel.isArmed() || jMenuItem instanceof JMenu && buttonModel.isSelected()) {
                    Icon icon2 = jMenuItem.getDisabledIcon();
                    if (icon2 != null) {
                        icon2.paintIcon(jMenuItem, graphics, rectangle.x, rectangle.y);
                    }
                    icon.paintIcon(jMenuItem, graphics, rectangle.x - 2, rectangle.y - 2);
                } else {
                    icon.paintIcon(jMenuItem, graphics, rectangle.x, rectangle.y);
                }
            }
        }
    }

    static class RoundedLineBorder
    implements Border {
        private Color borderColor;
        private int thickness;

        public RoundedLineBorder(int n) {
            this(new Color(140, 140, 140), n);
        }

        public RoundedLineBorder(Color color, int n) {
            this.borderColor = color;
            this.thickness = n;
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(this.thickness, this.thickness, this.thickness, this.thickness);
        }

        public boolean isBorderOpaque() {
            return false;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.borderColor);
            for (int i = 0; i < this.thickness; ++i) {
                graphics.drawRoundRect(n + i, n2 + i, n3 - i - i - 1, n4 - i - i - 1, this.thickness + 7, this.thickness + 7);
            }
            graphics.setColor(color);
        }
    }
}

