/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.util;

import com.lipstikLF.util.Gradient;
import com.lipstikLF.util.GradientInfo;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.WeakHashMap;

public class FastGradientPaintContext
implements PaintContext {
    private static WeakHashMap gradientCache = new WeakHashMap();
    private static LinkedList recentInfos = new LinkedList();
    private GradientInfo info = new GradientInfo();
    private int parallelDevicePos;
    private Gradient gradient;

    public FastGradientPaintContext(ColorModel cm, Rectangle r, int sc, int ec, boolean ver) {
        Object o;
        this.info.model = cm;
        this.info.startColor = sc;
        this.info.endColor = ec;
        this.info.isVertical = ver;
        if (this.info.isVertical) {
            this.parallelDevicePos = r.y;
            this.info.parallelLength = r.height;
        } else {
            this.parallelDevicePos = r.x;
            this.info.parallelLength = r.width;
        }
        recentInfos.remove(this.info);
        recentInfos.add(0, this.info);
        if (recentInfos.size() > 16) {
            recentInfos.removeLast();
        }
        if ((o = gradientCache.get(this.info)) != null) {
            o = ((WeakReference)o).get();
        }
        if (o != null) {
            this.gradient = (Gradient)o;
        } else {
            this.gradient = new Gradient(this.info);
            gradientCache.put(this.info, new WeakReference<Gradient>(this.gradient));
        }
    }

    public void dispose() {
        this.gradient.dispose();
    }

    public ColorModel getColorModel() {
        return this.info.model;
    }

    public synchronized Raster getRaster(int x, int y, int w, int h) {
        if (this.info.isVertical) {
            return this.gradient.getRaster(y - this.parallelDevicePos, w);
        }
        return this.gradient.getRaster(x - this.parallelDevicePos, h);
    }
}

