/*
 * Decompiled with CFR 0.152.
 */
package com.lipstikLF.delegate;

import com.lipstikLF.LipstikLookAndFeel;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class LipstikProgressBarUI
extends BasicProgressBarUI {
    private static final int offset = 2;
    private Rectangle boxRect;

    public static ComponentUI createUI(JComponent c) {
        return new LipstikProgressBarUI();
    }

    protected void paintDeterminate(Graphics g, JComponent c) {
        int h;
        int w;
        boolean isHoriz = ((JProgressBar)c).getOrientation() == 0;
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - 4;
        int barRectHeight = this.progressBar.getHeight() - 4;
        int y = 0;
        Graphics2D g2 = (Graphics2D)g;
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        g2.translate(2, 2);
        if (c.isEnabled()) {
            g2.setColor(this.progressBar.getForeground());
        } else {
            g2.setColor(LipstikLookAndFeel.getMyCurrentTheme().getBorderDisabled());
        }
        if (isHoriz) {
            w = amountFull;
            h = barRectHeight;
        } else {
            w = barRectWidth;
            h = amountFull;
            y = barRectHeight - amountFull;
        }
        g2.fillRect(0, y, w, h);
        if (this.progressBar.isStringPainted()) {
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
        g2.translate(2, 2);
    }

    protected void paintIndeterminate(Graphics g, JComponent c) {
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - 4;
        int barRectHeight = this.progressBar.getHeight() - 4;
        this.boxRect = this.getBox(this.boxRect);
        if (this.boxRect != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(this.progressBar.getForeground());
            g2.fillRect(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height);
        }
        if (this.progressBar.isStringPainted()) {
            int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
            this.paintString(g, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }
}

