/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plugin;

import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plugin.A03Plugin;
import a03.swing.widget.A03ScrollPaneViewNavigator;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIDefaults;
import thirdparty.org.jvnet.lafwidget.scroll.TweakedScrollPaneLayout;

public class A03ScrollPaneViewNavigatorPlugin
implements A03Plugin {
    public static final String ORIGINAL_LOWER_LEFT_CORNER = "A03_ORIGINAL_LOWER_LEFT_CORNER";
    public static final String ORIGINAL_LOWER_RIGHT_CORNER = "A03_ORIGINAL_LOWER_RIGHT_CORNER";

    public void registerComponent(Component c) {
        if (c instanceof JScrollPane) {
            final JScrollPane scrollpane = (JScrollPane)c;
            scrollpane.putClientProperty("A03_ORIGINAL_LAYOUT", scrollpane.getLayout());
            scrollpane.setLayout(new TweakedScrollPaneLayout());
            scrollpane.putClientProperty(ORIGINAL_LOWER_LEFT_CORNER, scrollpane.getCorner("LOWER_LEFT_CORNER"));
            scrollpane.putClientProperty(ORIGINAL_LOWER_RIGHT_CORNER, scrollpane.getCorner("LOWER_RIGHT_CORNER"));
            this.installNavigator(scrollpane);
            scrollpane.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("componentOrientation")) {
                        A03ScrollPaneViewNavigatorPlugin.this.installNavigator(scrollpane);
                    }
                }
            });
        }
    }

    private void installNavigator(JScrollPane scrollpane) {
        A03ScrollPaneViewNavigator viewportPreview = new A03ScrollPaneViewNavigator(scrollpane);
        if (A03SwingUtilities.isLeftToRight(scrollpane)) {
            scrollpane.setCorner("LOWER_RIGHT_CORNER", viewportPreview);
        } else {
            scrollpane.setCorner("LOWER_LEFT_CORNER", viewportPreview);
        }
    }

    public void unregisterComponent(Component c) {
        if (c instanceof JScrollPane) {
            JScrollPane scrollpane = (JScrollPane)c;
            scrollpane.setLayout((LayoutManager)scrollpane.getClientProperty("A03_ORIGINAL_LAYOUT"));
            scrollpane.putClientProperty("A03_ORIGINAL_LAYOUT", null);
            scrollpane.setCorner("LOWER_LEFT_CORNER", (JComponent)scrollpane.getClientProperty(ORIGINAL_LOWER_LEFT_CORNER));
            scrollpane.setCorner("LOWER_RIGHT_CORNER", (JComponent)scrollpane.getClientProperty(ORIGINAL_LOWER_RIGHT_CORNER));
        }
    }

    public void installDefaults(UIDefaults table) {
    }
}

