/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plugin;

import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plugin.A03Plugin;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIDefaults;
import javax.swing.event.MouseInputAdapter;

public class A03FadeTrackerPlugin
implements A03Plugin {
    private static final String FADE_EFFECT_HANDLER = "FADE_EFFECT_HANDLER";
    private static final double FADE_EFFECT_TIME_STEP = 0.25;

    public void registerComponent(Component c) {
        if (c instanceof JMenuItem) {
            this.registerMenuItem((JMenuItem)c);
        } else if (c instanceof JSlider) {
            this.registerSlider((JSlider)c);
        } else if (c instanceof JTable) {
            this.registerTable((JTable)c);
        } else if (c instanceof JList) {
            this.registerList((JList)c);
        } else if (c instanceof JTree) {
            this.registerTree((JTree)c);
        } else if (c instanceof JComponent) {
            this.registerComponent((JComponent)c);
        }
    }

    public void unregisterComponent(Component c) {
        if (c instanceof JMenuItem) {
            this.unregisterMenuItem((JMenuItem)c);
        } else if (c instanceof JSlider) {
            this.unregisterSlider((JSlider)c);
        } else if (c instanceof JTable) {
            this.unregisterTable((JTable)c);
        } else if (c instanceof JList) {
            this.unregisterList((JList)c);
        } else if (c instanceof JTree) {
            this.unregisterTree((JTree)c);
        } else if (c instanceof JComponent) {
            this.unregisterComponent((JComponent)c);
        }
    }

    public void registerMenuItem(JMenuItem menuItem) {
        MenuItemHandler handler = new MenuItemHandler(menuItem);
        menuItem.putClientProperty(FADE_EFFECT_HANDLER, handler);
        menuItem.addMouseListener(handler);
        menuItem.addActionListener(handler);
    }

    public void unregisterMenuItem(JMenuItem menuItem) {
        MenuItemHandler handler = (MenuItemHandler)menuItem.getClientProperty(FADE_EFFECT_HANDLER);
        menuItem.removeMouseListener(handler);
        menuItem.removeActionListener(handler);
    }

    private double getMenuItemFadeLevel(JMenuItem menuItem) {
        MenuItemHandler handler = (MenuItemHandler)menuItem.getClientProperty(FADE_EFFECT_HANDLER);
        double level = handler != null ? handler.getFadeLevel() : 0.0;
        return level;
    }

    public void registerComponent(JComponent c) {
        ComponentHandler handler = new ComponentHandler(c);
        c.addMouseListener(handler);
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            b.addActionListener(handler);
        }
        c.putClientProperty(FADE_EFFECT_HANDLER, handler);
    }

    public void unregisterComponent(JComponent c) {
        ComponentHandler handler = (ComponentHandler)c.getClientProperty(FADE_EFFECT_HANDLER);
        c.removeMouseListener(handler);
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            b.removeActionListener(handler);
        }
    }

    private double getComponentFadeLevel(Component c) {
        if (!c.isEnabled()) {
            return 0.0;
        }
        ComponentHandler handler = (ComponentHandler)((JComponent)c).getClientProperty(FADE_EFFECT_HANDLER);
        double level = handler != null ? handler.getFadeLevel() : 0.0;
        return level;
    }

    public void registerSlider(JSlider slider) {
        SliderHandler handler = new SliderHandler(slider);
        slider.addMouseMotionListener(handler);
        slider.addMouseListener(handler);
        slider.putClientProperty(FADE_EFFECT_HANDLER, handler);
    }

    public void unregisterSlider(JSlider slider) {
        SliderHandler handler = (SliderHandler)slider.getClientProperty(FADE_EFFECT_HANDLER);
        slider.removeMouseListener(handler);
    }

    private double getSliderFadeLevel(JSlider slider) {
        if (!slider.isEnabled()) {
            return 0.0;
        }
        SliderHandler handler = (SliderHandler)slider.getClientProperty(FADE_EFFECT_HANDLER);
        return handler != null ? handler.getFadeLevel() : 0.0;
    }

    public void registerTable(JTable table) {
        TableHandler handler = new TableHandler(table);
        table.putClientProperty(FADE_EFFECT_HANDLER, handler);
        table.addMouseMotionListener(handler);
        table.addMouseListener(handler);
    }

    public void unregisterTable(JTable table) {
        TableHandler handler = (TableHandler)table.getClientProperty(FADE_EFFECT_HANDLER);
        table.removeMouseListener(handler);
        table.removeMouseMotionListener(handler);
    }

    public void registerList(JList list) {
        ListHandler handler = new ListHandler(list);
        list.putClientProperty(FADE_EFFECT_HANDLER, handler);
        list.addMouseMotionListener(handler);
        list.addMouseListener(handler);
    }

    public void unregisterList(JList list) {
        ListHandler handler = (ListHandler)list.getClientProperty(FADE_EFFECT_HANDLER);
        list.removeMouseListener(handler);
        list.removeMouseMotionListener(handler);
    }

    public void registerTree(JTree tree) {
        TreeHandler handler = new TreeHandler(tree);
        tree.putClientProperty(FADE_EFFECT_HANDLER, handler);
        tree.addMouseMotionListener(handler);
        tree.addMouseListener(handler);
    }

    public void unregisterTree(JTree tree) {
        TreeHandler handler = (TreeHandler)tree.getClientProperty(FADE_EFFECT_HANDLER);
        tree.removeMouseListener(handler);
        tree.removeMouseMotionListener(handler);
    }

    protected static double calculateFadeLevel(double time) {
        return time;
    }

    public void installDefaults(UIDefaults table) {
    }

    public double getFadeLevel(Component c) {
        if (c instanceof JMenuItem) {
            return this.getMenuItemFadeLevel((JMenuItem)c);
        }
        if (c instanceof JSlider) {
            return this.getSliderFadeLevel((JSlider)c);
        }
        return this.getComponentFadeLevel(c);
    }

    public double getFadeLevel(Component c, int row) {
        if (!c.isEnabled()) {
            return 0.0;
        }
        RowHandler handler = (RowHandler)((JComponent)c).getClientProperty(FADE_EFFECT_HANDLER);
        return handler != null ? handler.getFadeLevel(row) : 0.0;
    }

    public double getFadeLevel(Component c, int row, int column) {
        if (!c.isEnabled()) {
            return 0.0;
        }
        TableHandler handler = (TableHandler)((JComponent)c).getClientProperty(FADE_EFFECT_HANDLER);
        return handler != null ? handler.getFadeLevel(row, column) : 0.0;
    }

    private class ComponentHandler
    implements ActionListener,
    MouseListener,
    MouseMotionListener,
    Handler {
        private Timer timer = null;
        private double time = 0.0;
        private double timeStep;
        private double level = 0.0;
        private Component component;

        ComponentHandler(Component c) {
            this.component = c;
        }

        public void mouseEntered(MouseEvent e) {
            if (this.component.isEnabled()) {
                this.startTimer(0.25);
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.component.isEnabled()) {
                this.startTimer(-0.25);
            }
        }

        public void actionPerformed(ActionEvent e) {
            this.startTimer(-0.25);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startTimer(double timeStep) {
            this.timeStep = timeStep;
            if (this.timer == null) {
                this.timer = new Timer(30, new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionPerformed(ActionEvent e) {
                        ComponentHandler.this.level = A03FadeTrackerPlugin.calculateFadeLevel(ComponentHandler.this.time);
                        ComponentHandler componentHandler = ComponentHandler.this;
                        componentHandler.time = componentHandler.time + ComponentHandler.this.timeStep;
                        if (ComponentHandler.this.timeStep > 0.0 && ComponentHandler.this.level >= 1.0 || ComponentHandler.this.timeStep < 0.0 && ComponentHandler.this.level <= 0.0) {
                            Component component = ComponentHandler.this.component;
                            synchronized (component) {
                                ComponentHandler.this.stopTimer();
                            }
                            ComponentHandler.this.level = ComponentHandler.this.timeStep > 0.0 ? 1.0 : 0.0;
                        } else if (ComponentHandler.this.timeStep > 0.0 && ComponentHandler.this.level <= 0.0) {
                            ComponentHandler.this.level = 0.0;
                        } else if (ComponentHandler.this.timeStep < 0.0 && ComponentHandler.this.level >= 1.0) {
                            ComponentHandler.this.level = 1.0;
                        }
                        ComponentHandler.this.component.repaint();
                    }
                });
            }
            Component component = this.component;
            synchronized (component) {
                this.timer.start();
            }
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
                this.timer = null;
            }
        }

        public double getFadeLevel() {
            return this.level;
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }
    }

    private static interface Handler {
    }

    class ListHandler
    extends RowHandler {
        public ListHandler(JList list) {
            super(list);
        }

        protected int getRow(MouseEvent e) {
            int row = A03SwingUtilities.loc2IndexFileList((JList)this.component, e.getPoint());
            return row;
        }
    }

    private class MenuItemHandler
    extends MouseAdapter
    implements ActionListener,
    Handler {
        private double level = 0.0;
        private JMenuItem component;

        MenuItemHandler(JMenuItem c) {
            this.component = c;
        }

        public void mouseEntered(MouseEvent e) {
            if (this.component.isEnabled()) {
                this.level = 1.0;
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.component.isEnabled()) {
                this.level = 0.0;
            }
        }

        public void actionPerformed(ActionEvent e) {
            if (this.component.isEnabled()) {
                this.level = 0.0;
            }
        }

        public double getFadeLevel() {
            return this.level;
        }
    }

    abstract class RowHandler
    extends MouseInputAdapter
    implements Handler {
        protected JComponent component;
        protected int lastRow = -1;

        public RowHandler(JComponent component) {
            this.component = component;
        }

        public void mouseEntered(MouseEvent e) {
            if (this.component.isEnabled()) {
                int row;
                this.lastRow = row = this.getRow(e);
                this.component.repaint();
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.component.isEnabled()) {
                this.lastRow = -1;
                this.component.repaint();
            }
        }

        public void mouseMoved(MouseEvent e) {
            int row;
            if (this.component.isEnabled() && (row = this.getRow(e)) != this.lastRow) {
                this.lastRow = row;
                this.component.repaint();
            }
        }

        protected abstract int getRow(MouseEvent var1);

        public double getFadeLevel(int row) {
            return this.lastRow == row ? 1 : 0;
        }
    }

    private class SliderHandler
    extends ComponentHandler {
        SliderHandler(JSlider slider) {
            super(slider);
        }

        public void mouseDragged(MouseEvent e) {
            ((JSlider)e.getSource()).repaint();
        }
    }

    class TableHandler
    extends MouseInputAdapter
    implements Handler {
        protected JTable table;
        protected int lastRow = -1;
        protected int lastColumn = -1;

        public TableHandler(JTable table) {
            this.table = table;
        }

        public void mouseClicked(MouseEvent e) {
            this.table.repaint();
        }

        public void mouseEntered(MouseEvent e) {
            if (this.table.isEnabled()) {
                boolean needsRepaint = false;
                if (this.table.getRowSelectionAllowed()) {
                    int row;
                    this.lastRow = row = this.getRow(e);
                    needsRepaint = true;
                }
                if (this.table.getColumnSelectionAllowed()) {
                    int column;
                    this.lastColumn = column = this.getColumn(e);
                    needsRepaint = true;
                }
                if (needsRepaint) {
                    this.table.repaint();
                }
            }
        }

        public void mouseExited(MouseEvent e) {
            if (this.table.isEnabled()) {
                this.lastRow = -1;
                this.lastColumn = -1;
                if (this.table.getRowSelectionAllowed() || this.table.getColumnSelectionAllowed()) {
                    this.table.repaint();
                }
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (this.table.isEnabled()) {
                int column;
                int row;
                boolean needsRepaint = false;
                if (this.table.getRowSelectionAllowed() && (row = this.getRow(e)) != this.lastRow) {
                    this.lastRow = row;
                    needsRepaint = true;
                }
                if (this.table.getColumnSelectionAllowed() && (column = this.getColumn(e)) != this.lastColumn) {
                    this.lastColumn = column;
                    needsRepaint = true;
                }
                if (needsRepaint) {
                    this.table.repaint();
                }
            }
        }

        public double getFadeLevel(int row, int column) {
            if (this.lastRow == -1 && this.lastColumn == -1) {
                return 0.0;
            }
            boolean rowSelectionAllowed = this.table.getRowSelectionAllowed();
            boolean columnSectionAllowed = this.table.getColumnSelectionAllowed();
            if (rowSelectionAllowed && columnSectionAllowed) {
                return row == this.lastRow && column == this.lastColumn ? 1 : 0;
            }
            return rowSelectionAllowed && this.lastRow == row || columnSectionAllowed && column == this.lastColumn ? 1 : 0;
        }

        protected int getRow(MouseEvent e) {
            int row = this.table.rowAtPoint(e.getPoint());
            return row;
        }

        protected int getColumn(MouseEvent e) {
            int column = this.table.columnAtPoint(e.getPoint());
            return column;
        }
    }

    class TreeHandler
    extends RowHandler {
        public TreeHandler(JTree tree) {
            super(tree);
        }

        protected int getRow(MouseEvent e) {
            int row = ((JTree)this.component).getRowForLocation(e.getX(), e.getY());
            return row;
        }
    }
}

