/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03TitledBorderDelegate;
import a03.swing.plaf.style.A03TitledBorderStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class A03StyledTitledBorderDelegate
implements A03TitledBorderDelegate {
    private A03TitledBorderStyle style;

    public A03StyledTitledBorderDelegate(A03TitledBorderStyle style) {
        this.style = style;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 2;
        insets.left = 2;
        insets.bottom = 2;
        insets.right = 2;
        return insets;
    }

    public FontUIResource getFont() {
        return new FontUIResource(this.style.getFont());
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(this.style.getTitledBorderPaint(x, y, width - 1, height - 1));
        Shape shape = A03GraphicsUtilities.createRoundRectangle(x, y, width - 1, height - 1, 1.0f);
        graphics.draw(shape);
        graphics.setBackground(Color.GREEN);
    }

    public ColorUIResource getTitleColor() {
        return new ColorUIResource(this.style.getTitleColor());
    }
}

