/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03TextComponentDelegate;
import a03.swing.plaf.style.A03StyledGraphicsUtilities;
import a03.swing.plaf.style.A03StyledSwingUtilities;
import a03.swing.plaf.style.A03TextComponentStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.text.JTextComponent;

public class A03StyledTextComponentDelegate
implements A03TextComponentDelegate {
    private static InsetsUIResource textComponentMargin = new InsetsUIResource(1, 3, 1, 3);
    private static Map<Integer, Image> cachedEchoCharacterImages = new HashMap<Integer, Image>();
    private A03TextComponentStyle style;

    public A03StyledTextComponentDelegate(A03TextComponentStyle style) {
        this.style = style;
    }

    public InsetsUIResource getTextFieldMargin() {
        return textComponentMargin;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 2;
        insets.bottom = 2;
        insets.left = 0;
        insets.right = 0;
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (SwingUtilities.getAncestorOfClass(JComboBox.class, c) == null) {
            Color background;
            if (c.isOpaque()) {
                background = c.getBackground();
            } else {
                Container parent = c.getParent();
                while (parent != null && !parent.isOpaque()) {
                    parent = parent.getParent();
                }
                background = parent != null && parent.isOpaque() ? parent.getBackground() : UIManager.getColor("control");
            }
            if (c instanceof JTextField) {
                A03StyledSwingUtilities.paintShadowedBorder(c, g, x, y, width, height, background);
            }
            if (c.hasFocus() && ((JTextComponent)c).isEditable()) {
                Graphics2D graphics = (Graphics2D)g.create();
                A03StyledGraphicsUtilities.paintBorderShadow(graphics, 3, A03GraphicsUtilities.createRoundRectangle(x, y, width - 1, height - 1, 3.0f), this.style.getFocusColor(), background);
                graphics.dispose();
                return;
            }
        }
    }

    public void paintEchoCharacter(Component c, Graphics g, int x, int y, int charWidth) {
        Image image = cachedEchoCharacterImages.get(charWidth);
        if (image == null) {
            image = A03GraphicsUtilities.createImage(null, charWidth - 2, charWidth - 2);
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(this.style.getForegroundColor(A03StyledSwingUtilities.getState(c)));
            graphics.fillOval(0, 0, charWidth - 2, charWidth - 2);
            graphics.dispose();
            cachedEchoCharacterImages.put(charWidth, image);
        }
        g.drawImage(image, x, y, null);
    }

    public FontUIResource getTextFieldFont() {
        return new FontUIResource(this.style.getTextFieldFont());
    }

    public FontUIResource getTextAreaFont() {
        return new FontUIResource(this.style.getTextAreaFont());
    }

    public FontUIResource getTextPaneFont() {
        return new FontUIResource(this.style.getTextPaneFont());
    }

    public ColorUIResource getBackground() {
        return new ColorUIResource(this.style.getBackgroundColor());
    }

    public ColorUIResource getSelectionBackground() {
        return new ColorUIResource(this.style.getSelectionBackgroundColor());
    }

    public ColorUIResource getDisabledBackground() {
        return new ColorUIResource(this.style.getDisabledBackgroundColor());
    }

    public ColorUIResource getInactiveBackground() {
        return new ColorUIResource(this.style.getInactiveBackgroundColor());
    }

    public ColorUIResource getForeground() {
        return new ColorUIResource(this.style.getForegroundColor());
    }

    public ColorUIResource getInactiveForeground() {
        return new ColorUIResource(this.style.getInactiveForegroundColor());
    }

    public ColorUIResource getSelectionForeground() {
        return new ColorUIResource(this.style.getSelectionForegroundColor());
    }
}

