/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.style.A03ButtonStyle;
import a03.swing.plugin.A03FadeTrackerPlugin;
import a03.swing.plugin.A03PluginManager;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.plaf.UIResource;

public class A03StyledSwingUtilities {
    private static final Color GHOST_COLOR = new Color(0, 0, 0, 0);

    public static void paintButtonBackground(A03ButtonStyle style, Component c, Graphics g) {
        if (c.getParent() instanceof JToolBar) {
            return;
        }
        AbstractButton b = (AbstractButton)c;
        Insets insets = b.getInsets();
        Insets margin = b.getMargin();
        int x = insets.left - margin.left;
        int y = insets.top - margin.top;
        int width = b.getWidth();
        int height = b.getHeight();
        Image tmpImage = A03GraphicsUtilities.getTempImage(c, width, height);
        Graphics2D graphics = (Graphics2D)tmpImage.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape shape = A03GraphicsUtilities.createRoundRectangle(x, y, width -= x + insets.right - margin.right, height -= y + insets.bottom - margin.bottom, style.getBorderCornerRadius(width, height));
        Color background = b.getBackground();
        if (background instanceof UIResource) {
            float fadeLevel;
            int state = A03StyledSwingUtilities.getState(c);
            if ((state & 1) != 0 && (fadeLevel = (float)A03PluginManager.getInstance().getPlugin(A03FadeTrackerPlugin.class).getFadeLevel(b)) > 0.0f) {
                if (fadeLevel < 1.0f) {
                    graphics.setPaint(style.getBackgroundPaint(1, 0, 0, width, height));
                    graphics.fill(shape);
                    graphics.setComposite(AlphaComposite.getInstance(3, fadeLevel));
                }
                state = 5;
            }
            graphics.setPaint(style.getBackgroundPaint(state, x, y, width, height));
        } else {
            graphics.setPaint(style.getBackgroundPaint(1, x, y, width, height));
            graphics.fill(shape);
            graphics.setPaint(background);
            graphics.setComposite(AlphaComposite.getInstance(3, 0.25f));
        }
        graphics.fill(shape);
        graphics.dispose();
        g.drawImage(tmpImage, 0, 0, c);
    }

    public static void paintButtonBorder(A03ButtonStyle style, Component c, Graphics g, int x, int y, int width, int height) {
        if (c.getParent() instanceof JToolBar || c.hasFocus()) {
            return;
        }
        AbstractButton b = (AbstractButton)c;
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape shape = A03GraphicsUtilities.createRoundRectangle(x, y, width - 1, height - 1, style.getBorderCornerRadius(width, height));
        Color background = b.getBackground();
        if (background instanceof UIResource) {
            float fadeLevel;
            int state = A03StyledSwingUtilities.getState(c);
            if (state == 1 && (fadeLevel = (float)A03PluginManager.getInstance().getPlugin(A03FadeTrackerPlugin.class).getFadeLevel(b)) > 0.0f) {
                if (fadeLevel < 1.0f) {
                    graphics.setPaint(style.getBorderPaint(1, x, y, width, height));
                    graphics.draw(shape);
                    graphics.setComposite(AlphaComposite.getInstance(3, fadeLevel));
                }
                state = 5;
            }
            graphics.setPaint(style.getBorderPaint(state, x, y, width, height));
        } else {
            graphics.setPaint(style.getBorderPaint(1, x, y, width, height));
            graphics.draw(shape);
            graphics.setColor(background);
            graphics.setComposite(AlphaComposite.getInstance(3, 0.25f));
        }
        graphics.draw(shape);
        graphics.dispose();
    }

    public static void paintButtonFocus(A03ButtonStyle style, Component c, Graphics g, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int width = c.getWidth();
        int height = c.getHeight();
        graphics.setStroke(new BasicStroke(2.0f));
        graphics.setColor(style.getFocusColor());
        graphics.draw(A03GraphicsUtilities.createRoundRectangle(1, 1, width - 3, height - 3, style.getBorderCornerRadius(width, height)));
        graphics.dispose();
    }

    public static void paintText(A03ButtonStyle style, Component c, Graphics g, String text, int x, int y) {
        Graphics2D graphics = (Graphics2D)g.create();
        AbstractButton b = (AbstractButton)c;
        graphics.setColor(style.getForegroundColor(A03StyledSwingUtilities.getState(c)));
        int mnemonicIndex = b.getDisplayedMnemonicIndex();
        A03GraphicsUtilities.drawStringUnderlineCharAt(c, graphics, text, mnemonicIndex, x, y);
        graphics.dispose();
    }

    public static int getState(Component c) {
        int state = 0;
        if (c instanceof AbstractButton) {
            ButtonModel model = ((AbstractButton)c).getModel();
            if (model.isEnabled()) {
                state = 1;
            }
            if (model.isSelected()) {
                state |= 2;
            }
            if (model.isArmed()) {
                state |= 4;
            }
            if (model.isPressed()) {
                state |= 8;
            }
            model.isRollover();
            if (c.isFocusable() && c.isFocusOwner()) {
                state |= 0x10;
            }
        } else if (c instanceof JSlider) {
            JSlider slider = (JSlider)c;
            if (slider.isEnabled()) {
                state = 1;
            }
            if (slider.getValue() > 0) {
                state |= 4;
            }
        } else if (c.isEnabled()) {
            state = 1;
        }
        return state;
    }

    public static void paintShadowedBorder(Component c, Graphics g, int x, int y, int width, int height, Color background) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Color top = A03GraphicsUtilities.createColor(background, 0.6);
        Color hidden = A03GraphicsUtilities.createColor(background, 0.8);
        Color side = A03GraphicsUtilities.createColor(background, 0.7);
        Color bottom = A03GraphicsUtilities.createColor(background, 0.85);
        GradientPaint paint = new GradientPaint(x, y, top, x, y + 3, side);
        graphics.setPaint(paint);
        graphics.drawRect(x, y, width - 1, height - 1);
        paint = new GradientPaint(x + 1, y + 1, hidden, x + 1, y + 2, background);
        graphics.setPaint(paint);
        graphics.drawLine(x + 1, y + 1, x + width - 2, y + 1);
        graphics.drawLine(x + 1, y + 2, x + width - 2, y + 2);
        graphics.setColor(bottom);
        graphics.drawLine(x + 1, y + height - 1, width - 2, y + height - 1);
    }
}

