/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03SplitPaneDelegate;
import a03.swing.plaf.style.A03SplitPaneStyle;
import a03.swing.plaf.style.A03StyledGraphicsUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JSplitPane;
import javax.swing.plaf.ColorUIResource;

public class A03StyledSplitPaneDelegate
implements A03SplitPaneDelegate {
    private A03SplitPaneStyle style;

    public A03StyledSplitPaneDelegate(A03SplitPaneStyle style) {
        this.style = style;
    }

    public ColorUIResource getBackground() {
        return new ColorUIResource(this.style.getBackgroundColor());
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 0;
        insets.left = 0;
        insets.bottom = 0;
        insets.right = 0;
        return insets;
    }

    public Insets getDividerBorderInsets(Component c, Insets insets) {
        insets.top = 0;
        insets.left = 0;
        insets.bottom = 0;
        insets.right = 0;
        return insets;
    }

    public void paintDividerBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public void paintDividerGrip(Component c, Graphics g) {
        JSplitPane splitPane = (JSplitPane)c;
        int size = splitPane.getDividerSize();
        if (size >= 8) {
            Shape shape;
            int y;
            int x;
            int length = 24;
            int width = splitPane.getWidth();
            int height = splitPane.getHeight();
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int orientation = splitPane.getOrientation();
            int gripSize = this.style.getGripSize();
            gripSize = (gripSize + 1) / 2 * 2 - 1;
            if (orientation == 0) {
                x = width / 2 - length / 2;
                y = (size - 6) / 2;
                shape = A03GraphicsUtilities.createRoundRectangle(x, y, length - 1, gripSize - 1, gripSize / 2);
            } else {
                x = (size - 6) / 2;
                y = height / 2 - length / 2;
                shape = A03GraphicsUtilities.createRoundRectangle(x, y, gripSize - 1, length - 1, gripSize / 2);
            }
            Paint background = this.style.getGripBackgroundPaint(1, orientation, x, y, length, length);
            graphics.setPaint(background);
            graphics.fill(shape);
            Color border = this.style.getGripBorderPaint(1, orientation, x, y, length, length);
            graphics.setPaint(border);
            graphics.draw(shape);
            graphics.dispose();
        }
    }

    public Integer getDividerSize() {
        return this.style.getDividerSize();
    }

    public void paintArrow(Component c, Graphics g, int direction) {
        int size;
        int width = c.getWidth();
        int height = c.getHeight();
        if (height < (size = 6) || width < size) {
            return;
        }
        int x = (width - size) / 2;
        int y = (height - size) / 2;
        A03StyledGraphicsUtilities.paintArrow(g, x, y, size, size, direction, this.style.getArrowPaint(1, direction, x, y, width, height));
    }
}

