/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03SpinnerDelegate;
import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plaf.style.A03SpinnerStyle;
import a03.swing.plaf.style.A03StyledGraphicsUtilities;
import a03.swing.plaf.style.A03StyledSwingUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public class A03StyledSpinnerDelegate
implements A03SpinnerDelegate {
    private A03SpinnerStyle style;

    public A03StyledSpinnerDelegate(A03SpinnerStyle style) {
        this.style = style;
    }

    public InsetsUIResource getArrowMargin() {
        return new InsetsUIResource(0, 0, 0, 0);
    }

    public void paintArrow(Component c, Graphics g, int direction) {
        int size;
        int min;
        int width = c.getWidth();
        int height = c.getHeight();
        if (height < (min = (size = 8) / 2 + 2) || width < min) {
            return;
        }
        int x = (width - size) / 2;
        int y = (height - size / 2) / 2;
        int state = A03StyledSwingUtilities.getState(c);
        A03StyledGraphicsUtilities.paintArrow(g, x, y, size, size / 2, direction, this.style.getArrowPaint(state, direction, x, y, width, height));
    }

    public void paintArrowBackground(Component c, Graphics g) {
    }

    public void paintArrowBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public Insets getArrowBorderInsets(Component c, Insets insets) {
        return null;
    }

    public void paintArrowButtonBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        boolean leftToRight = A03SwingUtilities.isLeftToRight(c);
        insets.top = 3;
        insets.left = leftToRight ? 3 : 1;
        insets.bottom = 3;
        insets.right = leftToRight ? 1 : 3;
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JSpinner spinner = (JSpinner)c;
        JComponent editor = spinner.getEditor();
        boolean focused = editor.hasFocus();
        if (!focused) {
            int i = 0;
            while (i < editor.getComponentCount()) {
                if (editor.getComponent(i).hasFocus()) {
                    focused = true;
                    break;
                }
                ++i;
            }
        }
        if (focused) {
            Graphics2D graphics = (Graphics2D)g.create();
            A03StyledGraphicsUtilities.paintBorderShadow(graphics, 3, A03GraphicsUtilities.createRoundRectangle(x, y, width - 1, height - 1, 3.0f), this.style.getFocusColor(), c.getBackground());
            graphics.dispose();
        } else {
            A03StyledSwingUtilities.paintShadowedBorder(c, g, x, y, width, height, c.getBackground());
        }
    }

    public FontUIResource getFont() {
        return new FontUIResource(this.style.getFont());
    }

    public ColorUIResource getForeground() {
        return new ColorUIResource(this.style.getForegroundColor());
    }

    public ColorUIResource getBackground() {
        return new ColorUIResource(this.style.getBackgroundColor());
    }

    public ColorUIResource getDisabledBackground() {
        return new ColorUIResource(this.style.getDisabledBackgroundColor());
    }
}

