/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03ScrollPaneDelegate;
import a03.swing.plaf.style.A03ScrollPaneStyle;
import a03.swing.plaf.style.A03StyledGraphicsUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.UIResource;

public class A03StyledScrollPaneDelegate
implements A03ScrollPaneDelegate {
    private A03ScrollPaneStyle style;

    public A03StyledScrollPaneDelegate(A03ScrollPaneStyle style) {
        this.style = style;
    }

    public void paintViewportBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (c instanceof JScrollPane) {
            Graphics2D graphics = (Graphics2D)g;
            graphics.setPaint(this.style.getBorderPaint(x, y, width - 1, height - 1));
            graphics.drawRect(x, y, width - 1, height - 1);
        }
    }

    public Insets getViewportBorderInsets(Component c, Insets insets) {
        if (c instanceof JScrollPane) {
            JScrollPane scrollpane = (JScrollPane)c;
            if (!(scrollpane.getViewport().getView() instanceof JTable)) {
                insets.top = 1;
            }
            insets.right = 1;
            insets.left = 1;
            insets.bottom = 1;
        }
        return insets;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 0;
        insets.left = 0;
        insets.bottom = 0;
        insets.right = 0;
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public IconUIResource getNavigatorIcon() {
        return new IconUIResource(new ScrollPaneViewNavigatorIcon());
    }

    public ColorUIResource getBackground() {
        return new ColorUIResource(this.style.getBackgroundColor());
    }

    private class ScrollPaneViewNavigatorIcon
    implements Icon,
    UIResource {
        private Image image = A03GraphicsUtilities.createImage(null, this.getIconWidth(), this.getIconHeight());

        public ScrollPaneViewNavigatorIcon() {
            Graphics2D graphics = (Graphics2D)this.image.getGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Paint foreground = A03StyledScrollPaneDelegate.this.style.getArrowBackgroundPaint(1, 0, 0, 0, 7);
            A03StyledGraphicsUtilities.paintArrow(graphics, 5, 2, 7, 7, 1, foreground);
            A03StyledGraphicsUtilities.paintArrow(graphics, 2, 5, 7, 7, 7, foreground);
            A03StyledGraphicsUtilities.paintArrow(graphics, 5, 11, 7, 7, 5, foreground);
            A03StyledGraphicsUtilities.paintArrow(graphics, 11, 5, 7, 7, 3, foreground);
            graphics.dispose();
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawImage(this.image, 0, 0, c);
        }
    }
}

