/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03ScrollBarDelegate;
import a03.swing.plaf.style.A03ScrollBarStyle;
import a03.swing.plaf.style.A03StyledGraphicsUtilities;
import a03.swing.plaf.style.A03StyledSwingUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;

public class A03StyledScrollBarDelegate
implements A03ScrollBarDelegate {
    private static final DimensionUIResource minimumThumbSize = new DimensionUIResource(22, 22);
    private A03ScrollBarStyle style;

    public A03StyledScrollBarDelegate(A03ScrollBarStyle style) {
        this.style = style;
    }

    public void paintBackground(Component c, Graphics g) {
    }

    public void paintThumb(Graphics g, JComponent c, Rectangle thumbBounds) {
        JScrollBar scrollbar = (JScrollBar)c;
        int x = thumbBounds.x + 1;
        int y = thumbBounds.y + 1;
        int width = thumbBounds.width - 2;
        int height = thumbBounds.height - 2;
        int state = A03StyledSwingUtilities.getState(c);
        int orientation = scrollbar.getOrientation();
        Paint backgroundPaint = this.style.getThumbBackgroundPaint(state, orientation, x, y, width, height);
        Paint borderPaint = this.style.getThumbBorderPaint(state, orientation, x, y, width - 1, height - 1);
        Shape shape = orientation == 0 ? A03GraphicsUtilities.createRoundRectangle(x, y, width - 1, height - 1, height / 2) : A03GraphicsUtilities.createRoundRectangle(x, y, width - 1, height - 1, width / 2);
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(backgroundPaint);
        graphics.fill(shape);
        graphics.setPaint(borderPaint);
        graphics.draw(shape);
    }

    public void paintTrack(Graphics g, JComponent c, Rectangle trackBounds) {
        JScrollBar scrollbar = (JScrollBar)c;
        Graphics2D graphics = (Graphics2D)g.create();
        int width = c.getWidth();
        int height = c.getHeight();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int state = A03StyledSwingUtilities.getState(c);
        int orientation = scrollbar.getOrientation();
        Paint scrollBarBorder = this.style.getBorderPaint(state, orientation, 0, 0, width, height);
        Paint scrollBarBackground = this.style.getBackgroundPaint(state, orientation, 0, 0, width, height);
        Paint scrollBarTrackBorder = this.style.getTrackBorderPaint(state, orientation, 0, 0, width, height);
        Paint scrollBarTrackBackground = this.style.getTrackBackgroundPaint(state, orientation, 0, 0, width, height);
        int radius = orientation == 0 ? height / 2 : width / 2;
        Shape shape = A03GraphicsUtilities.createRoundRectangle(trackBounds.x, trackBounds.y, trackBounds.width - 1, trackBounds.height - 1, radius);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setPaint(scrollBarBackground);
        if (orientation == 0) {
            if (trackBounds.width > A03StyledScrollBarDelegate.minimumThumbSize.width) {
                graphics.fillRect(0, 0, trackBounds.x + radius, trackBounds.height);
                int endX = trackBounds.x + trackBounds.width - radius;
                graphics.fillRect(endX, 0, width - endX, trackBounds.height);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setPaint(scrollBarTrackBackground);
                graphics.fill(shape);
                graphics.setPaint(scrollBarTrackBorder);
                graphics.draw(shape);
            } else {
                graphics.fillRect(0, 0, width, height);
            }
        } else if (trackBounds.height > A03StyledScrollBarDelegate.minimumThumbSize.height) {
            graphics.fillRect(0, 0, trackBounds.width, trackBounds.y + radius);
            graphics.fillRect(0, trackBounds.height - radius, trackBounds.width, height - (trackBounds.height - radius));
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setPaint(scrollBarTrackBackground);
            graphics.fill(shape);
            graphics.setPaint(scrollBarTrackBorder);
            graphics.draw(shape);
        } else {
            graphics.fillRect(0, 0, width, height);
        }
        graphics.setPaint(scrollBarBorder);
        graphics.drawRect(0, 0, width - 1, height - 1);
        graphics.dispose();
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public DimensionUIResource getMinimumThumbSize() {
        return minimumThumbSize;
    }

    public Insets getArrowBorderInsets(Component c, Insets insets) {
        return null;
    }

    public InsetsUIResource getArrowMargin() {
        return null;
    }

    public void paintArrow(Component c, Graphics g, int direction) {
        int size;
        int width = c.getWidth();
        int height = c.getHeight();
        if (height < (size = Math.max(width, height) / 3 + 1) || width < size) {
            return;
        }
        int x = (width - size) / 2;
        int y = (height - size) / 2;
        A03StyledGraphicsUtilities.paintArrow(g, x, y, size, size, direction, this.style.getArrowPaint(1, direction, x, y, size, size));
    }

    public void paintArrowBackground(Component c, Graphics g) {
    }

    public void paintArrowBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }
}

