/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03RootPaneDelegate;
import a03.swing.plaf.A03RootPaneUI;
import a03.swing.plaf.A03TitlePane;
import a03.swing.plaf.style.A03RootPaneStyle;
import a03.swing.plaf.style.A03StyledCloseIcon;
import a03.swing.plaf.style.A03StyledIconifyIcon;
import a03.swing.plaf.style.A03StyledMaximizeIcon;
import a03.swing.plaf.style.A03StyledMinimizeIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;

public class A03StyledRootPaneDelegate
implements A03RootPaneDelegate {
    private A03RootPaneStyle style;
    private Icon closeIcon;
    private Icon iconifyIcon;
    private Icon maximizeIcon;
    private Icon minimizeIcon;

    public A03StyledRootPaneDelegate(A03RootPaneStyle style) {
        this.style = style;
        this.closeIcon = new A03StyledCloseIcon(style);
        this.iconifyIcon = new A03StyledIconifyIcon(style);
        this.maximizeIcon = new A03StyledMaximizeIcon(style);
        this.minimizeIcon = new A03StyledMinimizeIcon(style);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 1;
        insets.left = 3;
        insets.bottom = 3;
        insets.right = 3;
        return insets;
    }

    public FontUIResource getTitleFont() {
        return new FontUIResource(this.style.getTitleFont());
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JRootPane rootPane = (JRootPane)c;
        A03RootPaneUI rootPaneUI = (A03RootPaneUI)rootPane.getUI();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Window window = SwingUtilities.getWindowAncestor(rootPane);
        int state = window.isActive() ? 1 : 0;
        int titlePaneHeight = rootPaneUI.getTitlePane().getHeight();
        Insets insets = this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        int h = titlePaneHeight - 1;
        JMenuBar menuBar = ((JRootPane)c).getJMenuBar();
        if (menuBar != null) {
            int menuBarHeight = menuBar.getHeight();
            h += menuBarHeight;
        }
        graphics.translate(x, y);
        graphics.setPaint(this.style.getBorderPaint(state, 0, 0, width - 1, height - 1));
        graphics.drawRect(0, 0, width - 1, height - 1);
        graphics.setPaint(this.style.getTitleBackgroundPaint(state, 0, 0, 0, titlePaneHeight + insets.top));
        graphics.fillRect(1, 1, insets.left, height - 1 - 1);
        graphics.fillRect(width - insets.right, 1, insets.right - 1, height - 1 - 1);
        graphics.fillRect(insets.left, height - insets.bottom, width - insets.left - insets.right, insets.bottom - 1);
        graphics.dispose();
    }

    public void paintTitleBackground(Component c, Graphics g) {
        JRootPane rootPane = (JRootPane)c;
        A03RootPaneUI ui = (A03RootPaneUI)rootPane.getUI();
        A03TitlePane titlePane = (A03TitlePane)ui.getTitlePane();
        int width = titlePane.getWidth();
        int height = titlePane.getHeight();
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        int state = titlePane.isActive() ? 1 : 0;
        graphics.setPaint(this.style.getTitleBackgroundPaint(state, 0, 0, 0, height));
        graphics.fillRect(0, 0, width, height);
    }

    public void paintTitleText(Component c, Graphics g, String text, int x, int y) {
        Graphics2D graphics = (Graphics2D)g;
        JRootPane rootPane = (JRootPane)c;
        Window window = SwingUtilities.getWindowAncestor(rootPane);
        int state = window.isActive() ? 1 : 0;
        graphics.setColor(this.style.getTitleTextColor(state));
        graphics.drawString(text, x, y);
    }

    public int getCloseIconHeight() {
        return this.closeIcon.getIconHeight();
    }

    public int getCloseIconWidth() {
        return this.closeIcon.getIconWidth();
    }

    public int getIconifyIconHeight() {
        return this.iconifyIcon.getIconHeight();
    }

    public int getIconifyIconWidth() {
        return this.iconifyIcon.getIconWidth();
    }

    public int getMaximizeIconHeight() {
        return this.maximizeIcon.getIconHeight();
    }

    public int getMaximizeIconWidth() {
        return this.maximizeIcon.getIconWidth();
    }

    public int getMinimizeIconHeight() {
        return this.minimizeIcon.getIconHeight();
    }

    public int getMinimizeIconWidth() {
        return this.minimizeIcon.getIconWidth();
    }

    public void paintCloseIcon(Component c, Graphics g, int x, int y) {
        this.closeIcon.paintIcon(c, g, x, y);
    }

    public void paintIconifyIcon(Component c, Graphics g, int x, int y) {
        this.iconifyIcon.paintIcon(c, g, x, y);
    }

    public void paintMaximizeIcon(Component c, Graphics g, int x, int y) {
        this.maximizeIcon.paintIcon(c, g, x, y);
    }

    public void paintMinimizeIcon(Component c, Graphics g, int x, int y) {
        this.minimizeIcon.paintIcon(c, g, x, y);
    }

    public Color getTitleBackground(Component c) {
        int state = ((A03TitlePane)((A03RootPaneUI)((JRootPane)c).getUI()).getTitlePane()).isActive() ? 1 : 0;
        return this.style.getTitleBackground(state);
    }
}

