/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03ProgressBarDelegate;
import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plaf.style.A03ProgressBarStyle;
import a03.swing.plaf.style.A03StyledSwingUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import javax.swing.JProgressBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;

public class A03StyledProgressBarDelegate
implements A03ProgressBarDelegate {
    private static final DimensionUIResource preferredInnerHorizontal = new DimensionUIResource(146, 16);
    private static final DimensionUIResource preferredInnerVertical = new DimensionUIResource(16, 146);
    private A03ProgressBarStyle style;

    public A03StyledProgressBarDelegate(A03ProgressBarStyle style) {
        this.style = style;
    }

    public void paintDeterminate(Component c, Graphics g, int amountFull) {
        JProgressBar progressBar = (JProgressBar)c;
        Insets insets = progressBar.getInsets();
        int barRectWidth = progressBar.getWidth() - (insets.right + insets.left);
        int barRectHeight = progressBar.getHeight() - (insets.top + insets.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        Image image = A03GraphicsUtilities.createImage(c, barRectWidth, barRectHeight);
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.translate(insets.left, insets.top);
        int state = A03StyledSwingUtilities.getState(c);
        int orientation = progressBar.getOrientation();
        Paint backgroundPaint = this.style.getBackgroundPaint(state, orientation, 0, 0, barRectWidth, barRectHeight);
        Paint determinateBackgroundPaint = this.style.getAmountBackgroundPaint(state, orientation, 0, 0, barRectWidth, barRectHeight);
        int width = c.getWidth();
        int height = c.getHeight();
        float borderCornerRadius = this.style.getBorderCornerRadius(width, height);
        Shape clip = A03GraphicsUtilities.createRoundRectangle(0, 0, c.getWidth() - 1, c.getHeight() - 1, borderCornerRadius);
        graphics.setClip(clip);
        graphics.setPaint(backgroundPaint);
        graphics.fillRect(0, 0, c.getWidth() - 1, c.getHeight() - 1);
        if (amountFull > 0) {
            if (orientation == 0) {
                graphics.setPaint(backgroundPaint);
                if (A03SwingUtilities.isLeftToRight(progressBar)) {
                    graphics.fillRect(0, 0, amountFull, barRectHeight);
                } else {
                    graphics.fillRect(barRectWidth - amountFull, 0, barRectWidth, barRectHeight);
                }
                graphics.setPaint(determinateBackgroundPaint);
                if (A03SwingUtilities.isLeftToRight(progressBar)) {
                    graphics.fillRect(0, 0, amountFull, barRectHeight);
                } else {
                    graphics.fillRect(barRectWidth - amountFull, 0, barRectWidth, barRectHeight);
                }
            } else {
                graphics.setPaint(backgroundPaint);
                graphics.fillRect(0, barRectHeight - amountFull, barRectWidth, barRectHeight);
                graphics.setPaint(determinateBackgroundPaint);
                graphics.fillRect(0, barRectHeight - amountFull, barRectWidth, barRectHeight);
            }
        }
        graphics.dispose();
        g.drawImage(image, 0, 0, c);
    }

    public void paintIndeterminate(Component c, Graphics g, int animationIndex) {
        JProgressBar progressBar = (JProgressBar)c;
        Insets insets = progressBar.getInsets();
        int barRectWidth = progressBar.getWidth() - (insets.right + insets.left);
        int barRectHeight = progressBar.getHeight() - (insets.top + insets.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(insets.left, insets.top);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle2D clip = graphics.getClip().getBounds().createIntersection(new Rectangle(0, 0, barRectWidth, barRectHeight));
        graphics.setClip(clip);
        boolean leftToRight = A03SwingUtilities.isLeftToRight(c);
        int orientation = progressBar.getOrientation();
        int state = A03StyledSwingUtilities.getState(c);
        Paint backgroundPaint = this.style.getBackgroundPaint(state, orientation, 0, 0, barRectWidth, barRectHeight);
        Image tempImage = A03GraphicsUtilities.createImage(c, barRectWidth, barRectHeight);
        Graphics2D graphics2 = (Graphics2D)tempImage.getGraphics();
        float borderCornerRadius = this.style.getBorderCornerRadius(barRectWidth, barRectHeight);
        Shape clip2 = A03GraphicsUtilities.createRoundRectangle(0, 0, barRectWidth - 1, barRectHeight - 1, borderCornerRadius);
        graphics2.setClip(clip2);
        Paint paint = this.style.getIndeterminateBackgroundPaint(A03StyledSwingUtilities.getState(c), orientation, 0, 0, barRectWidth, barRectHeight);
        if (orientation == 0) {
            int w = 2 * barRectHeight;
            Image tempImage2 = A03GraphicsUtilities.createImage(c, w, barRectHeight);
            Graphics2D g2d = (Graphics2D)tempImage2.getGraphics();
            int halfW = w / 2;
            GeneralPath path = new GeneralPath();
            path.moveTo(halfW, 0.0f);
            path.lineTo(w, 0.0f);
            path.lineTo(halfW, barRectHeight);
            path.lineTo(0.0f, barRectHeight);
            path.closePath();
            g2d.setPaint(backgroundPaint);
            g2d.fillRect(0, 0, w, barRectHeight);
            g2d.setPaint(paint);
            g2d.fill(path);
            g2d.dispose();
            int x = leftToRight ? -w : barRectWidth;
            int t = animationIndex % w;
            int n = barRectWidth / w;
            int i = 0;
            while (i <= n + 1) {
                int xt = x + (leftToRight ? t : -t);
                graphics2.drawImage(tempImage2, xt, 0, c);
                x += leftToRight ? w : -w;
                ++i;
            }
        } else {
            int h = 2 * barRectWidth;
            Image tempImage2 = A03GraphicsUtilities.createImage(c, barRectWidth, h);
            Graphics2D g2d = (Graphics2D)tempImage2.getGraphics();
            int halfH = h / 2;
            GeneralPath path = new GeneralPath();
            path.moveTo(0.0f, 0.0f);
            path.lineTo(barRectWidth, halfH);
            path.lineTo(barRectWidth, h);
            path.lineTo(0.0f, halfH);
            path.closePath();
            g2d.setPaint(backgroundPaint);
            g2d.fillRect(0, 0, barRectWidth, h);
            g2d.setPaint(paint);
            g2d.fill(path);
            g2d.dispose();
            int y = 0;
            int t = animationIndex % h;
            int n = barRectHeight / h;
            int i = 0;
            while (i <= n + 1) {
                int yt = barRectHeight + y - t;
                graphics2.drawImage(tempImage2, 0, yt, c);
                y -= h;
                ++i;
            }
        }
        graphics2.dispose();
        graphics.drawImage(tempImage, insets.left, insets.top, c);
        graphics.dispose();
    }

    public void paintText(Component c, Graphics g, String text, int x, int y) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(this.style.getForegroundColor(A03StyledSwingUtilities.getState(c)));
        graphics.drawString(text, x, y);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 0;
        insets.left = 0;
        insets.bottom = 0;
        insets.right = 0;
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        JProgressBar progressBar = (JProgressBar)c;
        int state = A03StyledSwingUtilities.getState(c);
        Paint border = this.style.getBorderPaint(state, progressBar.getOrientation(), x, y, width, height);
        graphics.setPaint(border);
        float borderCornerRadius = this.style.getBorderCornerRadius(width, height);
        Shape shape = A03GraphicsUtilities.createRoundRectangle(0, 0, width - 1, height - 1, borderCornerRadius);
        graphics.draw(shape);
    }

    public DimensionUIResource getPreferredInnerHorizontal() {
        return preferredInnerHorizontal;
    }

    public DimensionUIResource getPreferredInnerVertical() {
        return preferredInnerVertical;
    }

    public FontUIResource getFont() {
        return new FontUIResource(this.style.getFont());
    }

    public ColorUIResource getForeground() {
        return new ColorUIResource(this.style.getForegroundColor());
    }
}

