/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03PopupMenuDelegate;
import a03.swing.plaf.style.A03PopupMenuStyle;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;

public class A03StyledPopupMenuDelegate
implements A03PopupMenuDelegate {
    private A03PopupMenuStyle style;

    public A03StyledPopupMenuDelegate(A03PopupMenuStyle style) {
        this.style = style;
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        if (c instanceof JPopupMenu && ((JPopupMenu)c).getInvoker() instanceof JComboBox) {
            insets.top = 1;
            insets.left = 1;
            insets.bottom = 1;
            insets.right = 1;
        } else {
            int left = 2;
            int right = 2;
            if (c instanceof JPopupMenu) {
                JPopupMenu popupMenu = (JPopupMenu)c;
                Component invoker = popupMenu.getInvoker();
                Point menuScreenLocation = new Point();
                if (invoker instanceof JMenu) {
                    JMenu menu = (JMenu)invoker;
                    SwingUtilities.convertPointToScreen(menuScreenLocation, menu);
                    if (menuScreenLocation.x < 0) {
                        left = 0;
                    } else if (menuScreenLocation.x + menu.getWidth() > Toolkit.getDefaultToolkit().getScreenSize().width) {
                        right = 0;
                    }
                }
            }
            insets.top = 2;
            insets.left = left;
            insets.bottom = 2;
            insets.right = right;
        }
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics.setPaint(this.style.getPopupMenuBorderPaint(x, y, width - 1, height - 1));
        graphics.drawRect(x, y, width - 1, height - 1);
    }

    public ColorUIResource getBackground() {
        return new ColorUIResource(this.style.getBackgroundColor());
    }
}

