/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03OptionPaneDelegate;
import a03.swing.plaf.style.A03OptionPaneStyle;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class A03StyledOptionPaneDelegate
implements A03OptionPaneDelegate {
    private static Icon informationIcon = new InformationIcon();
    private static Icon questionIcon = new QuestionIcon();
    private static Icon warningIcon = new WarningIcon();
    private static Icon errorIcon = new ErrorIcon();
    private A03OptionPaneStyle style;

    public A03StyledOptionPaneDelegate(A03OptionPaneStyle style) {
        this.style = style;
    }

    public int getErrorIconHeight() {
        return errorIcon.getIconHeight();
    }

    public int getErrorIconWidth() {
        return errorIcon.getIconWidth();
    }

    public int getInformationIconHeight() {
        return informationIcon.getIconHeight();
    }

    public int getInformationIconWidth() {
        return informationIcon.getIconWidth();
    }

    public int getQuestionIconHeight() {
        return questionIcon.getIconHeight();
    }

    public int getQuestionIconWidth() {
        return questionIcon.getIconWidth();
    }

    public int getWarningIconHeight() {
        return warningIcon.getIconHeight();
    }

    public int getWarningIconWidth() {
        return warningIcon.getIconWidth();
    }

    public void paintErrorIcon(Component c, Graphics g, int x, int y) {
        errorIcon.paintIcon(c, g, x, y);
    }

    public void paintInformationIcon(Component c, Graphics g, int x, int y) {
        informationIcon.paintIcon(c, g, x, y);
    }

    public void paintQuestionIcon(Component c, Graphics g, int x, int y) {
        questionIcon.paintIcon(c, g, x, y);
    }

    public void paintWarningIcon(Component c, Graphics g, int x, int y) {
        warningIcon.paintIcon(c, g, x, y);
    }

    public Icon getErrorIcon() {
        return errorIcon;
    }

    public Icon getInformationIcon() {
        return informationIcon;
    }

    public Icon getQuestionIcon() {
        return questionIcon;
    }

    public Icon getWarningIcon() {
        return warningIcon;
    }

    public Insets getMessageAreaBorderInsets(Component c, Insets insets) {
        insets.top = 10;
        insets.left = 10;
        insets.bottom = 10;
        insets.right = 30;
        return insets;
    }

    public Insets getButtonAreaBorderInsets(Component c, Insets insets) {
        insets.top = 6;
        insets.left = 0;
        insets.bottom = 6;
        insets.right = 0;
        return insets;
    }

    public String getErrorSound() {
        return "/javax/swing/plaf/metal/sounds/OptionPaneError.wav";
    }

    public String getInformationSound() {
        return "/javax/swing/plaf/metal/sounds/OptionPaneInformation.wav";
    }

    public String getQuestionSound() {
        return "/javax/swing/plaf/metal/sounds/OptionPaneQuestion.wav";
    }

    public String getWarningSound() {
        return "/javax/swing/plaf/metal/sounds/OptionPaneWarning.wav";
    }

    public void paintButtonAreaBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public void paintMessageAreaBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setPaint(this.style.getMessageAreaBorderPaint(x, y, width - 1, height - 1));
        graphics.draw(A03GraphicsUtilities.createRoundRectangle(x, y, width - 1, height - 1, 1.0f));
        graphics.dispose();
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 4;
        insets.left = 4;
        insets.bottom = 2;
        insets.right = 4;
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    public ColorUIResource getMessageAreaBackground() {
        return new ColorUIResource(this.style.getMessageAreaBackgroundColor());
    }

    public ColorUIResource getBackground() {
        return new ColorUIResource(this.style.getBackgroundColor());
    }

    public FontUIResource getMessageFont() {
        return new FontUIResource(this.style.getMessageFont());
    }

    static class ErrorIcon
    implements Icon {
        ErrorIcon() {
        }

        public int getIconHeight() {
            return 36;
        }

        public int getIconWidth() {
            return 36;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D graphics = (Graphics2D)g.create();
            int border = 3;
            int offset = border / 2;
            Ellipse2D.Double ellipse = new Ellipse2D.Double(offset, offset, this.getIconWidth() - 2 * offset - 1, this.getIconHeight() - 2 * offset - 1);
            graphics.setStroke(new BasicStroke(3.0f, 1, 1));
            graphics.setColor(new Color(9633800));
            graphics.draw(ellipse);
            Paint paint = A03GraphicsUtilities.createLinearGradientPaint(this.getIconWidth() / 2, offset, this.getIconWidth() / 2, this.getIconHeight() - 2 * offset, new float[]{0.0f, 1.0f}, new Color[]{new Color(14234934), new Color(8325899)});
            graphics.setPaint(paint);
            graphics.fill(ellipse);
            graphics.setStroke(new BasicStroke(1.0f, 1, 1));
            paint = A03GraphicsUtilities.createLinearGradientPaint(this.getIconWidth() / 2, offset, this.getIconWidth() / 2, this.getIconHeight() - 2 * offset, new float[]{0.0f, 1.0f}, new Color[]{new Color(16742773), new Color(8325899)});
            graphics.setPaint(paint);
            graphics.draw(ellipse);
            int x1 = 10;
            int y1 = 10;
            int x2 = this.getIconWidth() - x1 - 1;
            int y2 = this.getIconHeight() - y1 - 1;
            int x3 = x1;
            int y3 = y2;
            int x4 = x2;
            int y4 = y1;
            graphics.setStroke(new BasicStroke(5.0f, 1, 1));
            graphics.setColor(Color.WHITE);
            graphics.drawLine(x1, y1, x2, y2);
            graphics.drawLine(x3, y3, x4, y4);
            graphics.dispose();
        }
    }

    static class InformationIcon
    implements Icon {
        InformationIcon() {
        }

        public int getIconHeight() {
            return 36;
        }

        public int getIconWidth() {
            return 36;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D graphics = (Graphics2D)g.create();
            Stroke oldStroke = graphics.getStroke();
            int border = 3;
            int offset = border / 2;
            Container parent = c.getParent();
            Color background = parent instanceof CellRendererPane ? c.getBackground() : parent.getBackground();
            Color borderColor = new Color(32707);
            Color shadowColor = A03GraphicsUtilities.createColor(background, borderColor, 0.1);
            Ellipse2D.Double ellipse = new Ellipse2D.Double(offset, offset, this.getIconWidth() - 2 * offset, (double)this.getIconHeight() * 0.85 - (double)(2 * offset));
            Area a1 = new Area(ellipse);
            GeneralPath path = new GeneralPath();
            path.moveTo(this.getIconWidth() / 2, (float)this.getIconHeight() * 0.85f / 2.0f);
            path.quadTo(this.getIconWidth() / 2 - this.getIconWidth() / 16, (float)this.getIconHeight() * 0.85f, this.getIconWidth() / 2 - this.getIconWidth() / 8, this.getIconHeight() - offset);
            path.quadTo(this.getIconWidth() / 2 + 2 * offset, this.getIconHeight() - 2 * offset, this.getIconWidth() / 2 + this.getIconWidth() / 8, (float)this.getIconHeight() * 0.8f / 2.0f);
            path.closePath();
            Area a2 = new Area(path);
            a1.add(a2);
            graphics.setStroke(new BasicStroke(border, 1, 1));
            graphics.setColor(shadowColor);
            graphics.draw(a1);
            graphics.setStroke(oldStroke);
            Paint paint = A03GraphicsUtilities.createLinearGradientPaint(this.getIconWidth() / 2, offset, this.getIconWidth() / 2, (int)((double)this.getIconHeight() * 0.8) - 2 * offset, new float[]{0.0f, 1.0f}, new Color[]{new Color(8115706), new Color(1685746)});
            graphics.setPaint(paint);
            graphics.fill(a1);
            graphics.setColor(borderColor);
            graphics.draw(a1);
            graphics.setStroke(new BasicStroke(5.0f, 1, 1));
            graphics.setColor(Color.WHITE);
            graphics.fillOval(this.getIconWidth() / 2 - 2, 5, 5, 5);
            graphics.drawLine(this.getIconWidth() / 2, 14, this.getIconWidth() / 2, (int)((float)this.getIconHeight() * 0.6f));
            graphics.dispose();
        }
    }

    static class QuestionIcon
    implements Icon {
        QuestionIcon() {
        }

        public int getIconHeight() {
            return 36;
        }

        public int getIconWidth() {
            return 36;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int border = 3;
            int offset = border / 2;
            Ellipse2D.Double ellipse = new Ellipse2D.Double(offset, offset, this.getIconWidth() - 2 * offset - 1, this.getIconHeight() - 2 * offset - 1);
            Color outerBorderColor = new Color(0x4544C4);
            graphics.setStroke(new BasicStroke(3.0f, 1, 1));
            graphics.setColor(outerBorderColor);
            graphics.draw(ellipse);
            Paint paint = A03GraphicsUtilities.createLinearGradientPaint(this.getIconWidth() / 2, offset, this.getIconWidth() / 2, this.getIconHeight() - 2 * offset, new float[]{0.0f, 1.0f}, new Color[]{new Color(4226809), new Color(1399992)});
            graphics.setPaint(paint);
            graphics.fill(ellipse);
            graphics.setStroke(new BasicStroke(1.0f));
            paint = A03GraphicsUtilities.createLinearGradientPaint(this.getIconWidth() / 2, offset, this.getIconWidth() / 2, this.getIconHeight() - 2 * offset, new float[]{0.0f, 1.0f}, new Color[]{new Color(13954559), new Color(1399992)});
            graphics.setPaint(paint);
            graphics.draw(ellipse);
            int x0 = this.getIconWidth() / 2;
            int y0 = 12;
            int w = 10;
            Arc2D.Double arc = new Arc2D.Double(x0 - w / 2, y0 - w / 2, w, w, 155.0, -200.0, 0);
            GeneralPath path = new GeneralPath();
            path.append(arc, true);
            graphics.setColor(Color.WHITE);
            Line2D.Double line2d = new Line2D.Double((double)x0 + (double)w * Math.cos(-0.7853981633974483) / 2.0, (double)y0 - (double)w * Math.sin(-0.7853981633974483) / 2.0, x0, (double)y0 - (double)w * Math.sin(-0.7853981633974483) / 2.0 + 4.0);
            path.append(line2d, true);
            line2d = new Line2D.Double(x0, (double)y0 - (double)w * Math.sin(-0.7853981633974483) / 2.0 + 4.0, x0, (double)y0 - (double)w * Math.sin(-0.7853981633974483) / 2.0 + 7.0);
            path.append(line2d, true);
            graphics.setStroke(new BasicStroke(4.0f, 2, 1));
            graphics.draw(path);
            graphics.fill(A03GraphicsUtilities.createRoundRectangle(x0 - 2, (int)((double)y0 - (double)w * Math.sin(-0.7853981633974483) / 2.0 + 12.0), 5, 5, 1.0f));
            graphics.dispose();
        }
    }

    static class WarningIcon
    implements Icon {
        WarningIcon() {
        }

        public int getIconHeight() {
            return 36;
        }

        public int getIconWidth() {
            return 36;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D graphics = (Graphics2D)g;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath path = new GeneralPath();
            int border = 7;
            int offset = border / 2;
            int w = this.getIconWidth() - 1;
            path.moveTo(w / 2, offset);
            int h = (int)((double)w * Math.sin(1.0471975511965976));
            path.lineTo(offset, h);
            path.lineTo(w - offset - 1, h);
            path.closePath();
            Color outerBorderColor = new Color(13415781);
            graphics.setStroke(new BasicStroke(border, 1, 1));
            graphics.setColor(outerBorderColor);
            graphics.draw(path);
            graphics.setStroke(new BasicStroke(1.0f, 1, 1));
            path = new GeneralPath();
            path.moveTo(w / 2 + 1, 1.0f);
            path.quadTo(w / 2, 0.0f, w / 2 - 1, 1.0f);
            path.lineTo(2.0f, h - offset + 1);
            path.quadTo(0.0f, h + offset - 1, 2.0f, h + offset - 1);
            path.lineTo(w - offset, h + offset - 1);
            path.quadTo(w - offset + 2, h + offset - 1, w - offset, h - offset + 1);
            path.closePath();
            graphics.draw(path);
            Paint paint = A03GraphicsUtilities.createLinearGradientPaint(w / 2, offset, w / 2, h, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, new Color[]{new Color(16772740), new Color(16769365), new Color(16439405), new Color(16564736)});
            graphics.setPaint(paint);
            graphics.fill(path);
            Color borderColor = new Color(16774802);
            graphics.setColor(borderColor);
            graphics.draw(path);
            graphics.setColor(Color.BLACK);
            graphics.translate(this.getIconWidth() / 2 - 3, 8);
            int r1 = 5;
            int r2 = 3;
            int r3 = 2;
            int r4 = 2;
            int h2 = 16;
            GeneralPath esclamationMarkPath = new GeneralPath();
            esclamationMarkPath.moveTo(0.0f, r1);
            esclamationMarkPath.curveTo(0.0f, 0.0f, 2 * r2 - 1, 0.0f, 2 * r2 - 1, r1);
            esclamationMarkPath.lineTo(r2 + r3 - 1, h2 - r4);
            esclamationMarkPath.curveTo(r2 + r3 - 1, h2, r2 - r3, h2, r2 - r3, h2 - r4);
            esclamationMarkPath.closePath();
            graphics.fill(esclamationMarkPath);
            graphics.translate(-this.getIconWidth() / 2 + 3, -8);
            graphics.fill(new Ellipse2D.Double(this.getIconWidth() / 2 - 3, this.getIconHeight() / 2 + 7, 5.0, 5.0));
        }
    }
}

