/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03MenuItemDelegate;
import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plaf.style.A03MenuItemStyle;
import a03.swing.plaf.style.A03StyledGraphicsUtilities;
import a03.swing.plaf.style.A03StyledRadioButtonIcon;
import a03.swing.plaf.style.A03StyledSwingUtilities;
import a03.swing.plugin.A03FadeTrackerPlugin;
import a03.swing.plugin.A03PluginManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.GeneralPath;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;

public class A03StyledMenuItemDelegate
implements A03MenuItemDelegate {
    private A03MenuItemStyle style;
    private Icon radioButtonMenuItemIcon;

    public A03StyledMenuItemDelegate(A03MenuItemStyle style) {
        this.style = style;
        this.radioButtonMenuItemIcon = new A03StyledRadioButtonIcon(style, 12, 12);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        return null;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
    }

    private int getState(JMenuItem menuItem) {
        int state = 0;
        ButtonModel model = menuItem.getModel();
        if (model.isEnabled()) {
            state = 1;
        }
        if (menuItem instanceof JMenu) {
            JPopupMenu popupMenu = ((JMenu)menuItem).getPopupMenu();
            if (popupMenu.isShowing()) {
                state |= 2;
            }
        } else {
            double fadeLevel = A03PluginManager.getInstance().getPlugin(A03FadeTrackerPlugin.class).getFadeLevel(menuItem);
            if (fadeLevel > 0.0) {
                state |= 4;
            }
        }
        return state;
    }

    public void paintBackground(Component c, Graphics g) {
        JMenuItem menuItem = (JMenuItem)c;
        int width = menuItem.getWidth();
        int height = menuItem.getHeight();
        Graphics2D graphics = (Graphics2D)g;
        if (menuItem instanceof JMenu) {
            JPopupMenu popupMenu = ((JMenu)menuItem).getPopupMenu();
            Point menuItemLocation = menuItem.getLocationOnScreen();
            if (menuItem.getParent() instanceof JMenuBar) {
                Window window;
                JInternalFrame internalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, menuItem);
                int state = internalFrame != null ? (internalFrame.isSelected() ? this.getState(menuItem) : 0) : ((window = SwingUtilities.getWindowAncestor(menuItem)).isActive() ? this.getState(menuItem) : 0);
                graphics.setPaint(this.style.getMenuBarMenuBackgroundPaint(state, A03SwingUtilities.isAnchestorDecorated(c), 0, 0, width, height));
                graphics.fillRect(0, 0, width, height);
                if (popupMenu.isShowing()) {
                    Shape shape;
                    Point popupMenuLocation = popupMenu.getLocationOnScreen();
                    graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    if (menuItemLocation.y < popupMenuLocation.y) {
                        graphics.setPaint(this.style.getBackgroundPaint(state, 2, 1, width - 5, height + 1));
                        shape = A03GraphicsUtilities.createRoundRectangle(2, 1, width - 5, height + 1, 3.0f);
                    } else {
                        graphics.setPaint(this.style.getBackgroundPaint(state, 2, -3, width - 5, height + 2));
                        shape = A03GraphicsUtilities.createRoundRectangle(2, -3, width - 5, height + 2, 3.0f);
                    }
                    graphics.setPaint(this.style.getBackgroundPaint(state, 0, 0, width, height));
                    graphics.fill(shape);
                }
            } else {
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics.setPaint(this.style.getBackgroundPaint(this.getState(menuItem), 0, 0, width, height));
                graphics.fillRect(0, 0, width, height);
            }
        } else {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setPaint(this.style.getBackgroundPaint(this.getState(menuItem), 0, 0, width, height));
            graphics.fillRect(0, 0, width, height);
        }
    }

    public FontUIResource getFont() {
        return new FontUIResource(this.style.getFont());
    }

    public FontUIResource getAcceleratorFont() {
        return new FontUIResource(this.style.getAcceleratorFont());
    }

    public void paintAcceleratorText(Component c, Graphics g, String text, int x, int y) {
        int state = this.getState((JMenuItem)c);
        Graphics2D graphics = (Graphics2D)g;
        graphics.setColor(this.style.getAcceleratorColor(state));
        graphics.drawString(text, x, y);
    }

    public void paintText(Component c, Graphics g, String text, int x, int y) {
        Graphics2D graphics = (Graphics2D)g;
        JMenuItem menuItem = (JMenuItem)c;
        if (menuItem instanceof JMenu) {
            if (menuItem.getParent() instanceof JMenuBar) {
                Window window;
                JInternalFrame internalFrame = (JInternalFrame)SwingUtilities.getAncestorOfClass(JInternalFrame.class, menuItem);
                int state = internalFrame != null ? (internalFrame.isSelected() ? this.getState(menuItem) : 0) : ((window = SwingUtilities.getWindowAncestor(menuItem)).isActive() ? this.getState(menuItem) : 0);
                graphics.setColor(this.style.getMenuBarMenuForegroundColor(state, A03SwingUtilities.isAnchestorDecorated(c)));
            } else {
                graphics.setColor(this.style.getForegroundColor(this.getState(menuItem)));
            }
        } else {
            graphics.setColor(this.style.getForegroundColor(this.getState(menuItem)));
        }
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        A03GraphicsUtilities.drawStringUnderlineCharAt(menuItem, graphics, text, mnemIndex, x, y);
    }

    public int getArrowIconHeight() {
        return 9;
    }

    public int getArrowIconWidth() {
        return 9;
    }

    public int getCheckBoxIconHeight() {
        return 14;
    }

    public int getCheckBoxIconWidth() {
        return 14;
    }

    public int getRadioButtonIconHeight() {
        return this.radioButtonMenuItemIcon.getIconHeight();
    }

    public int getRadioButtonIconWidth() {
        return this.radioButtonMenuItemIcon.getIconWidth();
    }

    public void paintArrowIcon(Component c, Graphics g, int x, int y) {
        boolean leftToRight = A03SwingUtilities.isLeftToRight(c);
        int size = 9;
        Graphics2D graphics = (Graphics2D)g;
        graphics.setPaint(this.style.getArrowPaint(A03StyledSwingUtilities.getState(c), leftToRight ? 3 : 7, x, y, this.getArrowIconWidth(), this.getArrowIconHeight()));
        GeneralPath path = new GeneralPath();
        if (leftToRight) {
            path.moveTo(x, y);
            path.lineTo(x + size / 2, y + size / 2);
            path.lineTo(x, y + size - 1);
        } else {
            path.moveTo(x + size / 2, y);
            path.lineTo(x, y + size / 2);
            path.lineTo(x + size / 2, y + size - 1);
        }
        path.closePath();
        graphics.fill(path);
    }

    public void paintCheckBoxIcon(Component c, Graphics g, int x, int y) {
        int state = A03StyledSwingUtilities.getState(c);
        int width = this.getCheckBoxIconWidth();
        int height = this.getCheckBoxIconHeight();
        if ((state & 2) != 0) {
            Graphics2D graphics = (Graphics2D)g;
            A03StyledGraphicsUtilities.paintCheck(graphics, this.style.getCheckBoxCheckPaint(state, 3, 3, width - 3, height - 3), 3, 3, width - 3, height - 3);
        }
    }

    public void paintRadioButtonIcon(Component c, Graphics g, int x, int y) {
        this.radioButtonMenuItemIcon.paintIcon(c, g, x, y);
    }
}

