/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03InternalFrameDelegate;
import a03.swing.plaf.A03InternalFrameUI;
import a03.swing.plaf.A03RootPaneUI;
import a03.swing.plaf.A03TitlePane;
import a03.swing.plaf.style.A03InternalFrameStyle;
import a03.swing.plaf.style.A03StyledCloseIcon;
import a03.swing.plaf.style.A03StyledIconifyIcon;
import a03.swing.plaf.style.A03StyledMaximizeIcon;
import a03.swing.plaf.style.A03StyledMinimizeIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicDesktopIconUI;

public class A03StyledInternalFrameDelegate
implements A03InternalFrameDelegate {
    private static Method createNorthPaneMethod;
    private A03InternalFrameStyle style;
    private Icon closeIcon;
    private Icon iconifyIcon;
    private Icon maximizeIcon;
    private Icon minimizeIcon;

    public A03StyledInternalFrameDelegate(A03InternalFrameStyle style) {
        this.style = style;
        this.closeIcon = new A03StyledCloseIcon(style);
        this.iconifyIcon = new A03StyledIconifyIcon(style);
        this.maximizeIcon = new A03StyledMaximizeIcon(style);
        this.minimizeIcon = new A03StyledMinimizeIcon(style);
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        if (c instanceof JInternalFrame) {
            insets.top = 2;
            insets.left = 3;
            insets.bottom = 3;
            insets.right = 3;
        } else if (c instanceof JInternalFrame.JDesktopIcon) {
            insets.top = 2;
            insets.left = 1;
            insets.bottom = 1;
            insets.right = 1;
        }
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        ComponentUI ui;
        int titlePaneHeight = 0;
        if (c instanceof JInternalFrame) {
            try {
                if (createNorthPaneMethod == null) {
                    createNorthPaneMethod = A03InternalFrameUI.class.getDeclaredMethod("createNorthPane", JInternalFrame.class);
                    createNorthPaneMethod.setAccessible(true);
                }
                ui = (A03InternalFrameUI)((JInternalFrame)c).getUI();
                titlePaneHeight = ((JComponent)A03StyledInternalFrameDelegate.createNorthPaneMethod.invoke((Object)ui, (Object[])new Object[]{c})).getPreferredSize().height;
            }
            catch (Exception ui2) {}
        } else if (c instanceof JInternalFrame.JDesktopIcon && (ui = ((JInternalFrame.JDesktopIcon)c).getUI()) instanceof BasicDesktopIconUI) {
            titlePaneHeight = ((BasicDesktopIconUI)ui).getPreferredSize((JComponent)((JInternalFrame.JDesktopIcon)c)).height;
        }
        if (titlePaneHeight > 0) {
            Graphics2D graphics = (Graphics2D)g.create();
            Insets insets = this.getBorderInsets(c, new Insets(0, 0, 0, 0));
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            int state = c instanceof JInternalFrame ? (((JInternalFrame)c).isSelected() ? 1 : 0) : 1;
            graphics.translate(x, y);
            graphics.setPaint(this.style.getBorderPaint(state, 0, 0, width - 1, height - 1));
            graphics.drawRect(0, 0, width - 1, height - 1);
            graphics.setPaint(this.style.getTitleBackgroundPaint(state, 0, 0, 0, titlePaneHeight + insets.top));
            graphics.fillRect(1, 1, width - 1 - 1, insets.top - 1);
            if (c instanceof JInternalFrame) {
                graphics.fillRect(1, 1, insets.left, height - 1 - 1);
                graphics.fillRect(width - insets.right, 1, insets.right - 1, height - 1 - 1);
                graphics.fillRect(insets.left, height - insets.bottom, width - insets.left - insets.right, insets.bottom - 1);
            }
            graphics.dispose();
        }
    }

    public void paintTitleBackground(Component c, Graphics g) {
        ComponentUI ui;
        int titlePaneHeight = 0;
        if (c instanceof JInternalFrame) {
            try {
                if (createNorthPaneMethod == null) {
                    createNorthPaneMethod = A03InternalFrameUI.class.getDeclaredMethod("createNorthPane", JInternalFrame.class);
                    createNorthPaneMethod.setAccessible(true);
                }
                ui = (A03InternalFrameUI)((JInternalFrame)c).getUI();
                titlePaneHeight = ((JComponent)A03StyledInternalFrameDelegate.createNorthPaneMethod.invoke((Object)ui, (Object[])new Object[]{c})).getPreferredSize().height;
            }
            catch (Exception ui2) {}
        } else if (c instanceof JInternalFrame.JDesktopIcon && (ui = ((JInternalFrame.JDesktopIcon)c).getUI()) instanceof BasicDesktopIconUI) {
            titlePaneHeight = ((BasicDesktopIconUI)ui).getPreferredSize((JComponent)((JInternalFrame.JDesktopIcon)c)).height;
        }
        if (titlePaneHeight > 0) {
            Graphics2D graphics = (Graphics2D)g;
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            int state = c instanceof JInternalFrame ? (((JInternalFrame)c).isSelected() ? 1 : 0) : 1;
            graphics.setPaint(this.style.getTitleBackgroundPaint(state, 0, 0, 0, titlePaneHeight));
            graphics.fillRect(0, 0, c.getWidth(), titlePaneHeight);
        }
    }

    public void paintTitleText(Component c, Graphics g, String text, int x, int y) {
        Graphics2D graphics = (Graphics2D)g.create();
        int state = 1;
        graphics.setColor(this.style.getTitleTextColor(state));
        graphics.drawString(text, x, y);
        graphics.dispose();
    }

    public FontUIResource getTitleFont() {
        return new FontUIResource(this.style.getTitleFont());
    }

    public int getCloseIconHeight() {
        return this.closeIcon.getIconHeight();
    }

    public int getCloseIconWidth() {
        return this.closeIcon.getIconWidth();
    }

    public int getIconifyIconHeight() {
        return this.iconifyIcon.getIconHeight();
    }

    public int getIconifyIconWidth() {
        return this.iconifyIcon.getIconWidth();
    }

    public int getMaximizeIconHeight() {
        return this.maximizeIcon.getIconHeight();
    }

    public int getMaximizeIconWidth() {
        return this.maximizeIcon.getIconWidth();
    }

    public int getMinimizeIconHeight() {
        return this.minimizeIcon.getIconHeight();
    }

    public int getMinimizeIconWidth() {
        return this.minimizeIcon.getIconWidth();
    }

    public void paintCloseIcon(Component c, Graphics g, int x, int y) {
        this.closeIcon.paintIcon(c, g, x, y);
    }

    public void paintIconifyIcon(Component c, Graphics g, int x, int y) {
        this.iconifyIcon.paintIcon(c, g, x, y);
    }

    public void paintMaximizeIcon(Component c, Graphics g, int x, int y) {
        this.maximizeIcon.paintIcon(c, g, x, y);
    }

    public void paintMinimizeIcon(Component c, Graphics g, int x, int y) {
        this.minimizeIcon.paintIcon(c, g, x, y);
    }

    public Color getTitleBackground(Component c) {
        int state = ((A03TitlePane)((A03RootPaneUI)((JRootPane)c).getUI()).getTitlePane()).isActive() ? 1 : 0;
        return this.style.getTitleBackground(state);
    }
}

