/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;

public class A03StyledGraphicsUtilities {
    public static void paintBorderShadow(Graphics2D g2, int shadowWidth, Shape clipShape, Color c1, Color c2) {
        int sw;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int i = sw = shadowWidth * 2;
        while (i >= 2) {
            float pct = (float)(sw - i) / (float)(sw - 1);
            g2.setColor(A03StyledGraphicsUtilities.getMixedColor(c1, pct, c2, 1.0f - pct));
            g2.setStroke(new BasicStroke(i));
            g2.draw(clipShape);
            i -= 2;
        }
    }

    public static Color getMixedColor(Color c1, float pct1, Color c2, float pct2) {
        float[] clr1 = c1.getComponents(null);
        float[] clr2 = c2.getComponents(null);
        int i = 0;
        while (i < clr1.length) {
            clr1[i] = clr1[i] * pct1 + clr2[i] * pct2;
            ++i;
        }
        return new Color(clr1[0], clr1[1], clr1[2], clr1[3]);
    }

    public static void paintHVDepressedLine(Graphics2D graphics, int x1, int y1, int x2, int y2, int depressionLength, Color background, Color foreground) {
        if (x1 == x2) {
            GradientPaint paint = new GradientPaint(x1, y1, background, x1, y1 + depressionLength, foreground);
            graphics.setPaint(paint);
            graphics.drawLine(x1, y1, x1, y1 + depressionLength);
            graphics.setPaint(foreground);
            graphics.drawLine(x1, y1 + depressionLength, x1, y2 - depressionLength);
            paint = new GradientPaint(x1, y2 - depressionLength, foreground, x1, y2, background);
            graphics.setPaint(paint);
            graphics.drawLine(x1, y2 - depressionLength, x1, y2);
        } else {
            GradientPaint paint = new GradientPaint(x1, y1, background, x1 + depressionLength, y1, foreground);
            graphics.setPaint(paint);
            graphics.drawLine(x1, y1, x1 + depressionLength, y1);
            graphics.setPaint(foreground);
            graphics.drawLine(x1 + depressionLength, y1, x2 - depressionLength, y1);
            paint = new GradientPaint(x2 - depressionLength, y1, foreground, x2, y1, background);
            graphics.setPaint(paint);
            graphics.drawLine(x2 - depressionLength, y1, x2, y1);
        }
    }

    public static void paintArrow(Graphics g, int x, int y, int width, int height, int direction, Paint foreground) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath path = new GeneralPath();
        switch (direction) {
            case 1: {
                path.moveTo(0.0f, height);
                path.lineTo(width, height);
                path.lineTo(width / 2, 0.0f);
                break;
            }
            case 5: {
                path.moveTo(0.0f, 0.0f);
                path.lineTo(width, 0.0f);
                path.lineTo(width / 2, height);
                break;
            }
            case 7: {
                path.moveTo(0.0f, height / 2);
                path.lineTo(width, 0.0f);
                path.lineTo(width, height);
                break;
            }
            case 3: {
                path.moveTo(0.0f, 0.0f);
                path.lineTo(width, height / 2);
                path.lineTo(0.0f, height);
            }
        }
        path.closePath();
        graphics.translate(x, y);
        graphics.setPaint(foreground);
        graphics.fill(path);
        graphics.dispose();
    }

    public static void paintCheck(Graphics g, Paint foreground, int x, int y, int width, int height) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.translate(x, y);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke stroke = new BasicStroke(1.5f, 1, 2);
        GeneralPath path = new GeneralPath();
        int w = width - x;
        int h = height - y;
        path.moveTo(0.0f, 0.45f * (float)h);
        path.lineTo(0.35f * (float)w, h - 1);
        path.quadTo(0.45f * (float)w, 0.45f * (float)h, w - 1, 0.0f);
        graphics.setStroke(stroke);
        graphics.setPaint(foreground);
        graphics.draw(path);
        graphics.dispose();
    }

    public static void drawWindow(Graphics2D g2d, int x, int y, int w, int h, boolean titleVisible) {
        g2d.drawRect(x, y, w - 1, h - 1);
        if (titleVisible) {
            g2d.drawLine(x + 1, y + 1, x + w - 2, y + 1);
        }
    }
}

