/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf.style;

import a03.swing.plaf.A03ComboBoxDelegate;
import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.style.A03ComboBoxStyle;
import a03.swing.plaf.style.A03StyledGraphicsUtilities;
import a03.swing.plaf.style.A03StyledSwingUtilities;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import javax.swing.JComboBox;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;

public class A03StyledComboBoxDelegate
implements A03ComboBoxDelegate {
    private A03ComboBoxStyle style;

    public A03StyledComboBoxDelegate(A03ComboBoxStyle style) {
        this.style = style;
    }

    public FontUIResource getFont() {
        return new FontUIResource(this.style.getFont());
    }

    public ColorUIResource getBackground() {
        return new ColorUIResource(this.style.getBackgroundColor());
    }

    public ColorUIResource getForeground() {
        return new ColorUIResource(this.style.getForegroundColor());
    }

    public ColorUIResource getSelectionForeground() {
        return new ColorUIResource(this.style.getSelectionForegroundColor());
    }

    public ColorUIResource getSelectionBackground() {
        return new ColorUIResource(this.style.getSelectionBackgroundColor());
    }

    public ColorUIResource getDisabledForeground() {
        return new ColorUIResource(this.style.getDisabledForegroundColor());
    }

    public ColorUIResource getDisabledBackground() {
        return new ColorUIResource(this.style.getDisabledBackgroundColor());
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 2;
        insets.bottom = 2;
        insets.left = 2;
        insets.right = 2;
        return insets;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JComboBox comboBox = (JComboBox)c;
        if (!comboBox.isPopupVisible() && (c.hasFocus() || comboBox.getEditor().getEditorComponent().hasFocus())) {
            Graphics2D graphics = (Graphics2D)g.create();
            A03StyledGraphicsUtilities.paintBorderShadow(graphics, 3, A03GraphicsUtilities.createRoundRectangle(x, y, width - 1, height - 1, 3.0f), this.style.getFocusColor(), c.getBackground());
            graphics.dispose();
            return;
        }
        A03StyledSwingUtilities.paintShadowedBorder(c, g, x, y, width, height, c.getBackground());
    }

    public Insets getArrowBorderInsets(Component c, Insets insets) {
        insets.top = 1;
        insets.bottom = 1;
        insets.left = 1;
        insets.right = 1;
        return insets;
    }

    public InsetsUIResource getArrowMargin() {
        return null;
    }

    public void paintArrowBackground(Component c, Graphics g) {
        int width = c.getWidth();
        int height = c.getHeight();
        Paint arrowBackground = this.style.getArrowBackgroundPaint(A03StyledSwingUtilities.getState(c), 0, 0, width, height);
        if (arrowBackground != null) {
            Graphics2D graphics = (Graphics2D)g;
            graphics.setPaint(arrowBackground);
            graphics.drawRect(0, 0, width, height);
        }
    }

    public void paintArrowBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Paint arrowBorder = this.style.getArrowBorderPaint(A03StyledSwingUtilities.getState(c), x, y, width, height);
        if (arrowBorder != null) {
            Graphics2D graphics = (Graphics2D)g;
            graphics.setPaint(arrowBorder);
            graphics.drawRect(0, 0, width - 1, height - 1);
        }
    }

    public void paintArrow(Component c, Graphics g, int direction) {
        int size;
        int width = c.getWidth();
        int height = c.getHeight();
        if (height < (size = 8) || width < size) {
            return;
        }
        int x = (width - size) / 2;
        int y = (height - size / 2) / 2;
        A03StyledGraphicsUtilities.paintArrow(g, x, y, size, size / 2, direction, this.style.getArrowPaint(1, direction, x, y, width, height));
    }
}

