/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plaf.A03TreeDelegate;
import a03.swing.plugin.A03PluginManager;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Enumeration;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class A03TreeUI
extends BasicTreeUI {
    private A03TreeDelegate delegate;

    public static ComponentUI createUI(JComponent c) {
        return new A03TreeUI();
    }

    public void installUI(JComponent c) {
        this.delegate = (A03TreeDelegate)A03SwingUtilities.getDelegate(c, UIManager.get("Tree.delegate"));
        super.installUI(c);
        A03PluginManager.getInstance().registerComponent(c);
    }

    public void uninstallUI(JComponent c) {
        A03PluginManager.getInstance().unregisterComponent(c);
        super.uninstallUI(c);
    }

    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.editingComponent != null && this.editingRow == row) {
            return;
        }
        boolean hasFocus = this.tree.hasFocus() && row == this.getRowForPath(this.tree, this.tree.getLeadSelectionPath());
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, path.getLastPathComponent(), this.tree.isRowSelected(row), isExpanded, isLeaf, row, hasFocus);
        boolean isSelected = this.tree.isRowSelected(row);
        if (isSelected) {
            component.setForeground(this.delegate.getSelectionForeground());
        } else {
            component.setForeground(this.delegate.getForeground(this.tree, row));
        }
        this.rendererPane.paintComponent(g, component, this.tree, bounds.x, bounds.y, bounds.width, bounds.height, true);
    }

    public void paint(Graphics g, JComponent c) {
        Graphics2D graphics;
        block8: {
            if (this.treeState == null) {
                return;
            }
            Rectangle paintBounds = g.getClipBounds();
            TreePath initialPath = this.getClosestPathForLocation(this.tree, 0, paintBounds.y);
            Enumeration<TreePath> paintingEnumerator = this.treeState.getVisiblePathsFrom(initialPath);
            int row = this.treeState.getRowForPath(initialPath);
            int endY = paintBounds.y + paintBounds.height;
            graphics = (Graphics2D)g.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            try {
                Rectangle bounds = this.treeState.getBounds(initialPath, new Rectangle());
                int y = bounds != null ? bounds.y : 0;
                Insets insets = this.tree.getInsets();
                if (insets != null && y == 0 && insets.top > 0) {
                    graphics.setColor(this.delegate.getBackground(this.tree, 1));
                    graphics.fillRect(0, 0, this.tree.getWidth(), insets.top);
                    y += insets.top;
                }
                if (initialPath == null || paintingEnumerator == null) break block8;
                while (paintingEnumerator.hasMoreElements()) {
                    boolean isSelected = this.tree.isRowSelected(row);
                    if (isSelected) {
                        graphics.setColor(this.delegate.getSelectionBackground());
                    } else {
                        graphics.setColor(this.delegate.getBackground(this.tree, row));
                    }
                    int rowHeight = this.getRowHeight(row);
                    graphics.fillRect(0, y, this.tree.getWidth(), rowHeight);
                    if ((y += rowHeight) < endY) {
                        ++row;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        super.paint(graphics, c);
        graphics.dispose();
    }

    private int getRowHeight(int row) {
        int rowHeight = this.tree.getRowHeight();
        if (rowHeight <= 0) {
            Rectangle rowBounds = this.tree.getRowBounds(row);
            rowHeight = rowBounds != null ? rowBounds.height : 16;
        }
        return rowHeight;
    }
}

