/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03IconFactory;
import a03.swing.plaf.A03RootPaneDelegate;
import a03.swing.plaf.A03RootPaneUI;
import a03.swing.plaf.A03SwingUtilities;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class A03TitlePane
extends JComponent {
    private static final long serialVersionUID = -6091035432229915453L;
    private static final int ICON_SIZE = 16;
    private PropertyChangeListener propertyChangeListener;
    protected JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    protected JButton toggleButton;
    protected JButton minimizeButton;
    protected JButton closeButton;
    private WindowListener windowListener;
    protected Window window;
    protected JRootPane rootPane;
    private int state;
    private boolean active;
    private A03RootPaneUI rootPaneUI;
    private A03RootPaneDelegate uiDelegate;

    public A03TitlePane(JRootPane root, A03RootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.uiDelegate = (A03RootPaneDelegate)A03SwingUtilities.getDelegate(root, UIManager.get("RootPane.delegate"));
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
        this.setToolTipText(this.getTitle());
    }

    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
    }

    public void uninstall() {
        this.uninstallListeners();
        this.window = null;
        if (this.menuBar != null && this.menuBar.getMenuCount() > 0) {
            this.menuBar.getUI().uninstallUI(this.menuBar);
        }
        if (this.menuBar != null) {
            this.menuBar.removeAll();
        }
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = new WindowHandler();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = new PropertyChangeHandler();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.windowListener = null;
            this.window.removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected int getWindowDecorationStyle() {
        return this.rootPane.getWindowDecorationStyle();
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            this.setActive(this.window.isActive());
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.installListeners();
        }
        this.setToolTipText(this.getTitle());
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstall();
        this.window = null;
    }

    protected void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            if (this.menuBar != null) {
                this.add(this.menuBar);
            }
            this.minimizeButton = this.createTitleButton(this.iconifyAction);
            this.add(this.minimizeButton);
            this.toggleButton = this.createTitleButton(this.restoreAction);
            this.add(this.toggleButton);
            this.closeButton = this.createTitleButton(this.closeAction);
            this.add(this.closeButton);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.closeButton = this.createTitleButton(this.closeAction);
            this.add(this.closeButton);
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("RootPane.titleFont", this.getLocale()));
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new A03MenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        this.menuBar.setOpaque(false);
        this.menuBar.applyComponentOrientation(this.rootPane.getComponentOrientation());
        return this.menuBar;
    }

    public JMenu getMenu() {
        return (JMenu)this.menuBar.getComponent(0);
    }

    protected void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu menu = new JMenu("AAAA");
        menu.setOpaque(false);
        menu.setBackground(null);
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(menu);
        }
        return menu;
    }

    private void addMenuItems(JMenu menu) {
        menu.add(this.restoreAction);
        menu.add(this.iconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(this.maximizeAction);
        }
        menu.addSeparator();
        menu.add(this.closeAction);
    }

    private JButton createTitleButton(Action action) {
        JButton button = new JButton(action);
        button.setText(null);
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        button.setContentAreaFilled(false);
        button.setBorderPainted(false);
        button.setBorder(null);
        button.putClientProperty("paintActive", Boolean.TRUE);
        return button;
    }

    protected LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.getWindowDecorationStyle() == 1) {
            this.closeButton.putClientProperty("paintActive", active);
            this.minimizeButton.putClientProperty("paintActive", active);
            this.toggleButton.putClientProperty("paintActive", active);
        }
        this.rootPane.repaint();
    }

    public boolean isActive() {
        return this.active;
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window w = this.getWindow();
        if (w != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                if ((state & 6) != 0 && (this.rootPane.getBorder() == null || this.rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    this.rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(this.rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.restoreAction);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.minimizeButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.minimizeButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.minimizeButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action) {
        this.toggleButton.setAction(action);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    protected String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    public void paintComponent(Graphics g) {
        String clippedTitle;
        Window window;
        Font font = this.getFont();
        FontMetrics fm = this.rootPane.getFontMetrics(font);
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        boolean leftToRight = (window = this.getWindow()) == null ? this.rootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight();
        int xOffset = 0;
        String theTitle = this.getTitle();
        if (leftToRight) {
            xOffset = 5;
            int leftEnd = this.getTitleGap();
            xOffset += leftEnd;
            JButton leftmostButton = null;
            if (this.minimizeButton != null && this.minimizeButton.getParent() != null && this.minimizeButton.getBounds().width != 0) {
                leftmostButton = this.minimizeButton;
            } else if (this.toggleButton != null && this.toggleButton.getParent() != null && this.toggleButton.getBounds().width != 0) {
                leftmostButton = this.toggleButton;
            } else if (this.closeButton != null && this.closeButton.getParent() != null) {
                leftmostButton = this.closeButton;
            }
            int rightEnd = this.getWidth();
            if (leftmostButton != null) {
                Rectangle rect = leftmostButton.getBounds();
                rightEnd = rect.getBounds().x - 5;
                --rightEnd;
            }
            if (theTitle != null) {
                int titleWidth = rightEnd - leftEnd - 20;
                clippedTitle = A03GraphicsUtilities.clipString(fm, titleWidth, theTitle);
                if (theTitle.equals(clippedTitle)) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(theTitle);
                }
                theTitle = clippedTitle;
            }
        } else {
            xOffset = width - 5;
            int rightEnd = this.getTitleGap();
            JButton rightmostButton = null;
            if (this.minimizeButton != null && this.minimizeButton.getParent() != null && this.minimizeButton.getBounds().width != 0) {
                rightmostButton = this.minimizeButton;
            } else if (this.toggleButton != null && this.toggleButton.getParent() != null && this.toggleButton.getBounds().width != 0) {
                rightmostButton = this.toggleButton;
            } else if (this.closeButton != null && this.closeButton.getParent() != null) {
                rightmostButton = this.closeButton;
            }
            int leftEnd = 5;
            if (rightmostButton != null) {
                Rectangle rect = rightmostButton.getBounds();
                leftEnd = (int)rect.getBounds().getMaxX() + 5;
                ++leftEnd;
            }
            if (theTitle != null) {
                int titleWidth = rightEnd - leftEnd - 20;
                clippedTitle = A03GraphicsUtilities.clipString(fm, titleWidth, theTitle);
                if (theTitle.equals(clippedTitle)) {
                    this.setToolTipText(null);
                } else {
                    this.setToolTipText(theTitle);
                }
                theTitle = clippedTitle;
                xOffset = rightEnd - fm.stringWidth(theTitle);
            }
        }
        Graphics2D graphics = (Graphics2D)g.create();
        A03GraphicsUtilities.installDesktopHints(graphics);
        graphics.setFont(font);
        this.paintTitleBackground(this.rootPane, graphics);
        Frame frame = this.getFrame();
        if (theTitle != null) {
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            if (frame != null && (this.state & 6) != 0 && (this.rootPane.getBorder() == null || this.rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                yOffset += 2;
            }
            this.paintTitleText(this.rootPane, graphics, theTitle, xOffset, yOffset);
        }
        graphics.dispose();
    }

    protected int getTitleGap() {
        boolean leftToRight;
        boolean bl = leftToRight = this.window == null ? this.rootPane.getComponentOrientation().isLeftToRight() : this.window.getComponentOrientation().isLeftToRight();
        if (leftToRight) {
            return this.menuBar == null ? 0 : this.menuBar.getWidth() + 10;
        }
        int width = this.getWidth();
        return this.menuBar == null ? width - 5 : width - 5 - this.menuBar.getWidth() - 10;
    }

    public void paintTitleBackground(Component c, Graphics g) {
        this.uiDelegate.paintTitleBackground(c, g);
    }

    public void paintTitleText(Component c, Graphics g, String text, int x, int y) {
        this.uiDelegate.paintTitleText(c, g, text, x, y);
    }

    public class A03MenuBar
    extends JMenuBar {
        private static final long serialVersionUID = 2670977328234306661L;

        public void paint(Graphics g) {
            Image image;
            Graphics2D graphics = (Graphics2D)g.create();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            Frame frame = A03TitlePane.this.getFrame();
            Image image2 = image = frame != null ? frame.getIconImage() : null;
            if (image != null) {
                int iSize = 16;
                double coef = Math.max((double)iSize / (double)image.getWidth(null), (double)iSize / (double)image.getHeight(null));
                if (coef < 1.0) {
                    graphics.drawImage(image, 0, 0, (int)(coef * (double)image.getWidth(null)), (int)(coef * (double)image.getHeight(null)), null);
                } else {
                    graphics.drawImage(image, 0, 0, null);
                }
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, graphics, 0, 0);
                }
            }
            graphics.dispose();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            int iSize = 16;
            return new Dimension(Math.max(iSize, size.width), Math.max(size.height, iSize));
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 8521842796715771159L;

        public CloseAction() {
            super("Close", A03IconFactory.createCloseIcon(A03TitlePane.this.uiDelegate));
        }

        public void actionPerformed(ActionEvent e) {
            Window window = A03TitlePane.this.getWindow();
            if (window != null) {
                window.dispatchEvent(new WindowEvent(window, 201));
            }
        }
    }

    private class IconifyAction
    extends AbstractAction {
        private static final long serialVersionUID = -4395756725217884481L;

        public IconifyAction() {
            super("Iconify", A03IconFactory.createIconifyIcon(A03TitlePane.this.uiDelegate));
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = A03TitlePane.this.getFrame();
            if (frame != null) {
                frame.setExtendedState(A03TitlePane.this.state | 1);
            }
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        private static final long serialVersionUID = -3579085010778225542L;

        public MaximizeAction() {
            super("Maximize", A03IconFactory.createMaximizeIcon(A03TitlePane.this.uiDelegate));
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = A03TitlePane.this.getFrame();
            if (frame != null) {
                frame.setExtendedState(A03TitlePane.this.state | 6);
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = A03TitlePane.this.getFrame();
                if (frame != null) {
                    A03TitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    A03TitlePane.this.rootPane.repaint();
                }
            } else if ("title".equals(name)) {
                A03TitlePane.this.repaint();
                A03TitlePane.this.setToolTipText((String)pce.getNewValue());
            } else if ("componentOrientation".equals(name) || "iconImage".equals(name)) {
                A03TitlePane.this.revalidate();
                A03TitlePane.this.repaint();
            }
        }
    }

    private class RestoreAction
    extends AbstractAction {
        private static final long serialVersionUID = -504362595084463134L;

        public RestoreAction() {
            super("Restore", A03IconFactory.createMinimizeIcon(A03TitlePane.this.uiDelegate));
        }

        public void actionPerformed(ActionEvent e) {
            Frame frame = A03TitlePane.this.getFrame();
            if (frame == null) {
                return;
            }
            if ((A03TitlePane.this.state & 1) != 0) {
                frame.setExtendedState(A03TitlePane.this.state & 0xFFFFFFFE);
            } else {
                frame.setExtendedState(A03TitlePane.this.state & 0xFFFFFFF9);
            }
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        protected int computeHeight() {
            FontMetrics fm = A03TitlePane.this.rootPane.getFontMetrics(A03TitlePane.this.getFont());
            int height = fm.getHeight();
            Frame frame = A03TitlePane.this.getFrame();
            height = frame != null && frame.isShowing() && (A03TitlePane.this.state & 6) != 0 && (A03TitlePane.this.rootPane.getBorder() == null || A03TitlePane.this.rootPane.getBorder() instanceof UIResource) ? (height += 7) : (height += 5);
            if (A03TitlePane.this.getWindowDecorationStyle() == 1) {
                height = Math.max(height, 16);
            }
            return height;
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public void layoutContainer(Container c) {
            int buttonWidth;
            int buttonHeight;
            boolean leftToRight = A03TitlePane.this.window == null ? A03TitlePane.this.rootPane.getComponentOrientation().isLeftToRight() : A03TitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = A03TitlePane.this.getWidth();
            if (A03TitlePane.this.closeButton != null && A03TitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = A03TitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = A03TitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            int y = (A03TitlePane.this.getHeight() - buttonHeight) / 2;
            Frame frame = A03TitlePane.this.getFrame();
            if (frame != null && frame.isShowing() && (A03TitlePane.this.state & 6) != 0 && (A03TitlePane.this.rootPane.getBorder() == null || A03TitlePane.this.rootPane.getBorder() instanceof UIResource)) {
                y += 3;
            }
            int x = leftToRight ? w : 0;
            int spacing = 5;
            int n = x = leftToRight ? spacing : w - buttonWidth - spacing;
            if (A03TitlePane.this.menuBar != null) {
                A03TitlePane.this.menuBar.setBounds(x, y, buttonWidth, buttonHeight);
            }
            x = leftToRight ? w : 0;
            spacing = 4;
            x += leftToRight ? -spacing - buttonWidth : spacing;
            if (A03TitlePane.this.closeButton != null) {
                A03TitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            if (A03TitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && A03TitlePane.this.toggleButton.getParent() != null) {
                    spacing = 10;
                    A03TitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (A03TitlePane.this.minimizeButton != null && A03TitlePane.this.minimizeButton.getParent() != null) {
                    spacing = 2;
                    A03TitlePane.this.minimizeButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        public void windowActivated(WindowEvent ev) {
            A03TitlePane.this.setActive(true);
            A03TitlePane.this.setBackground(A03TitlePane.this.uiDelegate.getTitleBackground(A03TitlePane.this.rootPane));
        }

        public void windowDeactivated(WindowEvent ev) {
            A03TitlePane.this.setActive(false);
            A03TitlePane.this.setBackground(A03TitlePane.this.uiDelegate.getTitleBackground(A03TitlePane.this.rootPane));
        }
    }
}

