/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plugin.A03PluginManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class A03TextAreaUI
extends BasicTextAreaUI {
    public static ComponentUI createUI(JComponent c) {
        return new A03TextAreaUI();
    }

    protected void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().equals("editable") || evt.getPropertyName().equals("enabled")) {
            this.updateBackground((JTextComponent)evt.getSource());
        } else if (evt.getPropertyName().equals("componentOrientation")) {
            this.getComponent().setText(this.getComponent().getText());
        }
    }

    private void updateBackground(JTextComponent c) {
        Color background = c.getBackground();
        if (background instanceof UIResource) {
            String prefix = this.getPropertyPrefix();
            Color disabledBG = UIManager.getColor(String.valueOf(prefix) + ".disabledBackground");
            Color inactiveBG = UIManager.getColor(String.valueOf(prefix) + ".inactiveBackground");
            Color bg = UIManager.getColor(String.valueOf(prefix) + ".background");
            Color newColor = null;
            if (!c.isEnabled()) {
                newColor = disabledBG;
            }
            if (newColor == null && !c.isEditable()) {
                newColor = inactiveBG;
            }
            if (newColor == null) {
                newColor = bg;
            }
            if (newColor != null && newColor != background) {
                c.setBackground(newColor);
            }
        } else {
            c.setBackground(background);
        }
    }

    protected void installDefaults() {
        super.installDefaults();
        this.updateBackground(this.getComponent());
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        A03PluginManager.getInstance().registerComponent(this.getComponent());
    }

    public void uninstallUI(JComponent c) {
        A03PluginManager.getInstance().unregisterComponent(this.getComponent());
        super.uninstallUI(c);
    }

    protected void paintSafely(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        A03GraphicsUtilities.installDesktopHints(graphics);
        super.paintSafely(graphics);
        graphics.dispose();
    }

    public void update(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        A03GraphicsUtilities.installDesktopHints(graphics);
        this.paint(graphics, c);
        graphics.dispose();
    }
}

