/*
 * Decompiled with CFR 0.152.
 */
package a03.swing.plaf;

import a03.swing.plaf.A03ArrowButton;
import a03.swing.plaf.A03Constants;
import a03.swing.plaf.A03GraphicsUtilities;
import a03.swing.plaf.A03SwingUtilities;
import a03.swing.plaf.A03TabbedPaneDelegate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.lang.reflect.Field;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class A03TabbedPaneUI
extends BasicTabbedPaneUI {
    private static Field tabScrollerField = null;
    private static Field viewportField = null;
    private A03TabbedPaneDelegate delegate;

    public static ComponentUI createUI(JComponent c) {
        return new A03TabbedPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.delegate = (A03TabbedPaneDelegate)A03SwingUtilities.getDelegate(c, UIManager.get("TabbedPane.delegate"));
    }

    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        this.delegate.paintTabBackground(g, this.tabPane, tabPlacement, tabIndex, x, y, w, h, isSelected);
    }

    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        this.delegate.paintTabBorder(g, this.tabPane, tabPlacement, tabIndex, x, y, w, h, isSelected);
    }

    protected JButton createScrollButton(int direction) {
        if (direction != 5 && direction != 1 && direction != 3 && direction != 7) {
            throw new IllegalArgumentException("Direction must be one of: SOUTH, NORTH, EAST or WEST");
        }
        return new A03ArrowButton(direction, this.delegate);
    }

    protected int calculateTabHeight(int tabPlacement, int tabIndex, int fontHeight) {
        boolean toSwap;
        boolean bl = toSwap = tabPlacement == 2 || tabPlacement == 4;
        if (toSwap) {
            return super.calculateTabWidth(tabPlacement, tabIndex, this.getFontMetrics());
        }
        return super.calculateTabHeight(tabPlacement, tabIndex, fontHeight);
    }

    protected int calculateTabWidth(int tabPlacement, int tabIndex, FontMetrics metrics) {
        boolean toSwap;
        boolean bl = toSwap = tabPlacement == 2 || tabPlacement == 4;
        if (toSwap) {
            return super.calculateTabHeight(tabPlacement, tabIndex, metrics.getHeight());
        }
        int result = super.calculateTabWidth(tabPlacement, tabIndex, metrics);
        return result;
    }

    protected int calculateMaxTabHeight(int tabPlacement) {
        if (tabPlacement == 1 || tabPlacement == 3) {
            return super.calculateMaxTabHeight(tabPlacement);
        }
        int result = 0;
        int i = 0;
        while (i < this.tabPane.getTabCount()) {
            result = Math.max(result, this.calculateTabHeight(tabPlacement, i, this.getFontMetrics().getHeight()));
            ++i;
        }
        return result;
    }

    protected void paintTab(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect) {
        boolean toSwap;
        boolean bl = toSwap = tabPlacement == 2 || tabPlacement == 4;
        if (toSwap) {
            if (A03Constants.IS_JAVA_6_OR_LATER && this.tabPane.getTabComponentAt(tabIndex) != null) {
                throw new IllegalComponentStateException("A03 look and feel does not support custom tab components on left and right placement.");
            }
            Graphics2D tempG = (Graphics2D)g.create();
            Rectangle tabRect = rects[tabIndex];
            Rectangle correctRect = new Rectangle(tabRect.x, tabRect.y, tabRect.height, tabRect.width);
            if (tabPlacement == 2) {
                tempG.rotate(-1.5707963267948966, tabRect.x, tabRect.y);
                tempG.translate(-tabRect.height, 0);
            } else {
                tempG.rotate(1.5707963267948966, tabRect.x, tabRect.y);
                tempG.translate(0.0, -tabRect.getWidth());
            }
            tempG.setColor(Color.red);
            rects[tabIndex] = correctRect;
            super.paintTab(tempG, tabPlacement, rects, tabIndex, iconRect, textRect);
            rects[tabIndex] = tabRect;
            tempG.dispose();
        } else {
            super.paintTab(g, tabPlacement, rects, tabIndex, iconRect, textRect);
        }
    }

    protected void paintTabArea(Graphics g, int tabPlacement, int selectedIndex) {
        int height;
        int width;
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            switch (tabPlacement) {
                case 1: {
                    width = this.tabPane.getWidth();
                    height = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                    break;
                }
                case 2: {
                    width = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                    height = this.tabPane.getHeight();
                    break;
                }
                case 3: {
                    width = this.tabPane.getWidth();
                    height = this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                    break;
                }
                default: {
                    width = this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                    height = this.tabPane.getHeight();
                    break;
                }
            }
        } else {
            JViewport viewport = A03TabbedPaneUI.getTabScrollerViewport(this);
            Component view = viewport.getView();
            Dimension size = view.getSize();
            width = size.width;
            height = size.height;
        }
        this.delegate.paintTabAreaBackground(g, this.tabPane, width, height);
        super.paintTabArea(g, tabPlacement, selectedIndex);
    }

    private static JViewport getTabScrollerViewport(TabbedPaneUI tabbedPaneUI) {
        try {
            if (tabScrollerField == null) {
                tabScrollerField = BasicTabbedPaneUI.class.getDeclaredField("tabScroller");
                tabScrollerField.setAccessible(true);
            }
            Object tabScroller = tabScrollerField.get(tabbedPaneUI);
            if (viewportField == null) {
                viewportField = tabScroller.getClass().getDeclaredField("viewport");
                viewportField.setAccessible(true);
            }
            return (JViewport)viewportField.get(tabScroller);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void ensureCurrentLayout() {
        if (!this.tabPane.isValid()) {
            this.tabPane.validate();
        }
        if (!this.tabPane.isValid()) {
            LayoutManager lm = this.tabPane.getLayout();
            BasicTabbedPaneUI.TabbedPaneLayout layout = (BasicTabbedPaneUI.TabbedPaneLayout)lm;
            layout.calculateLayoutInfo();
        }
    }

    protected int getTabLabelShiftX(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    protected int getTabLabelShiftY(int tabPlacement, int tabIndex, boolean isSelected) {
        return 0;
    }

    public Rectangle getTabRectangle(int tabIndex) {
        return this.rects[tabIndex];
    }

    protected boolean shouldPadTabRun(int tabPlacement, int run) {
        return this.runCount > 1 && run < this.runCount - 1;
    }

    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 1) {
            return super.createLayoutManager();
        }
        return new TabbedPaneLayout();
    }

    protected void paintContentBorder(Graphics g, int tabPlacement, int selectedIndex) {
        int width = this.tabPane.getWidth();
        int height = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        Insets tabAreaInsets = this.getTabAreaInsets(tabPlacement);
        int x = insets.left;
        int y = insets.top;
        int w = width - insets.right - insets.left;
        int h = height - insets.top - insets.bottom;
        boolean tabsOverlapBorder = UIManager.getBoolean("TabbedPane.tabsOverlapBorder");
        switch (tabPlacement) {
            case 2: {
                x += this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (tabsOverlapBorder) {
                    x -= tabAreaInsets.right;
                }
                w -= x - insets.left;
                break;
            }
            case 4: {
                w -= this.calculateTabAreaWidth(tabPlacement, this.runCount, this.maxTabWidth);
                if (!tabsOverlapBorder) break;
                w += tabAreaInsets.left;
                break;
            }
            case 3: {
                h -= this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (!tabsOverlapBorder) break;
                h += tabAreaInsets.top;
                break;
            }
            default: {
                y += this.calculateTabAreaHeight(tabPlacement, this.runCount, this.maxTabHeight);
                if (tabsOverlapBorder) {
                    y -= tabAreaInsets.bottom;
                }
                h -= y - insets.top;
            }
        }
        boolean contentOpaque = UIManager.getBoolean("TabbedPane.contentOpaque");
        if (this.tabPane.getTabCount() > 0 && (contentOpaque || this.tabPane.isOpaque())) {
            Color color = UIManager.getColor("TabbedPane.contentAreaColor");
            g.setColor(color);
            g.fillRect(x, y, w, h);
        }
        Rectangle selRect = selectedIndex < 0 ? null : this.getTabBounds(selectedIndex, this.calcRect);
        this.delegate.paintTabbedPaneContentBorder(g, this.tabPane, tabPlacement, selectedIndex, x, y, w, h, selRect);
    }

    public Rectangle getTabBounds(JTabbedPane pane, int i) {
        this.ensureCurrentLayout();
        Rectangle tabRect = new Rectangle();
        return this.getTabBounds(i, tabRect);
    }

    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        A03GraphicsUtilities.installDesktopHints(graphics);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(graphics, textRect);
        } else {
            int x = textRect.x;
            int y = textRect.y + metrics.getAscent();
            graphics.setFont(font);
            this.delegate.paintTabText(graphics, this.tabPane, tabPlacement, tabIndex, title, x, y, isSelected);
        }
        graphics.dispose();
    }

    public void update(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        if (c.isOpaque()) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics.setColor(c.getBackground());
            graphics.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paint(graphics, c);
        graphics.dispose();
    }

    public class TabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        public TabbedPaneLayout() {
            super(A03TabbedPaneUI.this);
        }

        protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
            if (tabPlacement == 1 || tabPlacement == 3) {
                super.normalizeTabRuns(tabPlacement, tabCount, start, max);
            }
        }

        protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        }
    }
}

